/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.Application;
import org.apache.cxf.Bus;
import org.apache.cxf.BusException;
import org.apache.cxf.common.classloader.ClassLoaderUtils;
import org.apache.cxf.endpoint.Endpoint;
import org.apache.cxf.endpoint.EndpointException;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.endpoint.ServerImpl;
import org.apache.cxf.feature.Feature;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.AbstractJAXRSFactoryBean;
import org.apache.cxf.jaxrs.JAXRSServiceFactoryBean;
import org.apache.cxf.jaxrs.ext.ResourceComparator;
import org.apache.cxf.jaxrs.impl.RequestPreprocessor;
import org.apache.cxf.jaxrs.lifecycle.PerRequestResourceProvider;
import org.apache.cxf.jaxrs.lifecycle.ResourceProvider;
import org.apache.cxf.jaxrs.model.ClassResourceInfo;
import org.apache.cxf.jaxrs.model.ProviderInfo;
import org.apache.cxf.jaxrs.provider.ProviderFactory;
import org.apache.cxf.jaxrs.utils.AnnotationUtils;
import org.apache.cxf.jaxrs.utils.InjectionUtils;
import org.apache.cxf.service.factory.FactoryBeanListener;
import org.apache.cxf.service.factory.ServiceConstructionException;
import org.apache.cxf.service.invoker.Invoker;

public class JAXRSServerFactoryBean
extends AbstractJAXRSFactoryBean {
    protected Map<Class<?>, ResourceProvider> resourceProviders = new HashMap();
    private Server server;
    private boolean start = true;
    private Map<Object, Object> languageMappings;
    private Map<Object, Object> extensionMappings;
    private ResourceComparator rc;
    private ProviderInfo<Application> appProvider;
    private String documentLocation;

    public JAXRSServerFactoryBean() {
        this(new JAXRSServiceFactoryBean());
    }

    public JAXRSServerFactoryBean(JAXRSServiceFactoryBean sf) {
        super(sf);
    }

    public void setApplication(Application app) {
        this.appProvider = new ProviderInfo<Application>(app, this.getBus());
        List<String> appNameBindings = AnnotationUtils.getNameBindings(app.getClass().getAnnotations());
        for (ClassResourceInfo cri : this.getServiceFactory().getClassResourceInfo()) {
            LinkedList<String> clsNameBindings = new LinkedList<String>(appNameBindings);
            clsNameBindings.addAll(AnnotationUtils.getNameBindings(cri.getServiceClass().getAnnotations()));
            cri.setNameBindings(clsNameBindings);
        }
    }

    public void setResourceComparator(ResourceComparator rcomp) {
        this.rc = rcomp;
    }

    public void setStaticSubresourceResolution(boolean enableStatic) {
        this.serviceFactory.setEnableStaticResolution(enableStatic);
    }

    public void init() {
        if (this.server == null) {
            this.create();
        }
    }

    public Server create() {
        block17: {
            ClassLoaderUtils.ClassLoaderHolder origLoader = null;
            try {
                Bus bus = this.getBus();
                ClassLoader loader = bus.getExtension(ClassLoader.class);
                if (loader != null) {
                    origLoader = ClassLoaderUtils.setThreadContextClassloader(loader);
                }
                this.serviceFactory.setBus(bus);
                this.checkResources(true);
                if (this.serviceFactory.getService() == null) {
                    this.serviceFactory.create();
                    this.updateClassResourceProviders();
                }
                Endpoint ep = this.createEndpoint();
                this.getServiceFactory().sendEvent(FactoryBeanListener.Event.PRE_SERVER_CREATE, this.server, null, null);
                this.server = new ServerImpl(this.getBus(), ep, this.getDestinationFactory(), this.getBindingFactory());
                Invoker invoker = this.serviceFactory.getInvoker();
                if (invoker == null) {
                    ep.getService().setInvoker(this.createInvoker());
                } else {
                    ep.getService().setInvoker(invoker);
                }
                ProviderFactory factory = this.setupFactory(ep);
                ep.put(Application.class.getName(), this.appProvider);
                factory.setApplicationProvider(this.appProvider);
                factory.setRequestPreprocessor(new RequestPreprocessor(this.languageMappings, this.extensionMappings));
                ep.put(Bus.class.getName(), this.getBus());
                if (this.documentLocation != null) {
                    ep.put("wadl.location", this.documentLocation);
                }
                if (this.rc != null) {
                    ep.put("org.apache.cxf.jaxrs.comparator", this.rc);
                }
                this.checkPrivateEndpoint(ep);
                factory.applyDynamicFeatures(this.getServiceFactory().getClassResourceInfo());
                this.applyFeatures();
                this.getServiceFactory().sendEvent(FactoryBeanListener.Event.SERVER_CREATED, this.server, null, null);
                if (!this.start) break block17;
                try {
                    this.server.start();
                }
                catch (RuntimeException re) {
                    this.server.destroy();
                    throw re;
                }
            }
            catch (EndpointException e) {
                throw new ServiceConstructionException(e);
            }
            catch (BusException e) {
                throw new ServiceConstructionException(e);
            }
            catch (IOException e) {
                throw new ServiceConstructionException(e);
            }
            catch (Exception e) {
                throw new ServiceConstructionException(e);
            }
            finally {
                if (origLoader != null) {
                    origLoader.reset();
                }
            }
        }
        return this.server;
    }

    public Server getServer() {
        return this.server;
    }

    @Override
    protected void setBeanInfo(ProviderFactory factory) {
        List<ClassResourceInfo> cris = this.serviceFactory.getClassResourceInfo();
        for (ClassResourceInfo cri : cris) {
            cri.initBeanParamInfo(factory);
        }
    }

    protected void applyFeatures() {
        if (this.getFeatures() != null) {
            for (Feature feature : this.getFeatures()) {
                feature.initialize(this.server, this.getBus());
            }
        }
    }

    protected Invoker createInvoker() {
        return this.serviceFactory.createInvoker();
    }

    public void setLanguageMappings(Map<Object, Object> lMaps) {
        this.languageMappings = lMaps;
    }

    public void setExtensionMappings(Map<Object, Object> extMaps) {
        this.extensionMappings = extMaps;
    }

    public List<Class<?>> getResourceClasses() {
        return this.serviceFactory.getResourceClasses();
    }

    public void setServiceClass(Class<?> clazz) {
        this.serviceFactory.setResourceClasses(clazz);
    }

    public void setResourceClasses(List<Class<?>> classes) {
        this.serviceFactory.setResourceClasses(classes);
    }

    public void setResourceClasses(Class<?> ... classes) {
        this.serviceFactory.setResourceClasses(classes);
    }

    public void setServiceBeanObjects(Object ... beans) {
        this.setServiceBeans(Arrays.asList(beans));
    }

    public void setServiceBean(Object bean) {
        this.setServiceBeans(Arrays.asList(bean));
    }

    public void setServiceBeans(List<Object> beans) {
        this.serviceFactory.setResourceClassesFromBeans(beans);
    }

    public void setResourceProvider(Class<?> c, ResourceProvider rp) {
        this.resourceProviders.put(c, rp);
    }

    public void setResourceProvider(ResourceProvider rp) {
        this.setResourceProviders(CastUtils.cast(Collections.singletonList(rp), ResourceProvider.class));
    }

    public void setResourceProviders(List<ResourceProvider> rps) {
        for (ResourceProvider rp : rps) {
            Class<?> c = rp.getResourceClass();
            this.setServiceClass(c);
            this.resourceProviders.put(c, rp);
        }
    }

    public void setInvoker(Invoker invoker) {
        this.serviceFactory.setInvoker(invoker);
    }

    public void setStart(boolean start) {
        this.start = start;
    }

    private void injectContexts() {
        Application application = this.appProvider == null ? null : this.appProvider.getProvider();
        for (ClassResourceInfo cri : this.serviceFactory.getClassResourceInfo()) {
            if (!cri.isSingleton()) continue;
            InjectionUtils.injectContextProxiesAndApplication(cri, cri.getResourceProvider().getInstance(null), application);
        }
        if (application != null) {
            InjectionUtils.injectContextProxiesAndApplication(this.appProvider, application, null);
        }
    }

    protected void updateClassResourceProviders() {
        for (ClassResourceInfo cri : this.serviceFactory.getClassResourceInfo()) {
            if (cri.getResourceProvider() != null) continue;
            ResourceProvider rp = this.resourceProviders.get(cri.getResourceClass());
            if (rp != null) {
                cri.setResourceProvider(rp);
                continue;
            }
            rp = new PerRequestResourceProvider(cri.getResourceClass());
            cri.setResourceProvider(rp);
        }
        this.injectContexts();
    }

    public void setDocLocation(String docLocation) {
        this.documentLocation = docLocation;
    }

    public String getDocLocation() {
        return this.documentLocation;
    }
}

