/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.oauth2.grants.code;

import java.util.Collections;
import java.util.List;
import org.apache.cxf.rs.security.oauth2.common.Client;
import org.apache.cxf.rs.security.oauth2.common.UserSubject;
import org.apache.cxf.rs.security.oauth2.grants.code.AuthorizationCodeGrant;
import org.apache.cxf.rs.security.oauth2.utils.OAuthUtils;

public class ServerAuthorizationCodeGrant
extends AuthorizationCodeGrant {
    private static final long serialVersionUID = -5004608901535459036L;
    private long issuedAt;
    private long lifetime;
    private Client client;
    private List<String> approvedScopes = Collections.emptyList();
    private UserSubject subject;
    private String audience;
    private String tempClientSecretHash;

    public ServerAuthorizationCodeGrant(Client client, long lifetime) {
        this(client, OAuthUtils.generateRandomTokenKey(), lifetime, System.currentTimeMillis() / 1000L);
    }

    public ServerAuthorizationCodeGrant(Client client, String code, long lifetime, long issuedAt) {
        super(code);
        this.client = client;
        this.lifetime = lifetime;
        this.issuedAt = issuedAt;
    }

    public long getIssuedAt() {
        return this.issuedAt;
    }

    public long getLifetime() {
        return this.lifetime;
    }

    public Client getClient() {
        return this.client;
    }

    public void setApprovedScopes(List<String> scopes) {
        this.approvedScopes = scopes;
    }

    public List<String> getApprovedScopes() {
        return this.approvedScopes;
    }

    public void setSubject(UserSubject subject) {
        this.subject = subject;
    }

    public UserSubject getSubject() {
        return this.subject;
    }

    public String getAudience() {
        return this.audience;
    }

    public void setAudience(String audience) {
        this.audience = audience;
    }

    public String getTempClientSecretHash() {
        return this.tempClientSecretHash;
    }

    public void setTempClientSecretHash(String tempClientSecretHash) {
        this.tempClientSecretHash = tempClientSecretHash;
    }
}

