/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.saml;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.apache.cxf.common.util.PropertyUtils;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;

public class DeflateEncoderDecoder {
    public InputStream inflateToken(byte[] deflatedToken) throws DataFormatException {
        Inflater inflater = new Inflater(true);
        inflater.setInput(deflatedToken);
        byte[] buffer = new byte[deflatedToken.length];
        ByteArrayOutputStream inflatedToken = new ByteArrayOutputStream();
        while (!inflater.finished()) {
            int inflateLen = inflater.inflate(buffer, 0, deflatedToken.length);
            if (inflateLen == 0 && !inflater.finished()) {
                if (!inflater.needsInput()) break;
                throw new DataFormatException("Inflater can not inflate all the token bytes");
            }
            inflatedToken.write(buffer, 0, inflateLen);
        }
        return new ByteArrayInputStream(inflatedToken.toByteArray());
    }

    public byte[] deflateToken(byte[] tokenBytes) {
        return this.deflateToken(tokenBytes, true);
    }

    public byte[] deflateToken(byte[] tokenBytes, boolean nowrap) {
        return this.deflateToken(tokenBytes, DeflateEncoderDecoder.getDeflateLevel(), nowrap);
    }

    public byte[] deflateToken(byte[] tokenBytes, int level, boolean nowrap) {
        Deflater compresser = new Deflater(level, nowrap);
        compresser.setInput(tokenBytes);
        compresser.finish();
        byte[] output = new byte[tokenBytes.length * 2];
        int compressedDataLength = compresser.deflate(output);
        byte[] result = new byte[compressedDataLength];
        System.arraycopy(output, 0, result, 0, compressedDataLength);
        return result;
    }

    private static int getDeflateLevel() {
        Integer level = null;
        Message m = PhaseInterceptorChain.getCurrentMessage();
        if (m != null) {
            level = PropertyUtils.getInteger(m, "deflate.level");
        }
        if (level == null) {
            level = 8;
        }
        return level;
    }
}

