/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.tools.wsdlto.frontend.jaxws.customization;

import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathConstants;
import org.apache.cxf.helpers.MapNamespaceContext;
import org.apache.cxf.helpers.XPathUtils;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public final class CustomNodeSelector {
    private static final Map<String, String> BINDING_NS_MAP = new HashMap<String, String>();
    private MapNamespaceContext context = new MapNamespaceContext();

    public CustomNodeSelector() {
        this.context.addNamespaces(BINDING_NS_MAP);
    }

    public MapNamespaceContext getNamespaceContext() {
        return this.context;
    }

    public void addNamespaces(Node targetNode) {
        NamedNodeMap attributes = targetNode.getAttributes();
        for (int i = 0; i < attributes.getLength(); ++i) {
            Node a = attributes.item(i);
            String prefix = a.getLocalName();
            String ns = a.getNodeValue();
            if (prefix == null || this.context.getUsedNamespaces().containsKey(prefix) || targetNode.lookupPrefix(ns) == null || "xmlns".equals(prefix)) continue;
            this.context.addNamespace(prefix, ns);
        }
    }

    public Node queryNode(Node target, String expression) {
        XPathUtils xpath = new XPathUtils((NamespaceContext)this.context);
        return (Node)xpath.getValue(expression, target, XPathConstants.NODE);
    }

    public NodeList queryNodes(Node target, String expression) {
        XPathUtils xpath = new XPathUtils((NamespaceContext)this.context);
        return (NodeList)xpath.getValue(expression, target, XPathConstants.NODESET);
    }

    static {
        BINDING_NS_MAP.put("jaxws", "https://jakarta.ee/xml/ns/jaxws");
        BINDING_NS_MAP.put("jaxb", "https://jakarta.ee/xml/ns/jaxb");
        BINDING_NS_MAP.put("wsdl", "http://schemas.xmlsoap.org/wsdl/");
        BINDING_NS_MAP.put("xsd", "http://www.w3.org/2001/XMLSchema");
    }
}

