/*
 * $Id$
 */

package org.apache.maven.settings;

/**
 * 
 *         The conditions within the build runtime environment
 * which will trigger 
 *         the automatic inclusion of the parent build profile.
 *       
 * 
 * @version $Revision$ $Date$
 */
public class Activation implements java.io.Serializable {


      //--------------------------/
     //- Class/Member Variables -/
    //--------------------------/

    /**
     * Field activeByDefault
     */
    private boolean activeByDefault = false;

    /**
     * Field jdk
     */
    private String jdk;

    /**
     * Field os
     */
    private ActivationOS os;

    /**
     * Field property
     */
    private ActivationProperty property;

    /**
     * Field file
     */
    private ActivationFile file;


      //-----------/
     //- Methods -/
    //-----------/

    /**
     * Get 
     *              Specifies that this profile will be activated
     * based on existence of a file.
     *              
     */
    public ActivationFile getFile()
    {
        return this.file;
    } //-- ActivationFile getFile() 

    /**
     * Get 
     *             Specifies that this profile will be activated
     * when a matching JDK is detected.
     *           
     */
    public String getJdk()
    {
        return this.jdk;
    } //-- String getJdk() 

    /**
     * Get 
     *             Specifies that this profile will be activated
     * when matching OS attributes are detected.
     *           
     */
    public ActivationOS getOs()
    {
        return this.os;
    } //-- ActivationOS getOs() 

    /**
     * Get 
     *             Specifies that this profile will be activated
     * when this System property is specified.
     *           
     */
    public ActivationProperty getProperty()
    {
        return this.property;
    } //-- ActivationProperty getProperty() 

    /**
     * Get Flag specifying whether this profile is active as a
     * default.
     */
    public boolean isActiveByDefault()
    {
        return this.activeByDefault;
    } //-- boolean isActiveByDefault() 

    /**
     * Set Flag specifying whether this profile is active as a
     * default.
     * 
     * @param activeByDefault
     */
    public void setActiveByDefault(boolean activeByDefault)
    {
        this.activeByDefault = activeByDefault;
    } //-- void setActiveByDefault(boolean) 

    /**
     * Set 
     *              Specifies that this profile will be activated
     * based on existence of a file.
     *              
     * 
     * @param file
     */
    public void setFile(ActivationFile file)
    {
        this.file = file;
    } //-- void setFile(ActivationFile) 

    /**
     * Set 
     *             Specifies that this profile will be activated
     * when a matching JDK is detected.
     *           
     * 
     * @param jdk
     */
    public void setJdk(String jdk)
    {
        this.jdk = jdk;
    } //-- void setJdk(String) 

    /**
     * Set 
     *             Specifies that this profile will be activated
     * when matching OS attributes are detected.
     *           
     * 
     * @param os
     */
    public void setOs(ActivationOS os)
    {
        this.os = os;
    } //-- void setOs(ActivationOS) 

    /**
     * Set 
     *             Specifies that this profile will be activated
     * when this System property is specified.
     *           
     * 
     * @param property
     */
    public void setProperty(ActivationProperty property)
    {
        this.property = property;
    } //-- void setProperty(ActivationProperty) 


    private String modelEncoding = "UTF-8";

    public void setModelEncoding( String modelEncoding )
    {
        this.modelEncoding = modelEncoding;
    }

    public String getModelEncoding()
    {
        return modelEncoding;
    }}
