/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.surefire.junitcore.pc;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.maven.surefire.junitcore.pc.InvokerStrategy;
import org.apache.maven.surefire.junitcore.pc.NonSharedThreadPoolStrategy;
import org.apache.maven.surefire.junitcore.pc.SchedulingStrategy;
import org.apache.maven.surefire.junitcore.pc.SharedThreadPoolStrategy;

public class SchedulingStrategies {
    public static SchedulingStrategy createInvokerStrategy() {
        return new InvokerStrategy();
    }

    public static SchedulingStrategy createParallelStrategy(int nThreads) {
        return new NonSharedThreadPoolStrategy(Executors.newFixedThreadPool(nThreads));
    }

    public static SchedulingStrategy createParallelStrategyUnbounded() {
        return new NonSharedThreadPoolStrategy(Executors.newCachedThreadPool());
    }

    public static SchedulingStrategy createParallelSharedStrategy(ExecutorService threadPool) {
        if (threadPool == null) {
            throw new NullPointerException("null threadPool in #createParallelSharedStrategy");
        }
        return new SharedThreadPoolStrategy(threadPool);
    }
}

