/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.IOException;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.data.DataAccess;
import org.opengis.feature.type.FeatureType;

public class ResourcePoolTest
extends GeoServerTestSupport {
    boolean cleared = false;
    boolean disposeCalled;

    public void testFeatureTypeCacheInstance() throws Exception {
        ResourcePool pool = new ResourcePool(this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureType ft1 = pool.getFeatureType(info);
        FeatureType ft2 = pool.getFeatureType(info);
        FeatureType ft3 = pool.getFeatureType(info);
        ResourcePoolTest.assertSame((Object)ft1, (Object)ft2);
        ResourcePoolTest.assertSame((Object)ft1, (Object)ft3);
    }

    public void testCacheClearing() throws IOException {
        this.cleared = false;
        ResourcePool pool = new ResourcePool(this.getCatalog()){

            public void clear(FeatureTypeInfo info) {
                ResourcePoolTest.this.cleared = true;
                super.clear(info);
            }
        };
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ResourcePoolTest.assertNotNull((Object)pool.getFeatureType(info));
        info.setTitle("changed");
        ResourcePoolTest.assertFalse((boolean)this.cleared);
        this.getCatalog().save((ResourceInfo)info);
        ResourcePoolTest.assertTrue((boolean)this.cleared);
        this.cleared = false;
        ResourcePoolTest.assertNotNull((Object)pool.getFeatureType(info));
        for (LayerInfo l : this.getCatalog().getLayers((ResourceInfo)info)) {
            this.getCatalog().remove(l);
        }
        this.getCatalog().remove((ResourceInfo)info);
        ResourcePoolTest.assertTrue((boolean)this.cleared);
    }

    public void testDispose() throws IOException {
        this.disposeCalled = false;
        Catalog catalog = this.getCatalog();
        class ResourcePool2
        extends ResourcePool {
            public ResourcePool2(Catalog catalog) {
                super(catalog);
                this.dataStoreCache = new ResourcePool.DataStoreCache(this){

                    void dispose(String name, DataAccess dataStore) {
                        ((ResourcePool2)this).ResourcePoolTest.this.disposeCalled = true;
                        super.dispose(name, dataStore);
                    }
                };
            }
        }
        ResourcePool2 pool = new ResourcePool2(catalog);
        catalog.setResourcePool((ResourcePool)pool);
        DataStoreInfo info = (DataStoreInfo)catalog.getDataStores().get(0);
        DataAccess dataStore = pool.getDataStore(info);
        ResourcePoolTest.assertNotNull((Object)dataStore);
        ResourcePoolTest.assertFalse((boolean)this.disposeCalled);
        pool.clear(info);
        ResourcePoolTest.assertTrue((boolean)this.disposeCalled);
        dataStore = pool.getDataStore(info);
        ResourcePoolTest.assertNotNull((Object)dataStore);
        this.disposeCalled = false;
        pool.dispose();
        ResourcePoolTest.assertTrue((boolean)this.disposeCalled);
    }
}

