/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.test;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.geom.AffineTransform;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.data.CatalogWriter;
import org.geoserver.data.test.TestData;
import org.geoserver.data.util.CoverageStoreUtils;
import org.geoserver.data.util.CoverageUtils;
import org.geoserver.data.util.IOUtils;
import org.geotools.coverage.Category;
import org.geotools.coverage.GridSampleDimension;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridGeometry2D;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.data.property.PropertyDataStoreFactory;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.cs.CoordinateSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockData
implements TestData {
    public static final String KEY_SRS_HANDLINGS = "srsHandling";
    public static final String KEY_ALIAS = "alias";
    public static final String KEY_STYLE = "style";
    public static final String KEY_SRS_NUMBER = "srs";
    public static final String KEY_LL_ENVELOPE = "ll_envelope";
    public static final String KEY_NATIVE_ENVELOPE = "native_envelope";
    static final Envelope DEFAULT_ENVELOPE = new Envelope(-180.0, 180.0, -90.0, 90.0);
    public static String CITE_PREFIX = "cite";
    public static String CITE_URI = "http://www.opengis.net/cite";
    public static QName BASIC_POLYGONS = new QName(CITE_URI, "BasicPolygons", CITE_PREFIX);
    public static QName BRIDGES = new QName(CITE_URI, "Bridges", CITE_PREFIX);
    public static QName BUILDINGS = new QName(CITE_URI, "Buildings", CITE_PREFIX);
    public static QName DIVIDED_ROUTES = new QName(CITE_URI, "DividedRoutes", CITE_PREFIX);
    public static QName FORESTS = new QName(CITE_URI, "Forests", CITE_PREFIX);
    public static QName LAKES = new QName(CITE_URI, "Lakes", CITE_PREFIX);
    public static QName MAP_NEATLINE = new QName(CITE_URI, "MapNeatline", CITE_PREFIX);
    public static QName NAMED_PLACES = new QName(CITE_URI, "NamedPlaces", CITE_PREFIX);
    public static QName PONDS = new QName(CITE_URI, "Ponds", CITE_PREFIX);
    public static QName ROAD_SEGMENTS = new QName(CITE_URI, "RoadSegments", CITE_PREFIX);
    public static QName STREAMS = new QName(CITE_URI, "Streams", CITE_PREFIX);
    public static String CDF_PREFIX = "cdf";
    public static String CDF_URI = "http://www.opengis.net/cite/data";
    public static QName DELETES = new QName(CDF_URI, "Deletes", CDF_PREFIX);
    public static QName FIFTEEN = new QName(CDF_URI, "Fifteen", CDF_PREFIX);
    public static QName INSERTS = new QName(CDF_URI, "Inserts", CDF_PREFIX);
    public static QName LOCKS = new QName(CDF_URI, "Locks", CDF_PREFIX);
    public static QName NULLS = new QName(CDF_URI, "Nulls", CDF_PREFIX);
    public static QName OTHER = new QName(CDF_URI, "Other", CDF_PREFIX);
    public static QName SEVEN = new QName(CDF_URI, "Seven", CDF_PREFIX);
    public static QName UPDATES = new QName(CDF_URI, "Updates", CDF_PREFIX);
    public static String CGF_PREFIX = "cgf";
    public static String CGF_URI = "http://www.opengis.net/cite/geometry";
    public static QName LINES = new QName(CGF_URI, "Lines", CGF_PREFIX);
    public static QName MLINES = new QName(CGF_URI, "MLines", CGF_PREFIX);
    public static QName MPOINTS = new QName(CGF_URI, "MPoints", CGF_PREFIX);
    public static QName MPOLYGONS = new QName(CGF_URI, "MPolygons", CGF_PREFIX);
    public static QName POINTS = new QName(CGF_URI, "Points", CGF_PREFIX);
    public static QName POLYGONS = new QName(CGF_URI, "Polygons", CGF_PREFIX);
    public static String SF_PREFIX = "sf";
    public static String SF_URI = "http://cite.opengeospatial.org/gmlsf";
    public static QName PRIMITIVEGEOFEATURE = new QName(SF_URI, "PrimitiveGeoFeature", SF_PREFIX);
    public static QName AGGREGATEGEOFEATURE = new QName(SF_URI, "AggregateGeoFeature", SF_PREFIX);
    public static QName GENERICENTITY = new QName(SF_URI, "GenericEntity", SF_PREFIX);
    public static String WCS_PREFIX = "wcs";
    public static String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    public static QName TASMANIA_DEM = new QName(WCS_URI, "DEM", WCS_PREFIX);
    public static QName TASMANIA_BM = new QName(WCS_URI, "BlueMarble", WCS_PREFIX);
    public static QName ROTATED_CAD = new QName(WCS_URI, "RotatedCad", WCS_PREFIX);
    public static QName WORLD = new QName(WCS_URI, "World", WCS_PREFIX);
    public static String TIFF = "tiff";
    public static String DEFAULT_PREFIX = "gs";
    public static String DEFAULT_URI = "http://geoserver.org";
    public static QName GEOMETRYLESS = new QName(CITE_URI, "Geometryless", CITE_PREFIX);
    public static QName[] TYPENAMES = new QName[]{BASIC_POLYGONS, BRIDGES, BUILDINGS, DIVIDED_ROUTES, FORESTS, LAKES, MAP_NEATLINE, NAMED_PLACES, PONDS, ROAD_SEGMENTS, STREAMS, DELETES, FIFTEEN, INSERTS, LOCKS, NULLS, OTHER, SEVEN, UPDATES, LINES, MLINES, MPOINTS, MPOLYGONS, POINTS, POLYGONS, PRIMITIVEGEOFEATURE, AGGREGATEGEOFEATURE, GENERICENTITY, GEOMETRYLESS};
    public static QName[] WMS_TYPENAMES = new QName[]{BASIC_POLYGONS, BRIDGES, BUILDINGS, DIVIDED_ROUTES, FORESTS, LAKES, MAP_NEATLINE, NAMED_PLACES, PONDS, ROAD_SEGMENTS, STREAMS};
    public static QName[] WFS10_TYPENAMES = new QName[]{DELETES, FIFTEEN, INSERTS, LOCKS, NULLS, OTHER, SEVEN, UPDATES, LINES, MLINES, MPOINTS, MPOLYGONS, POINTS, POLYGONS};
    public static QName[] WFS11_TYPENAMES = new QName[]{PRIMITIVEGEOFEATURE, AGGREGATEGEOFEATURE, GENERICENTITY};
    public static HashMap<QName, Integer> SRS = new HashMap();
    File data;
    File featureTypes;
    File coverages;
    File styles;
    File plugIns;
    File validation;
    File templates;
    HashMap dataStores = new HashMap();
    Set disabledDataStores = new HashSet();
    private HashMap dataStoreNamepaces = new HashMap();
    private HashMap namespaces = new HashMap();
    private HashMap layerStyles = new HashMap();
    private HashMap coverageStores = new HashMap();
    Set disabledCoverageStores = new HashSet();
    private HashMap coverageStoresNamespaces = new HashMap();

    static {
        int i = 0;
        while (i < WFS10_TYPENAMES.length) {
            SRS.put(WFS10_TYPENAMES[i], 32615);
            ++i;
        }
        i = 0;
        while (i < WFS11_TYPENAMES.length) {
            SRS.put(WFS11_TYPENAMES[i], 4326);
            ++i;
        }
    }

    public MockData() throws IOException {
        this.data = IOUtils.createRandomDirectory((String)"./target", (String)"mock", (String)"data");
        this.data.delete();
        this.data.mkdir();
        this.featureTypes = new File(this.data, "featureTypes");
        this.featureTypes.mkdir();
        this.coverages = new File(this.data, "coverages");
        this.coverages.mkdir();
        this.styles = new File(this.data, "styles");
        this.styles.mkdir();
        IOUtils.copy((InputStream)MockData.class.getResourceAsStream("Default.sld"), (File)new File(this.styles, "Default.sld"));
        this.plugIns = new File(this.data, "plugIns");
        this.plugIns.mkdir();
        this.validation = new File(this.data, "validation");
        this.validation.mkdir();
        this.templates = new File(this.data, "templates");
        this.templates.mkdir();
        this.namespaces.put(DEFAULT_PREFIX, DEFAULT_URI);
        this.namespaces.put("", DEFAULT_URI);
        this.layerStyles.put("Default", "Default.sld");
    }

    @Override
    public void setUp() throws IOException {
        this.setUpCatalog();
        this.copyTo(MockData.class.getResourceAsStream("services.xml"), "services.xml");
    }

    @Override
    public boolean isTestDataAvailable() {
        return true;
    }

    @Override
    public File getDataDirectoryRoot() {
        return this.data;
    }

    public File getFeatureTypesDirectory() {
        return this.featureTypes;
    }

    public File getCoveragesDirectory() {
        return this.coverages;
    }

    public void copyTo(InputStream input, String location) throws IOException {
        IOUtils.copy((InputStream)input, (File)new File(this.getDataDirectoryRoot(), location));
    }

    public void copyToFeatureTypeDirectory(InputStream input, QName featureTypeName, String location) throws IOException {
        this.copyTo(input, "featureTypes" + File.separator + featureTypeName.getPrefix() + "_" + featureTypeName.getLocalPart() + File.separator + location);
    }

    public void addWellKnownTypes(QName[] names) throws IOException {
        int i = 0;
        while (i < names.length) {
            QName name = names[i];
            this.addWellKnownType(name, null);
            ++i;
        }
    }

    public void addWellKnownType(QName name, Map extraProperties) throws IOException {
        URL properties = MockData.class.getResource(String.valueOf(name.getLocalPart()) + ".properties");
        URL style = MockData.class.getResource(String.valueOf(name.getLocalPart()) + ".sld");
        String styleName = null;
        if (style != null) {
            styleName = name.getLocalPart();
            this.addStyle(styleName, style);
        }
        if (extraProperties == null) {
            this.addPropertiesType(name, properties, Collections.singletonMap(KEY_STYLE, styleName));
        } else {
            HashMap<String, String> props = new HashMap<String, String>(extraProperties);
            props.put(KEY_STYLE, styleName);
            this.addPropertiesType(name, properties, props);
        }
    }

    public void addWellKnownCoverageTypes() throws Exception {
        URL style = MockData.class.getResource("raster.sld");
        String styleName = "raster";
        this.addStyle(styleName, style);
        this.addCoverage(TASMANIA_DEM, TestData.class.getResource("tazdem.tiff"), TIFF, styleName);
        this.addCoverage(TASMANIA_BM, TestData.class.getResource("tazbm.tiff"), TIFF, styleName);
        this.addCoverage(ROTATED_CAD, TestData.class.getResource("rotated.tiff"), TIFF, styleName);
        this.addCoverage(WORLD, TestData.class.getResource("world.tiff"), TIFF, styleName);
    }

    public void addStyle(String styleId, URL style) throws IOException {
        this.layerStyles.put(styleId, String.valueOf(styleId) + ".sld");
        InputStream styleContents = style.openStream();
        File to = new File(this.styles, String.valueOf(styleId) + ".sld");
        IOUtils.copy((InputStream)styleContents, (File)to);
    }

    public void addPropertiesType(QName name, URL properties, Map extraParams) throws IOException {
        File directory;
        if (extraParams == null) {
            extraParams = Collections.EMPTY_MAP;
        }
        if (!(directory = new File(this.data, name.getPrefix())).exists()) {
            directory.mkdir();
        }
        File f = new File(directory, String.valueOf(name.getLocalPart()) + ".properties");
        InputStream propertiesContents = properties == null ? new ByteArrayInputStream("-=".getBytes()) : properties.openStream();
        IOUtils.copy((InputStream)propertiesContents, (File)f);
        this.info(name, extraParams);
        this.namespaces.put(name.getPrefix(), name.getNamespaceURI());
        this.dataStoreNamepaces.put(name.getPrefix(), name.getPrefix());
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(PropertyDataStoreFactory.DIRECTORY.key, directory);
        params.put(PropertyDataStoreFactory.NAMESPACE.key, name.getNamespaceURI());
        this.dataStores.put(name.getPrefix(), params);
    }

    public void addCoverage(QName name, URL coverage, String extension, String styleName) throws Exception {
        File directory = new File(this.data, name.getPrefix());
        if (!directory.exists()) {
            directory.mkdir();
        }
        File f = new File(directory, String.valueOf(name.getLocalPart()) + "." + extension);
        IOUtils.copy((InputStream)coverage.openStream(), (File)f);
        this.coverageInfo(name, f, styleName);
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)f);
        this.namespaces.put(name.getPrefix(), name.getNamespaceURI());
        this.coverageStoresNamespaces.put(name.getLocalPart(), name.getPrefix());
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("coverageType", format.getName());
        params.put("coverageUrl", "file:" + name.getPrefix() + "/" + name.getLocalPart() + "." + extension);
        this.coverageStores.put(name.getLocalPart(), params);
    }

    public void disableDataStore(String datastoreId) {
        this.disabledDataStores.add(datastoreId);
    }

    public void disableCoverageStore(String datastoreId) {
        this.disabledCoverageStores.add(datastoreId);
    }

    protected void setUpCatalog() throws IOException {
        CatalogWriter writer = new CatalogWriter();
        writer.dataStores((Map)this.dataStores, (Map)this.dataStoreNamepaces, this.disabledDataStores);
        writer.coverageStores(this.coverageStores, this.coverageStoresNamespaces, this.disabledCoverageStores);
        writer.namespaces((Map)this.namespaces);
        writer.styles((Map)this.layerStyles);
        writer.write(new File(this.data, "catalog.xml"));
    }

    void properties(QName name) throws IOException {
        InputStream from = MockData.class.getResourceAsStream(String.valueOf(name.getLocalPart()) + ".properties");
        File directory = new File(this.data, name.getPrefix());
        directory.mkdir();
        File to = new File(directory, String.valueOf(name.getLocalPart()) + ".properties");
        IOUtils.copy((InputStream)from, (File)to);
    }

    void info(QName name, Map<String, Object> extraParams) throws IOException {
        String style;
        String type = name.getLocalPart();
        String prefix = name.getPrefix();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(KEY_STYLE, "Default");
        params.put(KEY_ALIAS, null);
        Integer srs = SRS.get(name);
        if (srs == null) {
            srs = 4326;
        }
        params.put(KEY_SRS_NUMBER, srs);
        params.putAll(extraParams);
        File featureTypeDir = new File(this.featureTypes, String.valueOf(prefix) + "_" + type);
        featureTypeDir.mkdir();
        File info = new File(featureTypeDir, "info.xml");
        info.delete();
        info.createNewFile();
        FileWriter writer = new FileWriter(info);
        writer.write("<featureType datastore=\"" + prefix + "\">");
        writer.write("<name>" + type + "</name>");
        if (params.get(KEY_ALIAS) != null) {
            writer.write("<alias>" + params.get(KEY_ALIAS) + "</alias>");
        }
        writer.write("<SRS>" + params.get(KEY_SRS_NUMBER) + "</SRS>");
        int srsHandling = 2;
        Object handling = params.get(KEY_SRS_HANDLINGS);
        if (handling != null) {
            if (handling instanceof ProjectionPolicy) {
                srsHandling = ((ProjectionPolicy)params.get(KEY_SRS_HANDLINGS)).getCode();
            } else if (handling instanceof Number) {
                srsHandling = ((Number)params.get(KEY_SRS_HANDLINGS)).intValue();
            }
        }
        writer.write("<SRSHandling>" + srsHandling + "</SRSHandling>");
        writer.write("<title>" + type + "</title>");
        writer.write("<abstract>abstract about " + type + "</abstract>");
        writer.write("<numDecimals value=\"8\"/>");
        writer.write("<keywords>" + type + "</keywords>");
        Envelope llEnvelope = (Envelope)params.get(KEY_LL_ENVELOPE);
        if (llEnvelope == null) {
            llEnvelope = DEFAULT_ENVELOPE;
        }
        writer.write("<latLonBoundingBox dynamic=\"false\" minx=\"" + llEnvelope.getMinX() + "\" miny=\"" + llEnvelope.getMinY() + "\" maxx=\"" + llEnvelope.getMaxX() + "\" maxy=\"" + llEnvelope.getMaxY() + "\"/>");
        Envelope nativeEnvelope = (Envelope)params.get(KEY_NATIVE_ENVELOPE);
        if (nativeEnvelope != null) {
            writer.write("<nativeBBox dynamic=\"false\" minx=\"" + nativeEnvelope.getMinX() + "\" miny=\"" + nativeEnvelope.getMinY() + "\" maxx=\"" + nativeEnvelope.getMaxX() + "\" maxy=\"" + nativeEnvelope.getMaxY() + "\"/>");
        }
        if ((style = (String)params.get(KEY_STYLE)) == null) {
            style = "Default";
        }
        writer.write("<styles default=\"" + style + "\"/>");
        writer.write("</featureType>");
        writer.flush();
        writer.close();
    }

    void coverageInfo(QName name, File coverageFile, String styleName) throws Exception {
        String coverage = name.getLocalPart();
        File coverageDir = new File(this.coverages, coverage);
        coverageDir.mkdir();
        File info = new File(coverageDir, "info.xml");
        info.createNewFile();
        AbstractGridFormat format = GridFormatFinder.findFormat((Object)coverageFile);
        AbstractGridCoverage2DReader reader = format.getReader((Object)coverageFile);
        FileWriter writer = new FileWriter(info);
        writer.write("<coverage format=\"" + coverage + "\">\n");
        writer.write("<name>" + coverage + "</name>\n");
        writer.write("<label>" + coverage + "</label>\n");
        writer.write("<description>" + coverage + " description</description>\n");
        writer.write("<metadataLink about = \"http://www.remotesensing.org:16080/websites/geotiff/geotiff.html\" metadataType = \"other\" />");
        writer.write("<keywords>WCS," + coverage + " </keywords>\n");
        if (styleName == null) {
            styleName = "raster";
        }
        writer.write("<styles default=\"" + styleName + "\"/>\n");
        CoordinateReferenceSystem crs = reader.getCrs();
        GeneralEnvelope envelope = reader.getOriginalEnvelope();
        GeneralEnvelope wgs84envelope = CoverageStoreUtils.getWGS84LonLatEnvelope((GeneralEnvelope)envelope);
        String nativeCrsName = CRS.lookupIdentifier((IdentifiedObject)crs, (boolean)false);
        writer.write("<envelope crs=\"" + crs.toString().replaceAll("\"", "'") + "\" srsName=\"" + nativeCrsName + "\">\n");
        writer.write("<pos>" + wgs84envelope.getMinimum(0) + " " + wgs84envelope.getMinimum(1) + "</pos>\n");
        writer.write("<pos>" + wgs84envelope.getMaximum(0) + " " + wgs84envelope.getMaximum(1) + "</pos>\n");
        writer.write("</envelope>\n");
        ParameterValueGroup readParams = reader.getFormat().getReadParameters();
        Map parameters = CoverageUtils.getParametersKVP((ParameterValueGroup)readParams);
        double[] minCP = envelope.getLowerCorner().getCoordinates();
        double[] maxCP = new double[]{minCP[0] + envelope.getLength(0) / 20.0, minCP[1] + envelope.getLength(1) / 20.0};
        GeneralEnvelope subEnvelope = new GeneralEnvelope(minCP, maxCP);
        subEnvelope.setCoordinateReferenceSystem(reader.getCrs());
        parameters.put(AbstractGridFormat.READ_GRIDGEOMETRY2D.getName().toString(), new GridGeometry2D(reader.getOriginalGridRange(), (org.opengis.geometry.Envelope)subEnvelope));
        GridCoverage2D gc = reader.read(CoverageUtils.getParameters((ParameterValueGroup)readParams, (Map)parameters, (boolean)true));
        GridGeometry2D geometry = gc.getGridGeometry();
        int dimensions = geometry.getGridRange().getDimension();
        String lower = "";
        String upper = "";
        int i = 0;
        while (i < dimensions) {
            lower = String.valueOf(lower) + geometry.getGridRange().getLow(i) + " ";
            upper = String.valueOf(upper) + geometry.getGridRange().getHigh(i) + " ";
            ++i;
        }
        writer.write("<grid dimension = \"" + dimensions + "\">\n");
        writer.write("<low>" + lower + "</low>\n");
        writer.write("<high>" + upper + "</high>\n");
        CoordinateSystem cs = crs.getCoordinateSystem();
        int i2 = 0;
        while (i2 < cs.getDimension()) {
            writer.write("<axisName>" + cs.getAxis(i2).getName().getCode() + "</axisName>\n");
            ++i2;
        }
        if (geometry.getGridToCRS() instanceof AffineTransform) {
            AffineTransform aTX = (AffineTransform)geometry.getGridToCRS();
            writer.write("<geoTransform>");
            writer.write("<scaleX>" + aTX.getScaleX() + "</scaleX>\n");
            writer.write("<scaleY>" + aTX.getScaleY() + "</scaleY>\n");
            writer.write("<shearX>" + aTX.getShearX() + "</shearX>\n");
            writer.write("<shearY>" + aTX.getShearY() + "</shearY>\n");
            writer.write("<translateX>" + aTX.getTranslateX() + "</translateX>\n");
            writer.write("<translateY>" + aTX.getTranslateY() + "</translateY>\n");
            writer.write("</geoTransform>\n");
        }
        writer.write("</grid>\n");
        GridSampleDimension[] sd = gc.getSampleDimensions();
        int i3 = 0;
        while (i3 < sd.length) {
            writer.write("<CoverageDimension>\n");
            writer.write("<name>" + sd[i3].getDescription().toString() + "</name>\n");
            writer.write("<interval>\n");
            writer.write("<min>" + sd[i3].getMinimumValue() + "</min>\n");
            writer.write("<max>" + sd[i3].getMaximumValue() + "</max>\n");
            writer.write("</interval>\n");
            List categories = sd[i3].getCategories();
            if (categories != null && categories.size() >= 1) {
                writer.write("<nullValues>\n");
                for (Category cat : sd[i3].getCategories()) {
                    if (cat == null || !cat.getName().toString().equalsIgnoreCase("no data")) continue;
                    double min = cat.getRange().getMinimum();
                    double max = cat.getRange().getMaximum();
                    writer.write("<value>" + min + "</value>\n");
                    if (min == max) continue;
                    writer.write("<value>" + max + "</value>\n");
                }
                writer.write("</nullValues>\n");
            } else {
                writer.write("<nullValues/>\n");
            }
            writer.write("</CoverageDimension>\n");
            ++i3;
        }
        writer.write("<supportedCRSs>\n");
        writer.write("<requestCRSs>" + nativeCrsName + "</requestCRSs>\n");
        writer.write("<responseCRSs>" + nativeCrsName + "</responseCRSs>\n");
        writer.write("</supportedCRSs>\n");
        writer.write("<supportedFormats nativeFormat = \"" + format.getName() + "\">\n");
        writer.write("<formats>ARCGRID,ARCGRID-GZIP,GEOTIFF,PNG,GIF,TIFF</formats>\n");
        writer.write("</supportedFormats>\n");
        writer.write("<supportedInterpolations default = \"nearest neighbor\">\n");
        writer.write("<interpolationMethods>nearest neighbor</interpolationMethods>\n");
        writer.write("</supportedInterpolations>\n");
        writer.write("</coverage>\n");
        writer.flush();
        writer.close();
    }

    @Override
    public void tearDown() throws IOException {
        IOUtils.delete((File)this.data);
        this.styles = null;
        this.featureTypes = null;
        this.data = null;
    }
}

