/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.io.WKTReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import junit.framework.TestCase;
import org.easymock.EasyMock;
import org.geoserver.data.test.MockData;
import org.geoserver.data.util.IOUtils;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLockFactory;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.geotools.data.Transaction;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.filter.identity.FeatureIdImpl;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;
import org.opengis.filter.identity.FeatureId;

public class FullyRetypingDataStoreTest
extends TestCase {
    SimpleFeatureType primitive;
    static final String RENAMED = "primitive";
    RetypingDataStore rts;
    private File data;
    private Id fidFilter;
    private String fid;

    protected void setUp() throws Exception {
        this.data = File.createTempFile("retype", "data", new File("./target"));
        this.data.delete();
        this.data.mkdir();
        String fileName = String.valueOf(MockData.PRIMITIVEGEOFEATURE.getLocalPart()) + ".properties";
        URL properties = MockData.class.getResource(fileName);
        IOUtils.copy((InputStream)properties.openStream(), (File)new File(this.data, fileName));
        SimpleFeatureTypeBuilder ftb = new SimpleFeatureTypeBuilder();
        ftb.add("description", String.class);
        ftb.add("pointProperty", MultiPoint.class);
        ftb.add("intProperty", Long.class);
        ftb.add("dateTimeProperty", Date.class);
        ftb.add("newProperty", String.class);
        ftb.setName(RENAMED);
        this.primitive = ftb.buildFeatureType();
        PropertyDataStore pds = new PropertyDataStore(this.data);
        this.rts = new RetypingDataStore((DataStore)pds){

            protected SimpleFeatureType transformFeatureType(SimpleFeatureType original) throws IOException {
                if (original.getTypeName().equals(MockData.PRIMITIVEGEOFEATURE.getLocalPart())) {
                    return FullyRetypingDataStoreTest.this.primitive;
                }
                return super.transformFeatureType(original);
            }

            protected String transformFeatureTypeName(String originalName) {
                if (originalName.equals(MockData.PRIMITIVEGEOFEATURE.getLocalPart())) {
                    return FullyRetypingDataStoreTest.this.primitive.getTypeName();
                }
                return super.transformFeatureTypeName(originalName);
            }
        };
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        this.fid = "primitive.f001";
        this.fidFilter = ff.id(Collections.singleton(ff.featureId(this.fid)));
    }

    protected void tearDown() throws Exception {
        IOUtils.delete((File)this.data);
    }

    public void testLookupFeatureType() throws Exception {
        try {
            this.rts.getSchema(MockData.GENERICENTITY.getLocalPart());
            FullyRetypingDataStoreTest.fail((String)"The original type name should not be visible");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        SimpleFeatureType schema = this.rts.getSchema(RENAMED);
        FullyRetypingDataStoreTest.assertNotNull((Object)schema);
        FullyRetypingDataStoreTest.assertEquals((Object)this.primitive, (Object)schema);
    }

    public void testGetFeaturesFeatureSource() throws Exception {
        FeatureSource fs = this.rts.getFeatureSource(RENAMED);
        FullyRetypingDataStoreTest.assertEquals((Object)this.primitive, (Object)fs.getSchema());
        FeatureCollection fc = fs.getFeatures();
        FullyRetypingDataStoreTest.assertEquals((Object)this.primitive, (Object)fc.getSchema());
        FullyRetypingDataStoreTest.assertTrue((fc.size() > 0 ? 1 : 0) != 0);
        FeatureIterator it = fc.features();
        SimpleFeature sf = (SimpleFeature)it.next();
        it.close();
        FullyRetypingDataStoreTest.assertEquals((Object)this.primitive, (Object)sf.getFeatureType());
        FullyRetypingDataStoreTest.assertTrue((String)("Feature id has not been renamed, it's still " + sf.getID()), (boolean)sf.getID().startsWith(RENAMED));
        FullyRetypingDataStoreTest.assertEquals((Object)"description-f001", (Object)sf.getAttribute("description"));
        FullyRetypingDataStoreTest.assertTrue((boolean)new WKTReader().read("MULTIPOINT(39.73245 2.00342)").equalsExact((Geometry)sf.getAttribute("pointProperty")));
        FullyRetypingDataStoreTest.assertEquals((Object)new Long(155L), (Object)sf.getAttribute("intProperty"));
        FullyRetypingDataStoreTest.assertNull((Object)sf.getAttribute("newProperty"));
    }

    public void testGetFeaturesReader() throws Exception {
        FeatureReader fr = this.rts.getFeatureReader((Query)new DefaultQuery(RENAMED), Transaction.AUTO_COMMIT);
        SimpleFeature sf = (SimpleFeature)fr.next();
        fr.close();
        FullyRetypingDataStoreTest.assertEquals((Object)this.primitive, (Object)sf.getFeatureType());
        FullyRetypingDataStoreTest.assertTrue((String)("Feature id has not been renamed, it's still " + sf.getID()), (boolean)sf.getID().startsWith(RENAMED));
    }

    public void testFeautureSourceFidFilter() throws Exception {
        FeatureSource fs = this.rts.getFeatureSource(RENAMED);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String fid = "primitive.f001";
        Id fidFilter = ff.id(Collections.singleton(ff.featureId("primitive.f001")));
        FeatureCollection fc = fs.getFeatures((Query)new DefaultQuery(RENAMED, (Filter)fidFilter));
        FullyRetypingDataStoreTest.assertEquals((String)RENAMED, (String)((SimpleFeatureType)fc.getSchema()).getName().getLocalPart());
        FullyRetypingDataStoreTest.assertEquals((int)1, (int)fc.size());
        FeatureIterator it = fc.features();
        FullyRetypingDataStoreTest.assertTrue((boolean)it.hasNext());
        SimpleFeature sf = (SimpleFeature)it.next();
        FullyRetypingDataStoreTest.assertFalse((boolean)it.hasNext());
        it.close();
        FullyRetypingDataStoreTest.assertEquals((String)"primitive.f001", (String)sf.getID());
    }

    public void testFeatureReaderFidFilter() throws Exception {
        FeatureReader fr = this.rts.getFeatureReader((Query)new DefaultQuery(RENAMED, (Filter)this.fidFilter), Transaction.AUTO_COMMIT);
        FullyRetypingDataStoreTest.assertEquals((Object)this.primitive, (Object)fr.getFeatureType());
        FullyRetypingDataStoreTest.assertTrue((boolean)fr.hasNext());
        SimpleFeature sf = (SimpleFeature)fr.next();
        FullyRetypingDataStoreTest.assertFalse((boolean)fr.hasNext());
        fr.close();
        FullyRetypingDataStoreTest.assertEquals((String)this.fid, (String)sf.getID());
    }

    public void testDelete() throws Exception {
        DefaultQuery queryAll = new DefaultQuery(RENAMED);
        FeatureStore store = (FeatureStore)this.rts.getFeatureSource(RENAMED);
        int count = store.getCount((Query)queryAll);
        store.removeFeatures((Filter)this.fidFilter);
        FullyRetypingDataStoreTest.assertEquals((int)(count - 1), (int)store.getCount((Query)queryAll));
    }

    public void testModify() throws Exception {
        DefaultQuery queryAll = new DefaultQuery(RENAMED);
        FeatureStore store = (FeatureStore)this.rts.getFeatureSource(RENAMED);
        SimpleFeature original = (SimpleFeature)store.getFeatures((Filter)this.fidFilter).features().next();
        String newDescription = String.valueOf((String)original.getAttribute("description")) + " xxx";
        store.modifyFeatures(original.getFeatureType().getDescriptor("description"), (Object)newDescription, (Filter)this.fidFilter);
        SimpleFeature modified = (SimpleFeature)store.getFeatures((Filter)this.fidFilter).features().next();
        FullyRetypingDataStoreTest.assertEquals((Object)newDescription, (Object)modified.getAttribute("description"));
        MultiPoint mpo = (MultiPoint)original.getAttribute("pointProperty");
        MultiPoint mpm = mpo.getFactory().createMultiPoint(new Coordinate[]{new Coordinate(10.0, 12.0)});
        store.modifyFeatures(original.getFeatureType().getDescriptor("pointProperty"), (Object)mpm, (Filter)this.fidFilter);
        modified = (SimpleFeature)store.getFeatures((Filter)this.fidFilter).features().next();
        FullyRetypingDataStoreTest.assertTrue((boolean)mpm.equalsExact((Geometry)modified.getAttribute("pointProperty")));
    }

    public void testAppend() throws Exception {
        SimpleFeatureType type = DataUtilities.createType((String)"trees", (String)"the_geom:Point,FID:String,NAME:String");
        FeatureStore fs = (FeatureStore)EasyMock.createMock(FeatureStore.class);
        EasyMock.expect((Object)fs.addFeatures((FeatureCollection)EasyMock.isA(FeatureCollection.class))).andReturn(Collections.singletonList(new FeatureIdImpl("trees.105")));
        EasyMock.replay((Object[])new Object[]{fs});
        DataStore ds = (DataStore)EasyMock.createMock(DataStore.class);
        EasyMock.expect((Object)ds.getTypeNames()).andReturn((Object)new String[]{"trees"}).anyTimes();
        EasyMock.expect((Object)ds.getSchema("trees")).andReturn((Object)type).anyTimes();
        EasyMock.expect((Object)ds.getFeatureSource("trees")).andReturn((Object)fs);
        EasyMock.replay((Object[])new Object[]{ds});
        RetypingDataStore rts = new RetypingDataStore(ds){

            protected String transformFeatureTypeName(String originalName) {
                return "oaks";
            }
        };
        SimpleFeatureBuilder sfb = new SimpleFeatureBuilder(type);
        WKTReader reader = new WKTReader();
        sfb.set("the_geom", (Object)reader.read("POINT (0.002 0.0008)"));
        sfb.set("FID", (Object)"023");
        sfb.set("NAME", (Object)"Old oak");
        SimpleFeature feature = sfb.buildFeature(null);
        FeatureCollection fc = DataUtilities.collection((SimpleFeature)feature);
        FeatureStore store = (FeatureStore)rts.getFeatureSource("oaks");
        List ids = store.addFeatures(fc);
        FullyRetypingDataStoreTest.assertEquals((int)1, (int)ids.size());
        String id = ((FeatureId)ids.iterator().next()).getID();
        FullyRetypingDataStoreTest.assertTrue((String)("Id does not start with oaks it's " + id), (boolean)id.startsWith("oaks"));
    }

    public void testLockUnlockFilter() throws Exception {
        FeatureLocking fl = (FeatureLocking)this.rts.getFeatureSource(RENAMED);
        FeatureLock lock = FeatureLockFactory.generate((long)600000L);
        DefaultTransaction t = new DefaultTransaction();
        t.addAuthorization(lock.getAuthorization());
        fl.setTransaction((Transaction)t);
        fl.setFeatureLock(lock);
        FeatureLocking fl2 = (FeatureLocking)this.rts.getFeatureSource(RENAMED);
        fl.setFeatureLock(lock);
        fl2.setTransaction((Transaction)new DefaultTransaction());
        FullyRetypingDataStoreTest.assertEquals((int)1, (int)fl.lockFeatures((Filter)this.fidFilter));
        FullyRetypingDataStoreTest.assertEquals((int)0, (int)fl2.lockFeatures((Filter)this.fidFilter));
        fl.unLockFeatures((Filter)this.fidFilter);
        FullyRetypingDataStoreTest.assertEquals((int)1, (int)fl2.lockFeatures((Filter)this.fidFilter));
    }

    public void testLockUnlockQuery() throws Exception {
        FeatureLocking fl = (FeatureLocking)this.rts.getFeatureSource(RENAMED);
        FeatureLock lock = FeatureLockFactory.generate((long)600000L);
        DefaultTransaction t = new DefaultTransaction();
        t.addAuthorization(lock.getAuthorization());
        fl.setTransaction((Transaction)t);
        fl.setFeatureLock(lock);
        FeatureLocking fl2 = (FeatureLocking)this.rts.getFeatureSource(RENAMED);
        fl.setFeatureLock(lock);
        fl2.setTransaction((Transaction)new DefaultTransaction());
        DefaultQuery q = new DefaultQuery(RENAMED, (Filter)this.fidFilter);
        FullyRetypingDataStoreTest.assertEquals((int)1, (int)fl.lockFeatures((Query)q));
        FullyRetypingDataStoreTest.assertEquals((int)0, (int)fl2.lockFeatures((Query)q));
        fl.unLockFeatures((Query)q);
        FullyRetypingDataStoreTest.assertEquals((int)1, (int)fl2.lockFeatures((Query)q));
    }
}

