/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.io.File;
import java.io.IOException;
import java.util.List;
import java.util.Properties;
import junit.framework.TestCase;
import org.acegisecurity.GrantedAuthority;
import org.acegisecurity.GrantedAuthorityImpl;
import org.acegisecurity.userdetails.User;
import org.acegisecurity.userdetails.UserDetails;
import org.acegisecurity.userdetails.UsernameNotFoundException;
import org.geoserver.security.GeoserverUserDao;
import org.geoserver.security.PropertyFileWatcher;
import org.springframework.dao.DataAccessResourceFailureException;

public class GeoServerUserDaoTest
extends TestCase {
    Properties props;
    TestableUserDao dao;

    protected void setUp() throws Exception {
        this.props = new Properties();
        this.props.put("admin", "gs,ROLE_ADMINISTRATOR");
        this.props.put("wfs", "webFeatureService,ROLE_WFS_READ,ROLE_WFS_WRITE");
        this.props.put("disabledUser", "nah,ROLE_TEST,disabled");
        this.dao = new TestableUserDao(this.props);
    }

    public void testGetUsers() throws Exception {
        List users = this.dao.getUsers();
        GeoServerUserDaoTest.assertEquals((int)3, (int)users.size());
    }

    public void testLoadUser() throws Exception {
        UserDetails admin = this.dao.loadUserByUsername("admin");
        GeoServerUserDaoTest.assertEquals((String)"admin", (String)admin.getUsername());
        GeoServerUserDaoTest.assertEquals((String)"gs", (String)admin.getPassword());
        GeoServerUserDaoTest.assertEquals((int)1, (int)admin.getAuthorities().length);
        GeoServerUserDaoTest.assertEquals((String)"ROLE_ADMINISTRATOR", (String)admin.getAuthorities()[0].getAuthority());
    }

    public void testMissingUser() throws Exception {
        try {
            this.dao.loadUserByUsername("notThere");
            GeoServerUserDaoTest.fail((String)"This user should not be there");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testSetUser() throws Exception {
        this.dao.setUser(new User("wfs", "pwd", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_WFS_ALL"), new GrantedAuthorityImpl("ROLE_WMS_ALL")}));
        UserDetails user = this.dao.loadUserByUsername("wfs");
        GeoServerUserDaoTest.assertEquals((String)"wfs", (String)user.getUsername());
        GeoServerUserDaoTest.assertEquals((String)"pwd", (String)user.getPassword());
        GeoServerUserDaoTest.assertEquals((int)2, (int)user.getAuthorities().length);
        GeoServerUserDaoTest.assertEquals((String)"ROLE_WFS_ALL", (String)user.getAuthorities()[0].getAuthority());
        GeoServerUserDaoTest.assertEquals((String)"ROLE_WMS_ALL", (String)user.getAuthorities()[1].getAuthority());
    }

    public void testSetMissingUser() throws Exception {
        try {
            this.dao.setUser(new User("notther", "pwd", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_WFS_ALL")}));
            GeoServerUserDaoTest.fail((String)"The user is not there, setUser should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testAddUser() throws Exception {
        this.dao.putUser(new User("newuser", "pwd", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_WFS_ALL")}));
        GeoServerUserDaoTest.assertNotNull((Object)this.dao.loadUserByUsername("newuser"));
    }

    public void addExistingUser() throws Exception {
        try {
            this.dao.putUser(new User("admin", "pwd", true, true, true, true, new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_WFS_ALL")}));
            GeoServerUserDaoTest.fail((String)"The user is already there, addUser should fail");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    public void testRemoveUser() throws Exception {
        GeoServerUserDaoTest.assertFalse((boolean)this.dao.removeUser("notthere"));
        GeoServerUserDaoTest.assertTrue((boolean)this.dao.removeUser("wfs"));
        try {
            this.dao.loadUserByUsername("wfs");
            GeoServerUserDaoTest.fail((String)"The user is not there, loadUserByName should fail");
        }
        catch (UsernameNotFoundException usernameNotFoundException) {
            // empty catch block
        }
    }

    public void testStoreReload() throws Exception {
        File temp = File.createTempFile("sectest", "", new File("target"));
        temp.delete();
        temp.mkdir();
        try {
            this.dao.securityDir = temp;
            this.dao.storeUsers();
            File propFile = new File(temp, "users.properties");
            this.dao.userDefinitionsFile = new PropertyFileWatcher(propFile);
            this.dao.userMap.clear();
            this.dao.loadUserMap();
        }
        finally {
            temp.delete();
        }
        GeoServerUserDaoTest.assertEquals((int)3, (int)this.dao.getUsers().size());
        this.testLoadUser();
    }

    static class TestableUserDao
    extends GeoserverUserDao {
        public TestableUserDao(Properties p) throws IOException {
            this.userMap = this.loadUsersFromProperties(p);
        }

        void checkUserMap() throws DataAccessResourceFailureException {
        }

        void loadUserMap() {
            super.checkUserMap();
        }
    }
}

