/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.acegisecurity.AcegiSecurityException;
import org.acegisecurity.context.SecurityContextHolder;
import org.easymock.classextension.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.ows.Dispatcher;
import org.geoserver.ows.Request;
import org.geoserver.security.AbstractAuthorizationTest;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;

public class SecureCatalogImplTest
extends AbstractAuthorizationTest {
    private List<LayerInfo> layers;
    private List<FeatureTypeInfo> featureTypes;
    private List<CoverageInfo> coverages;
    private Catalog catalog;
    private List<WorkspaceInfo> workspaces;

    protected void setUp() throws Exception {
        super.setUp();
        this.layers = Arrays.asList(this.statesLayer, this.roadsLayer, this.landmarksLayer, this.basesLayer, this.arcGridLayer);
        this.featureTypes = new ArrayList<FeatureTypeInfo>();
        this.coverages = new ArrayList<CoverageInfo>();
        for (LayerInfo layer : this.layers) {
            if (layer.getResource() instanceof FeatureTypeInfo) {
                this.featureTypes.add((FeatureTypeInfo)layer.getResource());
                continue;
            }
            this.coverages.add((CoverageInfo)layer.getResource());
        }
        this.workspaces = Arrays.asList(this.toppWs, this.nurcWs);
        this.catalog = (Catalog)org.easymock.EasyMock.createNiceMock(Catalog.class);
        org.easymock.EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:states")).andReturn((Object)this.states).anyTimes();
        org.easymock.EasyMock.expect((Object)((FeatureTypeInfo)this.catalog.getResourceByName("topp:states", FeatureTypeInfo.class))).andReturn((Object)this.states).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getLayerByName("topp:states")).andReturn((Object)this.statesLayer).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getCoverageByName("nurc:arcgrid")).andReturn((Object)this.arcGrid).anyTimes();
        org.easymock.EasyMock.expect((Object)((CoverageInfo)this.catalog.getResourceByName("nurc:arcgrid", CoverageInfo.class))).andReturn((Object)this.arcGrid).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:roads")).andReturn((Object)this.roads).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:landmarks")).andReturn((Object)this.landmarks).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:bases")).andReturn((Object)this.bases).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getDataStoreByName("states")).andReturn((Object)this.statesStore).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getDataStoreByName("roads")).andReturn((Object)this.roadsStore).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getCoverageStoreByName("arcGrid")).andReturn((Object)this.arcGridStore).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getLayers()).andReturn(this.layers).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getFeatureTypes()).andReturn(this.featureTypes).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getCoverages()).andReturn(this.coverages).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getWorkspaces()).andReturn(this.workspaces).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getWorkspaceByName("topp")).andReturn((Object)this.toppWs).anyTimes();
        org.easymock.EasyMock.expect((Object)this.catalog.getWorkspaceByName("nurc")).andReturn((Object)this.nurcWs).anyTimes();
        org.easymock.EasyMock.replay((Object[])new Object[]{this.catalog});
    }

    public void testWideOpen() throws Exception {
        DataAccessManager manager = this.buildManager("wideOpen.properties");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, manager);
        SecurityContextHolder.getContext().setAuthentication(this.anonymous);
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals(this.featureTypes, (Object)sc.getFeatureTypes());
        SecureCatalogImplTest.assertEquals(this.coverages, (Object)sc.getCoverages());
        SecureCatalogImplTest.assertEquals(this.workspaces, (Object)sc.getWorkspaces());
        SecureCatalogImplTest.assertEquals((Object)this.toppWs, (Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertSame((Object)this.statesStore, (Object)sc.getDataStoreByName("states"));
        SecureCatalogImplTest.assertSame((Object)this.roadsStore, (Object)sc.getDataStoreByName("roads"));
        SecureCatalogImplTest.assertSame((Object)this.arcGridStore, (Object)sc.getCoverageStoreByName("arcGrid"));
    }

    public void testLockedDown() throws Exception {
        DataAccessManager manager = this.buildManager("lockedDown.properties");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, manager);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        SecureCatalogImplTest.assertNull((Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertNull((Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertNull((Object)sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        SecureCatalogImplTest.assertNull((Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals((int)0, (int)sc.getFeatureTypes().size());
        SecureCatalogImplTest.assertEquals((int)0, (int)sc.getCoverages().size());
        SecureCatalogImplTest.assertEquals((int)0, (int)sc.getWorkspaces().size());
        SecureCatalogImplTest.assertNull((Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertNull((Object)sc.getDataStoreByName("states"));
        SecureCatalogImplTest.assertNull((Object)sc.getDataStoreByName("roads"));
        SecureCatalogImplTest.assertNull((Object)sc.getCoverageStoreByName("arcGrid"));
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals(this.featureTypes, (Object)sc.getFeatureTypes());
        SecureCatalogImplTest.assertEquals(this.coverages, (Object)sc.getCoverages());
        SecureCatalogImplTest.assertEquals(this.workspaces, (Object)sc.getWorkspaces());
        SecureCatalogImplTest.assertEquals((Object)this.toppWs, (Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertSame((Object)this.statesStore, (Object)sc.getDataStoreByName("states"));
        SecureCatalogImplTest.assertSame((Object)this.roadsStore, (Object)sc.getDataStoreByName("roads"));
        SecureCatalogImplTest.assertSame((Object)this.arcGridStore, (Object)sc.getCoverageStoreByName("arcGrid"));
    }

    public void testLockedChallenge() throws Exception {
        DataAccessManager manager = this.buildManager("lockedDownChallenge.properties");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, manager);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        try {
            sc.getFeatureTypeByName("topp:states").getFeatureSource(null, null);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getCoverageByName("nurc:arcgrid").getGridCoverage(null, null);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            ((FeatureTypeInfo)sc.getResourceByName("topp:states", FeatureTypeInfo.class)).getFeatureSource(null, null);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            ((CoverageInfo)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class)).getGridCoverage(null, null);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        sc.getWorkspaceByName("topp");
        try {
            sc.getDataStoreByName("states").getDataStore(null);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getDataStoreByName("roads").getDataStore(null);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getCoverageStoreByName("arcGrid").getFormat();
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        SecureCatalogImplTest.assertEquals((int)this.featureTypes.size(), (int)sc.getFeatureTypes().size());
        SecureCatalogImplTest.assertEquals((int)this.coverages.size(), (int)sc.getCoverages().size());
        SecureCatalogImplTest.assertEquals((int)this.workspaces.size(), (int)sc.getWorkspaces().size());
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals(this.featureTypes, (Object)sc.getFeatureTypes());
        SecureCatalogImplTest.assertEquals(this.coverages, (Object)sc.getCoverages());
        SecureCatalogImplTest.assertEquals(this.workspaces, (Object)sc.getWorkspaces());
        SecureCatalogImplTest.assertEquals((Object)this.toppWs, (Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertSame((Object)this.statesStore, (Object)sc.getDataStoreByName("states"));
        SecureCatalogImplTest.assertSame((Object)this.roadsStore, (Object)sc.getDataStoreByName("roads"));
        SecureCatalogImplTest.assertSame((Object)this.arcGridStore, (Object)sc.getCoverageStoreByName("arcGrid"));
    }

    public void testLockedMixed() throws Exception {
        DataAccessManager manager = this.buildManager("lockedDownMixed.properties");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, manager);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        Request request = (Request)EasyMock.createNiceMock(Request.class);
        EasyMock.expect((Object)request.getRequest()).andReturn((Object)"GetFeatures").anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        Dispatcher.REQUEST.set(request);
        try {
            sc.getFeatureTypeByName("topp:states");
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getCoverageByName("nurc:arcgrid");
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getResourceByName("topp:states", FeatureTypeInfo.class);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getResourceByName("nurc:arcgrid", CoverageInfo.class);
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getWorkspaceByName("topp");
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getDataStoreByName("states");
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getDataStoreByName("roads");
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        try {
            sc.getCoverageStoreByName("arcGrid");
            SecureCatalogImplTest.fail((String)"Should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        request = (Request)EasyMock.createNiceMock(Request.class);
        EasyMock.expect((Object)request.getRequest()).andReturn((Object)"GetCapabilities").anyTimes();
        EasyMock.replay((Object[])new Object[]{request});
        Dispatcher.REQUEST.set(request);
        SecureCatalogImplTest.assertEquals((int)0, (int)sc.getFeatureTypes().size());
        SecureCatalogImplTest.assertEquals((int)0, (int)sc.getCoverages().size());
        SecureCatalogImplTest.assertEquals((int)0, (int)sc.getWorkspaces().size());
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals(this.featureTypes, (Object)sc.getFeatureTypes());
        SecureCatalogImplTest.assertEquals(this.coverages, (Object)sc.getCoverages());
        SecureCatalogImplTest.assertEquals(this.workspaces, (Object)sc.getWorkspaces());
        SecureCatalogImplTest.assertEquals((Object)this.toppWs, (Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertSame((Object)this.statesStore, (Object)sc.getDataStoreByName("states"));
        SecureCatalogImplTest.assertSame((Object)this.roadsStore, (Object)sc.getDataStoreByName("roads"));
        SecureCatalogImplTest.assertSame((Object)this.arcGridStore, (Object)sc.getCoverageStoreByName("arcGrid"));
    }

    public void testPublicRead() throws Exception {
        DataAccessManager manager = this.buildManager("publicRead.properties");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, manager);
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals(this.coverages, (Object)sc.getCoverages());
        SecureCatalogImplTest.assertEquals(this.workspaces, (Object)sc.getWorkspaces());
        SecureCatalogImplTest.assertEquals((Object)this.toppWs, (Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertSame((Object)this.arcGridStore, (Object)sc.getCoverageStoreByName("arcGrid"));
        SecureCatalogImplTest.assertNotNull((Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:states") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getResourceByName("topp:states", FeatureTypeInfo.class) instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertEquals((int)this.featureTypes.size(), (int)sc.getFeatureTypes().size());
        for (FeatureTypeInfo ft : sc.getFeatureTypes()) {
            SecureCatalogImplTest.assertTrue((boolean)(ft instanceof SecuredFeatureTypeInfo));
        }
        SecureCatalogImplTest.assertNotNull((Object)sc.getLayerByName("topp:states"));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getLayerByName("topp:states") instanceof SecuredLayerInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getCoverageByName("nurc:arcgrid"));
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getResourceByName("topp:states", FeatureTypeInfo.class));
        SecureCatalogImplTest.assertSame((Object)this.arcGrid, (Object)sc.getResourceByName("nurc:arcgrid", CoverageInfo.class));
        SecureCatalogImplTest.assertEquals(this.featureTypes, (Object)sc.getFeatureTypes());
        SecureCatalogImplTest.assertEquals(this.coverages, (Object)sc.getCoverages());
        SecureCatalogImplTest.assertEquals(this.workspaces, (Object)sc.getWorkspaces());
        SecureCatalogImplTest.assertEquals((Object)this.toppWs, (Object)sc.getWorkspaceByName("topp"));
        SecureCatalogImplTest.assertSame((Object)this.statesStore, (Object)sc.getDataStoreByName("states"));
        SecureCatalogImplTest.assertSame((Object)this.roadsStore, (Object)sc.getDataStoreByName("roads"));
        SecureCatalogImplTest.assertSame((Object)this.arcGridStore, (Object)sc.getCoverageStoreByName("arcGrid"));
    }

    public void testComplex() throws Exception {
        DataAccessManager manager = this.buildManager("complex.properties");
        SecureCatalogImpl sc = new SecureCatalogImpl(this.catalog, manager);
        SecurityContextHolder.getContext().setAuthentication(this.anonymous);
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertNull((Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:landmarks") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertNull((Object)sc.getFeatureTypeByName("topp:bases"));
        SecurityContextHolder.getContext().setAuthentication(this.roUser);
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:states") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:landmarks") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertNull((Object)sc.getFeatureTypeByName("topp:bases"));
        SecurityContextHolder.getContext().setAuthentication(this.rwUser);
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertSame((Object)this.states, (Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertSame((Object)this.landmarks, (Object)sc.getFeatureTypeByName("topp:landmarks"));
        SecureCatalogImplTest.assertNull((Object)sc.getFeatureTypeByName("topp:bases"));
        SecurityContextHolder.getContext().setAuthentication(this.milUser);
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:roads") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("roads") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertNull((Object)sc.getFeatureTypeByName("topp:states"));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getDataStoreByName("states") instanceof SecuredDataStoreInfo));
        SecureCatalogImplTest.assertTrue((boolean)(sc.getFeatureTypeByName("topp:landmarks") instanceof SecuredFeatureTypeInfo));
        SecureCatalogImplTest.assertSame((Object)this.bases, (Object)sc.getFeatureTypeByName("topp:bases"));
    }
}

