/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.acegisecurity.AcegiSecurityException;
import org.geoserver.security.AbstractAuthorizationTest;
import org.geoserver.security.SecureCatalogImpl;
import org.geoserver.security.decorators.ReadOnlyDataStore;
import org.geoserver.security.decorators.ReadOnlyFeatureSource;
import org.geoserver.security.decorators.ReadOnlyFeatureStore;
import org.geoserver.security.decorators.SecuredCoverageInfo;
import org.geoserver.security.decorators.SecuredDataStoreInfo;
import org.geoserver.security.decorators.SecuredFeatureTypeInfo;
import org.geoserver.security.decorators.SecuredLayerInfo;

public class ReadOnlyDecoratorsTest
extends AbstractAuthorizationTest {
    public void testSecuredLayerInfoFeatures() {
        SecuredLayerInfo ro = new SecuredLayerInfo(this.statesLayer, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyDecoratorsTest.assertFalse((boolean)(this.statesLayer.getResource() instanceof SecuredFeatureTypeInfo));
        ReadOnlyDecoratorsTest.assertTrue((boolean)(ro.getResource() instanceof SecuredFeatureTypeInfo));
        ReadOnlyDecoratorsTest.assertSame((Object)ro.policy, (Object)((SecuredFeatureTypeInfo)ro.getResource()).policy);
    }

    public void testSecuredLayerInfoCoverages() {
        SecuredLayerInfo ro = new SecuredLayerInfo(this.arcGridLayer, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyDecoratorsTest.assertFalse((boolean)(this.arcGridLayer.getResource() instanceof SecuredCoverageInfo));
        ReadOnlyDecoratorsTest.assertTrue((boolean)(ro.getResource() instanceof SecuredCoverageInfo));
        ReadOnlyDecoratorsTest.assertSame((Object)ro.policy, (Object)((SecuredCoverageInfo)ro.getResource()).policy);
    }

    public void testSecuredFeatureTypeInfoHide() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyFeatureSource fs = (ReadOnlyFeatureSource)ro.getFeatureSource(null, null);
        ReadOnlyDecoratorsTest.assertEquals(ReadOnlyFeatureSource.class, fs.getClass());
        ReadOnlyDecoratorsTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.HIDE, (Object)fs.policy);
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        ReadOnlyDecoratorsTest.assertSame((Object)SecureCatalogImpl.WrapperPolicy.HIDE, (Object)store.policy);
    }

    public void testSecuredFeatureTypeInfoMetadata() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, SecureCatalogImpl.WrapperPolicy.METADATA);
        try {
            ro.getFeatureSource(null, null);
            ReadOnlyDecoratorsTest.fail((String)"This should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        ReadOnlyDecoratorsTest.assertSame((Object)SecureCatalogImpl.WrapperPolicy.METADATA, (Object)store.policy);
    }

    public void testSecuredTypeInfoReadOnly() throws Exception {
        SecuredFeatureTypeInfo ro = new SecuredFeatureTypeInfo(this.states, SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE);
        ReadOnlyFeatureStore fs = (ReadOnlyFeatureStore)ro.getFeatureSource(null, null);
        ReadOnlyDecoratorsTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE, (Object)fs.policy);
        SecuredDataStoreInfo store = (SecuredDataStoreInfo)ro.getStore();
        ReadOnlyDecoratorsTest.assertSame((Object)SecureCatalogImpl.WrapperPolicy.RO_CHALLENGE, (Object)store.policy);
    }

    public void testSecuredDataStoreInfoHide() throws Exception {
        SecuredDataStoreInfo ro = new SecuredDataStoreInfo(this.statesStore, SecureCatalogImpl.WrapperPolicy.HIDE);
        ReadOnlyDataStore dataStore = (ReadOnlyDataStore)ro.getDataStore(null);
        ReadOnlyDecoratorsTest.assertEquals((Object)SecureCatalogImpl.WrapperPolicy.HIDE, (Object)dataStore.policy);
    }

    public void testSecuredDataStoreInfoMetadata() throws Exception {
        SecuredDataStoreInfo ro = new SecuredDataStoreInfo(this.statesStore, SecureCatalogImpl.WrapperPolicy.METADATA);
        try {
            ReadOnlyDataStore dataStore = (ReadOnlyDataStore)ro.getDataStore(null);
            ReadOnlyDecoratorsTest.fail((String)"This should have failed with a security exception");
        }
        catch (AcegiSecurityException acegiSecurityException) {
            // empty catch block
        }
    }
}

