/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver;

import java.util.HashMap;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.ProjectionPolicy;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.referencing.CRS;
import org.opengis.feature.Feature;

public class ProjectionPolicyTest
extends GeoServerTestSupport {
    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("srsHandling", ProjectionPolicy.FORCE_DECLARED);
        props.put("srs", 4269);
        dataDirectory.addWellKnownType(MockData.BASIC_POLYGONS, props);
        props.put("srsHandling", ProjectionPolicy.REPROJECT_TO_DECLARED);
        props.put("srs", 3003);
        dataDirectory.addWellKnownType(MockData.LAKES, props);
        props.put("srsHandling", ProjectionPolicy.NONE);
        props.put("srs", 3004);
        dataDirectory.addWellKnownType(MockData.LINES, props);
    }

    public void testForce() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.BASIC_POLYGONS.getLocalPart());
        ProjectionPolicyTest.assertEquals((String)"EPSG:4269", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.FORCE_DECLARED, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4269"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:4269"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    public void testReproject() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getLocalPart());
        ProjectionPolicyTest.assertEquals((String)"EPSG:3003", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.REPROJECT_TO_DECLARED, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:3003"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:3003"), (Object)f.getType().getCoordinateReferenceSystem());
    }

    public void testLeaveNative() throws Exception {
        FeatureTypeInfo fti = this.getCatalog().getFeatureTypeByName(MockData.LINES.getLocalPart());
        ProjectionPolicyTest.assertEquals((String)"EPSG:3004", (String)fti.getSRS());
        ProjectionPolicyTest.assertEquals((Object)ProjectionPolicy.NONE, (Object)fti.getProjectionPolicy());
        FeatureCollection fc = fti.getFeatureSource(null, null).getFeatures();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:32615"), (Object)fc.getSchema().getCoordinateReferenceSystem());
        FeatureIterator fi = fc.features();
        Feature f = fi.next();
        fi.close();
        ProjectionPolicyTest.assertEquals((Object)CRS.decode((String)"EPSG:32615"), (Object)f.getType().getCoordinateReferenceSystem());
    }
}

