/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog;

import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.util.List;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.ResourcePool;
import org.geoserver.catalog.util.ReaderUtils;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.data.DataAccess;
import org.geotools.feature.NameImpl;
import org.opengis.feature.type.FeatureType;
import org.opengis.feature.type.Name;
import org.w3c.dom.Element;

public class ResourcePoolTest
extends GeoServerTestSupport {
    boolean cleared = false;
    boolean disposeCalled;

    public void testFeatureTypeCacheInstance() throws Exception {
        ResourcePool pool = new ResourcePool(this.getCatalog());
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureType ft1 = pool.getFeatureType(info);
        FeatureType ft2 = pool.getFeatureType(info);
        FeatureType ft3 = pool.getFeatureType(info);
        ResourcePoolTest.assertSame((Object)ft1, (Object)ft2);
        ResourcePoolTest.assertSame((Object)ft1, (Object)ft3);
    }

    public void testAttributeCache() throws Exception {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        FeatureTypeInfo oldInfo = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        List layers = catalog.getLayers((ResourceInfo)oldInfo);
        for (LayerInfo layerInfo : layers) {
            catalog.remove(layerInfo);
        }
        catalog.remove((ResourceInfo)oldInfo);
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.setStore(catalog.getStoreByName(MockData.CITE_PREFIX, MockData.CITE_PREFIX, DataStoreInfo.class));
        FeatureTypeInfo info = builder.buildFeatureType((Name)new NameImpl(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart()));
        List att1 = pool.getAttributes(info);
        List att2 = pool.getAttributes(info);
        ResourcePoolTest.assertNotSame((Object)att1, (Object)att2);
        ResourcePoolTest.assertEquals((Object)att1, (Object)att2);
        catalog.add((ResourceInfo)info);
        List att3 = pool.getAttributes(info);
        List att4 = pool.getAttributes(info);
        ResourcePoolTest.assertSame((Object)att3, (Object)att4);
        ResourcePoolTest.assertNotSame((Object)att1, (Object)att3);
        ResourcePoolTest.assertEquals((Object)att1, (Object)att3);
    }

    public void testCacheClearing() throws IOException {
        this.cleared = false;
        ResourcePool pool = new ResourcePool(this.getCatalog()){

            public void clear(FeatureTypeInfo info) {
                ResourcePoolTest.this.cleared = true;
                super.clear(info);
            }
        };
        FeatureTypeInfo info = this.getCatalog().getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ResourcePoolTest.assertNotNull((Object)pool.getFeatureType(info));
        info.setTitle("changed");
        ResourcePoolTest.assertFalse((boolean)this.cleared);
        this.getCatalog().save((ResourceInfo)info);
        ResourcePoolTest.assertTrue((boolean)this.cleared);
        this.cleared = false;
        ResourcePoolTest.assertNotNull((Object)pool.getFeatureType(info));
        for (LayerInfo l : this.getCatalog().getLayers((ResourceInfo)info)) {
            this.getCatalog().remove(l);
        }
        this.getCatalog().remove((ResourceInfo)info);
        ResourcePoolTest.assertTrue((boolean)this.cleared);
    }

    public void testDispose() throws IOException {
        this.disposeCalled = false;
        Catalog catalog = this.getCatalog();
        class ResourcePool2
        extends ResourcePool {
            public ResourcePool2(Catalog catalog) {
                super(catalog);
                this.dataStoreCache = new ResourcePool.DataStoreCache(this){

                    void dispose(String name, DataAccess dataStore) {
                        ((ResourcePool2)this).ResourcePoolTest.this.disposeCalled = true;
                        super.dispose(name, dataStore);
                    }
                };
            }
        }
        ResourcePool2 pool = new ResourcePool2(catalog);
        catalog.setResourcePool((ResourcePool)pool);
        DataStoreInfo info = (DataStoreInfo)catalog.getDataStores().get(0);
        DataAccess dataStore = pool.getDataStore(info);
        ResourcePoolTest.assertNotNull((Object)dataStore);
        ResourcePoolTest.assertFalse((boolean)this.disposeCalled);
        pool.clear(info);
        ResourcePoolTest.assertTrue((boolean)this.disposeCalled);
        dataStore = pool.getDataStore(info);
        ResourcePoolTest.assertNotNull((Object)dataStore);
        this.disposeCalled = false;
        pool.dispose();
        ResourcePoolTest.assertTrue((boolean)this.disposeCalled);
    }

    public void testLRU() throws IOException {
        Catalog catalog = this.getCatalog();
        ResourcePool pool = new ResourcePool(catalog);
        pool.setFeatureTypeCacheSize(2);
        catalog.setResourcePool(pool);
        FeatureTypeInfo lakes = catalog.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        FeatureTypeInfo lines = catalog.getFeatureTypeByName(MockData.LINES.getNamespaceURI(), MockData.LINES.getLocalPart());
        FeatureTypeInfo locks = catalog.getFeatureTypeByName(MockData.LOCKS.getNamespaceURI(), MockData.LOCKS.getLocalPart());
        pool.getFeatureType(lakes);
        pool.getFeatureType(lines);
        pool.getFeatureType(locks);
        ResourcePoolTest.assertEquals((String)"LRU cache size should never exceed set limit", (int)2, (int)pool.featureTypeCache.size());
    }

    public void testGeoServerReload() throws Exception {
        Catalog cat = this.getCatalog();
        FeatureTypeInfo lakes = cat.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ResourcePoolTest.assertFalse((boolean)"foo".equals(lakes.getTitle()));
        File info = this.getResourceLoader().find(new String[]{"featureTypes", "cite_Lakes", "info.xml"});
        FileReader in = new FileReader(info);
        Element dom = ReaderUtils.parse((Reader)in);
        Element title = ReaderUtils.getChildElement((Element)dom, (String)"title");
        title.getFirstChild().setNodeValue("foo");
        FileOutputStream output = new FileOutputStream(info);
        try {
            TransformerFactory.newInstance().newTransformer().transform(new DOMSource(dom), new StreamResult(output));
        }
        finally {
            ((OutputStream)output).close();
        }
        this.getGeoServer().reload();
        lakes = cat.getFeatureTypeByName(MockData.LAKES.getNamespaceURI(), MockData.LAKES.getLocalPart());
        ResourcePoolTest.assertEquals((String)"foo", (String)lakes.getTitle());
    }

    public void testConfigureFeatureTypeCacheSize() {
        GeoServer gs = this.getGeoServer();
        GeoServerInfo global = gs.getGlobal();
        global.setFeatureTypeCacheSize(200);
        gs.save(global);
        Catalog catalog = this.getCatalog();
        ResourcePoolTest.assertEquals((int)200, (int)catalog.getResourcePool().featureTypeCache.maxSize());
    }
}

