/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.ConfigurationListener;
import org.geoserver.config.ConfigurationListenerAdapter;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerLoader;
import org.geoserver.config.GeoServerPersister;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamServiceLoader;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.platform.GeoServerResourceLoader;

public class DefaultGeoServerLoader
extends GeoServerLoader {
    ConfigurationListener listener;
    GeoServerPersister persister;

    public DefaultGeoServerLoader(GeoServerResourceLoader resourceLoader) {
        super(resourceLoader);
    }

    protected void loadCatalog(Catalog catalog, XStreamPersister xp) throws Exception {
        catalog.setResourceLoader(this.resourceLoader);
        this.readCatalog(catalog, xp);
        if (!legacy) {
            catalog.addListener(new GeoServerPersister(this.resourceLoader, xp));
        }
    }

    protected void loadGeoServer(final GeoServer geoServer, XStreamPersister xp) throws Exception {
        if (this.listener == null) {
            final List loaders = GeoServerExtensions.extensions(XStreamServiceLoader.class);
            this.listener = new ConfigurationListenerAdapter(){

                public void handlePostServiceChange(ServiceInfo service) {
                    for (XStreamServiceLoader l : loaders) {
                        if (!l.getServiceClass().isInstance(service)) continue;
                        try {
                            l.save(service, geoServer);
                        }
                        catch (Throwable t) {
                            LOGGER.log(Level.SEVERE, "Error occurred while saving configuration", t);
                        }
                    }
                }
            };
            geoServer.addListener(this.listener);
        }
        try {
            if (this.persister != null) {
                this.geoserver.removeListener(this.persister);
            } else {
                this.persister = new GeoServerPersister(this.resourceLoader, xp);
            }
            this.readConfiguration(geoServer, xp);
        }
        finally {
            this.geoserver.addListener(this.persister);
        }
    }

    protected void initializeStyles(Catalog catalog, XStreamPersister xp) throws IOException {
        GeoServerPersister p = new GeoServerPersister(this.resourceLoader, xp);
        catalog.addListener(p);
        super.initializeStyles(catalog, xp);
        catalog.removeListener(p);
    }
}

