/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geoserver.config.ServiceLoader;
import org.geoserver.config.impl.ServiceInfoImpl;
import org.geoserver.config.util.XStreamPersister;
import org.geoserver.config.util.XStreamPersisterFactory;
import org.geoserver.platform.GeoServerResourceLoader;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class XStreamServiceLoader<T extends ServiceInfo>
implements ServiceLoader<T> {
    GeoServerResourceLoader resourceLoader;
    String filenameBase;
    XStreamPersisterFactory xpf = new XStreamPersisterFactory();

    public XStreamServiceLoader(GeoServerResourceLoader resourceLoader, String filenameBase) {
        this.resourceLoader = resourceLoader;
        this.filenameBase = filenameBase;
    }

    public void setXStreamPeristerFactory(XStreamPersisterFactory xpf) {
        this.xpf = xpf;
    }

    @Override
    public final T load(GeoServer gs) throws Exception {
        String filename = String.valueOf(this.filenameBase) + ".xml";
        File file = this.resourceLoader.find(filename);
        if (file != null && file.exists()) {
            BufferedInputStream in = new BufferedInputStream(new FileInputStream(file));
            try {
                XStreamPersister xp = this.xpf.createXMLPersister();
                this.initXStreamPersister(xp, gs);
                ServiceInfo serviceInfo = this.initialize((ServiceInfo)xp.load(in, this.getServiceClass()));
                return (T)serviceInfo;
            }
            finally {
                in.close();
            }
        }
        T service = this.createServiceFromScratch(gs);
        return this.initialize(service);
    }

    protected T initialize(T service) {
        if (service instanceof ServiceInfoImpl) {
            ServiceInfoImpl impl = (ServiceInfoImpl)service;
            if (impl.getClientProperties() == null) {
                impl.setClientProperties(new HashMap());
            }
            if (impl.getExceptionFormats() == null) {
                impl.setExceptionFormats(new ArrayList());
            }
            if (impl.getKeywords() == null) {
                impl.setKeywords(new ArrayList());
            }
            if (impl.getMetadata() == null) {
                impl.setMetadata(new MetadataMap());
            }
            if (impl.getVersions() == null) {
                impl.setVersions(new ArrayList());
            }
        }
        return service;
    }

    @Override
    public void save(T service, GeoServer gs) throws Exception {
        String filename = String.valueOf(this.filenameBase) + ".xml";
        File file = this.resourceLoader.find(filename);
        if (file == null) {
            file = this.resourceLoader.createFile(filename);
        }
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            XStreamPersister xp = this.xpf.createXMLPersister();
            this.initXStreamPersister(xp, gs);
            xp.save(service, out);
            out.flush();
        }
        finally {
            out.close();
        }
    }

    protected void initXStreamPersister(XStreamPersister xp, GeoServer gs) {
        xp.setGeoServer(gs);
        xp.setCatalog(gs.getCatalog());
        xp.getXStream().alias(this.filenameBase, this.getServiceClass());
    }

    protected abstract T createServiceFromScratch(GeoServer var1);
}

