/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.data.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.coverage.grid.io.GridFormatFactorySpi;
import org.geotools.coverage.grid.io.GridFormatFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.geometry.Envelope;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterValue;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public final class CoverageStoreUtils {
    private static final Logger LOGGER = Logging.getLogger((String)CoverageStoreUtils.class.toString());
    public static final Format[] formats = GridFormatFinder.getFormatArray();

    private CoverageStoreUtils() {
    }

    public static Format acquireFormat(String type) throws IOException {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format = null;
        int length = formats.length;
        int i = 0;
        while (i < length) {
            if (formats[i].getName().equals(type)) {
                format = formats[i];
                break;
            }
            ++i;
        }
        if (format == null) {
            throw new IOException("Cannot handle format: " + type);
        }
        return format;
    }

    public static ParameterValue find(Format format, String key) {
        return CoverageStoreUtils.find(format.getReadParameters(), key);
    }

    public static ParameterValue find(ParameterValueGroup params, String key) {
        List list2 = params.values();
        for (ParameterValue val : list2) {
            ParameterDescriptor descr = val.getDescriptor();
            if (!key.equalsIgnoreCase(descr.getName().toString())) continue;
            return val;
        }
        return null;
    }

    public static Format aquireFactoryByType(String type) {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format = null;
        int length = formats.length;
        int i = 0;
        while (i < length) {
            format = formats[i];
            if (format.getName().equals(type)) {
                return format;
            }
            ++i;
        }
        return null;
    }

    public static Format aquireFactory(String description) {
        Format[] formats = GridFormatFinder.getFormatArray();
        Format format = null;
        int length = formats.length;
        int i = 0;
        while (i < length) {
            format = formats[i];
            if (format.getDescription().equals(description)) {
                return format;
            }
            ++i;
        }
        return null;
    }

    public static List listDataFormatsDescriptions() {
        ArrayList<String> list2 = new ArrayList<String>();
        Format[] formats = GridFormatFinder.getFormatArray();
        int length = formats.length;
        int i = 0;
        while (i < length) {
            if (!list2.contains(formats[i].getDescription())) {
                list2.add(formats[i].getDescription());
            }
            ++i;
        }
        return Collections.synchronizedList(list2);
    }

    public static List listDataFormats() {
        ArrayList<Format> list2 = new ArrayList<Format>();
        Format[] formats = GridFormatFinder.getFormatArray();
        int length = formats.length;
        int i = 0;
        while (i < length) {
            if (!list2.contains(formats[i])) {
                list2.add(formats[i]);
            }
            ++i;
        }
        return Collections.synchronizedList(list2);
    }

    public static Map defaultParams(String description) {
        return Collections.synchronizedMap(CoverageStoreUtils.defaultParams(CoverageStoreUtils.aquireFactory(description)));
    }

    public static Map defaultParams(Format factory) {
        HashMap<String, Object> defaults = new HashMap<String, Object>();
        ParameterValueGroup params = factory.getReadParameters();
        if (params != null) {
            List list2 = params.values();
            Iterator it = list2.iterator();
            ParameterDescriptor descr = null;
            ParameterValue val = null;
            while (it.hasNext()) {
                val = (ParameterValue)it.next();
                descr = val.getDescriptor();
                String key = descr.getName().toString();
                Object value = null;
                if (val.getValue() != null) {
                    value = "values_palette".equalsIgnoreCase(key) ? val.getValue() : val.getValue().toString();
                }
                if (value == null) {
                    value = "";
                }
                if (value == null) continue;
                defaults.put(key, value);
            }
        }
        return Collections.synchronizedMap(defaults);
    }

    public static Map toParams(GridFormatFactorySpi factory, Map params) throws IOException {
        HashMap<String, Object> map = new HashMap<String, Object>(params.size());
        ParameterValueGroup info = factory.createFormat().getReadParameters();
        for (String key : params.keySet()) {
            Object value = CoverageStoreUtils.find(info, key).getValue();
            if (value == null) continue;
            map.put(key, value);
        }
        return Collections.synchronizedMap(map);
    }

    public static GeneralEnvelope getWGS84LonLatEnvelope(GeneralEnvelope envelope) throws IndexOutOfBoundsException, FactoryException, TransformException {
        CoordinateReferenceSystem sourceCRS = envelope.getCoordinateReferenceSystem();
        if (CRS.equalsIgnoreMetadata((Object)sourceCRS, (Object)DefaultGeographicCRS.WGS84)) {
            return new GeneralEnvelope((Envelope)envelope);
        }
        DefaultGeographicCRS targetCRS = DefaultGeographicCRS.WGS84;
        MathTransform mathTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS, (boolean)true);
        GeneralEnvelope targetEnvelope = !mathTransform.isIdentity() ? CRS.transform((MathTransform)mathTransform, (Envelope)envelope) : new GeneralEnvelope((Envelope)envelope);
        targetEnvelope.setCoordinateReferenceSystem((CoordinateReferenceSystem)targetCRS);
        return targetEnvelope;
    }
}

