/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.CatalogMode;
import org.geoserver.security.CoverageAccessLimits;
import org.geoserver.security.DataAccessLimits;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WMSAccessLimits;
import org.geoserver.security.WorkspaceAccessLimits;
import org.geotools.factory.CommonFactoryFinder;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.PropertyName;
import org.opengis.parameter.GeneralParameterValue;
import org.springframework.security.Authentication;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class ResourceAccessManagerWrapper
implements ResourceAccessManager {
    protected ResourceAccessManager delegate;
    private static FilterFactory2 factory = CommonFactoryFinder.getFilterFactory2(null);
    private static GeometryFactory geomFactory = new GeometryFactory();

    protected CatalogMode intersection(CatalogMode a, CatalogMode b) {
        if (a == CatalogMode.HIDE || b == CatalogMode.HIDE) {
            return CatalogMode.HIDE;
        }
        if (a == CatalogMode.MIXED || b == CatalogMode.MIXED) {
            return CatalogMode.MIXED;
        }
        if (a == CatalogMode.CHALLENGE || b == CatalogMode.CHALLENGE) {
            return CatalogMode.CHALLENGE;
        }
        return CatalogMode.HIDE;
    }

    protected DataAccessLimits intersection(DataAccessLimits a, DataAccessLimits b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a instanceof VectorAccessLimits && b instanceof VectorAccessLimits) {
            return this.intersection((VectorAccessLimits)a, (VectorAccessLimits)b);
        }
        if (a instanceof CoverageAccessLimits && b instanceof CoverageAccessLimits) {
            return this.intersection((CoverageAccessLimits)a, (CoverageAccessLimits)b);
        }
        if (a instanceof WMSAccessLimits && b instanceof WMSAccessLimits) {
            return this.intersection((WMSAccessLimits)a, (WMSAccessLimits)b);
        }
        throw new IllegalArgumentException("Tried to get intersection of differing or unanticipated types of DataAccessLimits (" + a + " && " + b + ")");
    }

    protected VectorAccessLimits intersection(VectorAccessLimits a, VectorAccessLimits b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        List<PropertyName> readAttributes = this.intersection(a.getReadAttributes(), b.getReadAttributes());
        Filter readFilter = this.intersection(a.getReadFilter(), b.getReadFilter());
        List<PropertyName> writeAttributes = this.intersection(a.getReadAttributes(), b.getReadAttributes());
        Filter writeFilter = this.intersection(a.getWriteFilter(), b.getWriteFilter());
        return new VectorAccessLimits(mode, readAttributes, readFilter, writeAttributes, writeFilter);
    }

    protected CoverageAccessLimits intersection(CoverageAccessLimits a, CoverageAccessLimits b) {
        MultiPolygon rasterFilter;
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        MultiPolygon aFilter = a.getRasterFilter();
        MultiPolygon bFilter = b.getRasterFilter();
        if (aFilter == null) {
            rasterFilter = bFilter;
        } else if (bFilter == null) {
            rasterFilter = aFilter;
        } else {
            Geometry intersection = aFilter.intersection((Geometry)bFilter);
            if (intersection instanceof MultiPolygon) {
                rasterFilter = (MultiPolygon)intersection;
            } else {
                final ArrayList accum = new ArrayList();
                intersection.apply(new GeometryComponentFilter(){

                    public void filter(Geometry geom) {
                        if (geom instanceof Polygon) {
                            accum.add((Polygon)geom);
                        }
                    }
                });
                rasterFilter = geomFactory.createMultiPolygon(accum.toArray(new Polygon[accum.size()]));
            }
        }
        Object readFilter = rasterFilter != null && rasterFilter.getNumGeometries() == 0 ? Filter.EXCLUDE : this.intersection(a.getReadFilter(), b.getReadFilter());
        GeneralParameterValue[] params = this.intersection(a.getParams(), b.getParams());
        return new CoverageAccessLimits(mode, (Filter)readFilter, rasterFilter, params);
    }

    protected WMSAccessLimits intersection(WMSAccessLimits a, WMSAccessLimits b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        Filter readFilter = this.intersection(a.getReadFilter(), b.getReadFilter());
        MultiPolygon rasterFilter = null;
        MultiPolygon aFilter = a.getRasterFilter();
        MultiPolygon bFilter = b.getRasterFilter();
        rasterFilter = aFilter == null ? bFilter : (bFilter == null ? aFilter : (MultiPolygon)aFilter.intersection((Geometry)bFilter));
        boolean allowFeatureInfo = a.isAllowFeatureInfo() && b.isAllowFeatureInfo();
        return new WMSAccessLimits(mode, readFilter, rasterFilter, allowFeatureInfo);
    }

    protected Filter intersection(Filter a, Filter b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        if (a == Filter.INCLUDE && b == Filter.INCLUDE) {
            return Filter.INCLUDE;
        }
        if (a == Filter.EXCLUDE || b == Filter.EXCLUDE) {
            return Filter.EXCLUDE;
        }
        return factory.and(a, b);
    }

    protected GeneralParameterValue[] intersection(GeneralParameterValue[] a, GeneralParameterValue[] b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<Integer> indices = new ArrayList<Integer>(Math.min(a.length, b.length));
        List<GeneralParameterValue> bAsList = Arrays.asList(b);
        int i = 0;
        while (i < a.length) {
            if (bAsList.contains(a[i])) {
                indices.add(i);
            }
            ++i;
        }
        if (indices.size() == a.length) {
            return a;
        }
        GeneralParameterValue[] results = new GeneralParameterValue[indices.size()];
        int i2 = 0;
        while (i2 < indices.size()) {
            results[i2] = a[(Integer)indices.get(i2)];
            ++i2;
        }
        return results;
    }

    protected List<PropertyName> intersection(List<PropertyName> a, List<PropertyName> b) {
        if (a == null) {
            return b;
        }
        if (b == null) {
            return a;
        }
        ArrayList<PropertyName> results = new ArrayList<PropertyName>();
        for (PropertyName p : a) {
            if (!b.contains(p)) continue;
            results.add(p);
        }
        return results;
    }

    protected WorkspaceAccessLimits intersection(WorkspaceAccessLimits a, WorkspaceAccessLimits b) {
        CatalogMode mode = this.intersection(a.getMode(), b.getMode());
        return new WorkspaceAccessLimits(mode, a.isReadable() && b.isReadable(), a.isWritable() && b.isWritable());
    }

    public void setDelegate(ResourceAccessManager delegate) {
        this.delegate = delegate;
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, ResourceInfo resource) {
        return this.delegate.getAccessLimits(user, resource);
    }

    @Override
    public DataAccessLimits getAccessLimits(Authentication user, LayerInfo layer) {
        return this.delegate.getAccessLimits(user, layer);
    }

    @Override
    public WorkspaceAccessLimits getAccessLimits(Authentication user, WorkspaceInfo workspace) {
        return this.delegate.getAccessLimits(user, workspace);
    }
}

