/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import java.io.IOException;
import org.geoserver.security.WrapperPolicy;
import org.geoserver.security.decorators.SecuredFeatureStore;
import org.geoserver.security.decorators.SecurityUtils;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureLock;
import org.geotools.data.FeatureLocking;
import org.geotools.data.FeatureStore;
import org.geotools.data.Query;
import org.opengis.feature.Feature;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SecuredFeatureLocking<T extends FeatureType, F extends Feature>
extends SecuredFeatureStore<T, F>
implements FeatureLocking<T, F> {
    FeatureLocking lockDelegate;

    protected SecuredFeatureLocking(FeatureLocking delegate, WrapperPolicy policy) {
        super((FeatureStore)delegate, policy);
        this.lockDelegate = delegate;
    }

    public int lockFeatures() throws IOException {
        return this.lockFeatures((Filter)Filter.INCLUDE);
    }

    public int lockFeatures(Query query) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Query mixed = DataUtilities.mixQueries((Query)query, (Query)writeQuery, (String)query.getHandle());
        Filter writeFilter = writeQuery.getFilter();
        if (writeFilter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        if (writeFilter == Filter.INCLUDE) {
            return this.lockDelegate.lockFeatures(query);
        }
        return this.lockDelegate.lockFeatures(mixed);
    }

    public int lockFeatures(Filter filter) throws IOException {
        return this.lockDelegate.lockFeatures(new Query(null, filter));
    }

    public void setFeatureLock(FeatureLock lock) {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        if (writeQuery.getFilter() == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        this.lockDelegate.setFeatureLock(lock);
    }

    public void unLockFeatures() throws IOException {
        this.unLockFeatures(Query.ALL);
    }

    public void unLockFeatures(Filter filter) throws IOException {
        this.unLockFeatures(new Query(null, filter));
    }

    public void unLockFeatures(Query query) throws IOException {
        Query writeQuery = SecurityUtils.getWriteQuery(this.policy);
        Query mixed = DataUtilities.mixQueries((Query)query, (Query)writeQuery, (String)query.getHandle());
        Filter writeFilter = writeQuery.getFilter();
        if (writeFilter == Filter.EXCLUDE) {
            throw this.unsupportedOperation();
        }
        if (writeFilter == Filter.INCLUDE) {
            this.lockDelegate.unLockFeatures(query);
        } else {
            this.lockDelegate.unLockFeatures(mixed);
        }
    }
}

