/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.decorators;

import org.geoserver.security.AccessLevel;
import org.geoserver.security.VectorAccessLimits;
import org.geoserver.security.WrapperPolicy;
import org.geotools.data.Query;
import org.opengis.filter.Filter;

class SecurityUtils {
    SecurityUtils() {
    }

    static Query getWriteQuery(WrapperPolicy policy) {
        if (policy.getAccessLevel() != AccessLevel.READ_WRITE) {
            return new Query(null, (Filter)Filter.EXCLUDE);
        }
        if (policy.getLimits() == null) {
            return Query.ALL;
        }
        if (policy.getLimits() instanceof VectorAccessLimits) {
            VectorAccessLimits val = (VectorAccessLimits)policy.getLimits();
            return val.getWriteQuery();
        }
        throw new IllegalArgumentException("SecureFeatureStore has been fed with unexpected AccessLimits class " + policy.getLimits().getClass());
    }
}

