/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.platform.GeoServerExtensions;
import org.geoserver.security.PropertyFileWatcher;
import org.geotools.util.logging.Logging;
import org.springframework.dao.DataAccessException;
import org.springframework.dao.DataAccessResourceFailureException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.userdetails.User;
import org.springframework.security.userdetails.UserDetails;
import org.springframework.security.userdetails.UserDetailsService;
import org.springframework.security.userdetails.UsernameNotFoundException;
import org.springframework.security.userdetails.memory.UserAttribute;
import org.springframework.security.userdetails.memory.UserAttributeEditor;
import org.vfny.geoserver.global.GeoserverDataDirectory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GeoserverUserDao
implements UserDetailsService {
    static Logger LOGGER = Logging.getLogger((String)"org.geoserver.security");
    TreeMap<String, User> userMap;
    PropertyFileWatcher userDefinitionsFile;
    File securityDir;

    public static GeoserverUserDao get() {
        return (GeoserverUserDao)GeoServerExtensions.bean(GeoserverUserDao.class);
    }

    public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException, DataAccessException {
        this.checkUserMap();
        UserDetails user = (UserDetails)this.userMap.get(username);
        if (user == null) {
            throw new UsernameNotFoundException("Could not find user: " + username);
        }
        return user;
    }

    void checkUserMap() throws DataAccessResourceFailureException {
        block26: {
            InputStream is = null;
            OutputStream os = null;
            if (this.userMap == null || this.userDefinitionsFile == null || this.userDefinitionsFile.isStale()) {
                try {
                    try {
                        if (this.userDefinitionsFile == null) {
                            this.securityDir = GeoserverDataDirectory.findCreateConfigDir("security");
                            File propFile = new File(this.securityDir, "users.properties");
                            if (!propFile.exists()) {
                                Properties p = new Properties();
                                GeoServerInfo global = ((GeoServer)GeoServerExtensions.bean(GeoServer.class)).getGlobal();
                                if (global != null && global.getAdminUsername() != null && !global.getAdminUsername().trim().equals("")) {
                                    p.put(global.getAdminUsername(), String.valueOf(global.getAdminPassword()) + ",ROLE_ADMINISTRATOR");
                                } else {
                                    p.put("admin", "geoserver,ROLE_ADMINISTRATOR");
                                }
                                os = new FileOutputStream(propFile);
                                p.store(os, "Format: name=password,ROLE1,...,ROLEN");
                                os.close();
                                File serviceFile = new File(this.securityDir, "service.properties");
                                os = new FileOutputStream(serviceFile);
                                is = GeoserverUserDao.class.getResourceAsStream("serviceTemplate.properties");
                                byte[] buffer = new byte[1024];
                                int count = 0;
                                while ((count = is.read(buffer)) > 0) {
                                    os.write(buffer, 0, count);
                                }
                            }
                            this.userDefinitionsFile = new PropertyFileWatcher(propFile);
                        }
                        this.userMap = this.loadUsersFromProperties(this.userDefinitionsFile.getProperties());
                    }
                    catch (Exception e) {
                        LOGGER.log(Level.SEVERE, "An error occurred loading user definitions", e);
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        if (os == null) break block26;
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                finally {
                    if (is != null) {
                        try {
                            is.close();
                        }
                        catch (IOException iOException) {}
                    }
                    if (os != null) {
                        try {
                            os.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    public List<String> getRoles() {
        this.checkUserMap();
        TreeSet<String> roles = new TreeSet<String>();
        roles.add("ROLE_ADMINISTRATOR");
        for (User user : this.getUsers()) {
            GrantedAuthority[] grantedAuthorityArray = user.getAuthorities();
            int n = grantedAuthorityArray.length;
            int n2 = 0;
            while (n2 < n) {
                GrantedAuthority ga = grantedAuthorityArray[n2];
                roles.add(ga.getAuthority());
                ++n2;
            }
        }
        return new ArrayList<String>(roles);
    }

    public List<User> getUsers() {
        this.checkUserMap();
        return new ArrayList<User>(this.userMap.values());
    }

    public void putUser(User user) {
        this.checkUserMap();
        if (this.userMap.containsKey(user.getUsername())) {
            throw new IllegalArgumentException("The user " + user.getUsername() + " already exists");
        }
        this.userMap.put(user.getUsername(), user);
    }

    public void setUser(User user) {
        this.checkUserMap();
        if (!this.userMap.containsKey(user.getUsername())) {
            throw new IllegalArgumentException("The user " + user.getUsername() + " already exists");
        }
        this.userMap.put(user.getUsername(), user);
    }

    public boolean removeUser(String username) {
        this.checkUserMap();
        return this.userMap.remove(username) != null;
    }

    public void storeUsers() throws IOException {
        FileOutputStream os = null;
        try {
            try {
                Properties p = this.storeUsersToProperties(this.userMap);
                File propFile = new File(this.securityDir, "users.properties");
                os = new FileOutputStream(propFile);
                p.store(os, null);
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw (IOException)new IOException("Could not write updated users list to file system").initCause(e);
            }
        }
        finally {
            if (os != null) {
                os.close();
            }
        }
    }

    public void reload() {
        this.userDefinitionsFile = null;
    }

    TreeMap<String, User> loadUsersFromProperties(Properties props) {
        TreeMap<String, User> users = new TreeMap<String, User>();
        UserAttributeEditor configAttribEd = new UserAttributeEditor();
        for (String string : props.keySet()) {
            configAttribEd.setAsText(props.getProperty(string));
            UserAttribute attr = (UserAttribute)configAttribEd.getValue();
            if (attr == null) continue;
            User user = this.createUserObject(string, attr.getPassword(), attr.isEnabled(), attr.getAuthorities());
            users.put(string, user);
        }
        return users;
    }

    protected User createUserObject(String username, String password, boolean isEnabled, GrantedAuthority[] authorities) {
        return new User(username, password, isEnabled, true, true, true, authorities);
    }

    Properties storeUsersToProperties(Map<String, User> userMap) {
        Properties p = new Properties();
        for (User user : userMap.values()) {
            p.setProperty(user.getUsername(), this.serializeUser(user));
        }
        return p;
    }

    String serializeUser(User user) {
        StringBuffer sb = new StringBuffer();
        sb.append(user.getPassword());
        sb.append(",");
        GrantedAuthority[] grantedAuthorityArray = user.getAuthorities();
        int n = grantedAuthorityArray.length;
        int n2 = 0;
        while (n2 < n) {
            GrantedAuthority ga = grantedAuthorityArray[n2];
            sb.append(ga.getAuthority());
            sb.append(",");
            ++n2;
        }
        sb.append(user.isEnabled() ? "enabled" : "disabled");
        return sb.toString();
    }
}

