/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.servlets;

import java.io.IOException;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.geoserver.catalog.Catalog;
import org.geoserver.config.GeoServer;
import org.geoserver.config.ServiceInfo;
import org.geotools.util.logging.Logging;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.web.context.WebApplicationContext;
import org.vfny.geoserver.Response;
import org.vfny.geoserver.util.requests.readers.KvpRequestReader;
import org.vfny.geoserver.util.requests.readers.XmlRequestReader;

public abstract class AbstractService
extends HttpServlet
implements ApplicationContextAware {
    protected static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver.servlets");
    String service;
    String request;
    WebApplicationContext context;
    GeoServer geoServer;
    Catalog catalog;
    String serviceStrategy;
    int partialBufferSize;
    ServiceInfo serviceRef;
    private String kvpString;

    public AbstractService(String service, String request, ServiceInfo serviceRef) {
        this.service = service;
        this.request = request;
        this.serviceRef = serviceRef;
    }

    public String getService() {
        return this.service;
    }

    public String getRequest() {
        return this.request;
    }

    public void setServiceRef(ServiceInfo serviceRef) {
        this.serviceRef = serviceRef;
    }

    public ServiceInfo getServiceRef() {
        return this.serviceRef;
    }

    public void setApplicationContext(ApplicationContext context) throws BeansException {
        this.context = (WebApplicationContext)context;
    }

    public WebApplicationContext getApplicationContext() {
        return this.context;
    }

    public void setGeoServer(GeoServer geoServer) {
        this.geoServer = geoServer;
    }

    public GeoServer getGeoServer() {
        return this.geoServer;
    }

    public Catalog getCatalog() {
        return this.catalog;
    }

    public void setCatalog(Catalog catalog) {
        this.catalog = catalog;
    }

    public String getServiceStrategy() {
        return this.serviceStrategy;
    }

    public void setServiceStrategy(String serviceStrategy) {
        this.serviceStrategy = serviceStrategy;
    }

    protected boolean isServiceEnabled(HttpServletRequest req) {
        return true;
    }

    public ServletContext getServletContext() {
        return this.context.getServletContext();
    }

    protected void sendDisabledServiceError(HttpServletResponse response) throws IOException {
        response.sendError(503, String.valueOf(this.getService()) + " service is not enabled. " + "You can enable it in the web admin tool.");
    }

    protected Response getResponseHandler() {
        return null;
    }

    public final Response getResponse() {
        return this.getResponseHandler();
    }

    protected KvpRequestReader getKvpReader(Map params) {
        return null;
    }

    protected XmlRequestReader getXmlRequestReader() {
        return null;
    }

    protected void send(HttpServletResponse response, CharSequence content, String mimeType) {
        try {
            response.setContentType(mimeType);
            response.getWriter().write(content.toString());
        }
        catch (IOException ex) {
            LOGGER.info("Stream abruptly closed by client, response aborted");
            LOGGER.fine(ex.getMessage());
        }
        catch (IllegalStateException ex) {
            LOGGER.info("Stream abruptly closed by client, response aborted");
            LOGGER.fine(ex.getMessage());
        }
    }

    protected boolean requestSupportsGzip(HttpServletRequest request) {
        boolean supportsGzip = false;
        String header = request.getHeader("accept-encoding");
        if (header != null && header.indexOf("gzip") > -1) {
            supportsGzip = true;
        }
        if (LOGGER.isLoggable(Level.CONFIG)) {
            LOGGER.config("user-agent=" + request.getHeader("user-agent"));
            LOGGER.config("accept=" + request.getHeader("accept"));
            LOGGER.config("accept-encoding=" + request.getHeader("accept-encoding"));
        }
        return supportsGzip;
    }

    public String getKvpString() {
        return this.kvpString;
    }

    public void setKvpString(String kvpString) {
        this.kvpString = kvpString;
    }
}

