/*
 * Decompiled with CFR 0.152.
 */
package org.vfny.geoserver.util;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.logging.Logger;
import java.util.zip.GZIPInputStream;
import java.util.zip.Inflater;
import java.util.zip.InflaterInputStream;
import javax.servlet.http.HttpServletRequest;
import org.geoserver.config.GeoServer;
import org.geotools.util.logging.Logging;
import org.springframework.security.Authentication;
import org.springframework.security.context.SecurityContextHolder;
import org.springframework.security.providers.anonymous.AnonymousAuthenticationToken;

public final class Requests {
    static Logger LOGGER = Logging.getLogger((String)"org.vfny.geoserver");
    public static final String PROXY_PARAM = "PROXY_BASE_URL";

    public static String getBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url;
        String string = url = geoserver != null ? geoserver.getGlobal().getProxyBaseUrl() : null;
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? String.valueOf(httpServletRequest.getScheme()) + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getContextPath() + "/" : Requests.appendContextPath(url, httpServletRequest.getContextPath());
        }
        if (!url.endsWith("/")) {
            url = String.valueOf(url) + "/";
        }
        return url;
    }

    public static String getBaseJspUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        String url = geoserver.getGlobal().getProxyBaseUrl();
        if (geoserver != null && url != null) {
            url = Requests.appendContextPath(url, httpServletRequest.getRequestURI());
        }
        if (url == null || url.trim().length() == 0) {
            if (httpServletRequest != null) {
                url = httpServletRequest.getSession().getServletContext().getInitParameter(PROXY_PARAM);
            }
            url = url == null || url.trim().length() == 0 ? String.valueOf(httpServletRequest.getScheme()) + "://" + httpServletRequest.getServerName() + ":" + httpServletRequest.getServerPort() + httpServletRequest.getRequestURI() + "/" : Requests.appendContextPath(url, httpServletRequest.getRequestURI());
        }
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        return url;
    }

    public static String appendContextPath(String url, String contextPath) {
        if (url.endsWith("/")) {
            url = url.substring(0, url.length() - 1);
        }
        if (contextPath.startsWith("/")) {
            contextPath = contextPath.substring(1);
        }
        return String.valueOf(url) + "/" + contextPath;
    }

    public static String appendQueryString(String url, String queryString) {
        if (url.endsWith("?") || url.endsWith("&")) {
            return String.valueOf(url) + queryString;
        }
        if (url.indexOf(63) != -1) {
            return String.valueOf(url) + "&" + queryString;
        }
        return String.valueOf(url) + "?" + queryString;
    }

    public static String getSchemaBaseUrl(HttpServletRequest httpServletRequest, GeoServer geoserver) {
        return String.valueOf(Requests.getBaseUrl(httpServletRequest, geoserver)) + "schemas/";
    }

    public static boolean isLoggedIn(HttpServletRequest request) {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        return authentication != null && !(authentication instanceof AnonymousAuthenticationToken);
    }

    public static InputStream getInputStream(URL url) throws IOException {
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            conn.setRequestProperty("Accept-Encoding", "gzip, deflate");
        }
        conn.connect();
        if (conn instanceof HttpURLConnection) {
            String encoding = conn.getContentEncoding();
            if (encoding == null) {
                encoding = "";
            }
            if (encoding.equalsIgnoreCase("gzip")) {
                return new GZIPInputStream(conn.getInputStream());
            }
            if (encoding.equalsIgnoreCase("deflate")) {
                return new InflaterInputStream(conn.getInputStream(), new Inflater(true));
            }
            return conn.getInputStream();
        }
        return conn.getInputStream();
    }

    public static Map parseOptionParameter(String rawOptionString) throws IllegalArgumentException {
        HashMap<String, Object> map = new HashMap<String, Object>();
        if (rawOptionString == null) {
            return map;
        }
        StringTokenizer semiColonSplitter = new StringTokenizer(rawOptionString, ";");
        while (semiColonSplitter.hasMoreElements()) {
            String curKVP = semiColonSplitter.nextToken();
            int cloc = curKVP.indexOf(":");
            if (cloc <= 0) {
                throw new IllegalArgumentException("Key-value-pair: '" + curKVP + "' isn't properly formed.  It must be of the form 'Key:Value1,Value2...'");
            }
            String key = curKVP.substring(0, cloc);
            String values = curKVP.substring(cloc + 1, curKVP.length());
            if (values.indexOf(",") != -1) {
                ArrayList<String> valueList = new ArrayList<String>();
                StringTokenizer commaSplitter = new StringTokenizer(values, ",");
                while (commaSplitter.hasMoreElements()) {
                    valueList.add(commaSplitter.nextToken());
                }
                map.put(key, valueList);
                continue;
            }
            map.put(key, values);
        }
        return map;
    }
}

