/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import org.geoserver.catalog.CascadeRemovalReporter;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogBuilder;
import org.geoserver.catalog.CatalogVisitor;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerGroupInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.GeoServerTestSupport;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CascadeRemovalReporterTest
extends GeoServerTestSupport {
    static final String LAKES_GROUP = "lakesGroup";
    CascadeRemovalReporter visitor;
    Catalog catalog;

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.catalog = this.getCatalog();
        this.visitor = new CascadeRemovalReporter(this.catalog);
        Catalog catalog = this.getCatalog();
        String lakes = MockData.LAKES.getLocalPart();
        String forests = MockData.FORESTS.getLocalPart();
        String bridges = MockData.BRIDGES.getLocalPart();
        this.setNativeBox(catalog, lakes);
        this.setNativeBox(catalog, forests);
        this.setNativeBox(catalog, bridges);
        LayerGroupInfo lg = catalog.getFactory().createLayerGroup();
        lg.setName(LAKES_GROUP);
        lg.getLayers().add(catalog.getLayerByName(lakes));
        lg.getStyles().add(catalog.getStyleByName(lakes));
        lg.getLayers().add(catalog.getLayerByName(forests));
        lg.getStyles().add(catalog.getStyleByName(forests));
        lg.getLayers().add(catalog.getLayerByName(bridges));
        lg.getStyles().add(catalog.getStyleByName(bridges));
        CatalogBuilder builder = new CatalogBuilder(catalog);
        builder.calculateLayerGroupBounds(lg);
        catalog.add(lg);
    }

    public void setNativeBox(Catalog catalog, String name) throws Exception {
        FeatureTypeInfo fti = catalog.getFeatureTypeByName(name);
        fti.setNativeBoundingBox(fti.getFeatureSource(null, null).getBounds());
        fti.setLatLonBoundingBox(new ReferencedEnvelope((Envelope)fti.getNativeBoundingBox(), (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84));
        catalog.save((ResourceInfo)fti);
    }

    public void testCascadeLayer() {
        String name = this.getLayerId(MockData.LAKES);
        LayerInfo layer = this.catalog.getLayerByName(name);
        CascadeRemovalReporterTest.assertNotNull((Object)layer);
        layer.accept((CatalogVisitor)this.visitor);
        CascadeRemovalReporterTest.assertEquals((int)3, (int)this.visitor.getObjects(null, new CascadeRemovalReporter.ModificationType[0]).size());
        CascadeRemovalReporterTest.assertEquals((Object)this.catalog.getLayerByName(name), this.visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        CascadeRemovalReporterTest.assertEquals((Object)this.catalog.getResourceByName(name, ResourceInfo.class), this.visitor.getObjects(ResourceInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        LayerGroupInfo group = this.catalog.getLayerGroupByName(LAKES_GROUP);
        CascadeRemovalReporterTest.assertEquals((String)group.getId(), (String)((LayerGroupInfo)this.visitor.getObjects(LayerGroupInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.GROUP_CHANGED}).get(0)).getId());
    }

    public void testCascadeStore() {
        String citeStore = MockData.CITE_PREFIX;
        StoreInfo store = this.catalog.getStoreByName(citeStore, StoreInfo.class);
        String buildings = this.getLayerId(MockData.BUILDINGS);
        String lakes = this.getLayerId(MockData.LAKES);
        LayerInfo bl = this.catalog.getLayerByName(buildings);
        ResourceInfo br = this.catalog.getResourceByName(buildings, ResourceInfo.class);
        LayerInfo ll = this.catalog.getLayerByName(lakes);
        ResourceInfo lr = this.catalog.getResourceByName(lakes, ResourceInfo.class);
        store.accept((CatalogVisitor)this.visitor);
        CascadeRemovalReporterTest.assertEquals((Object)store, this.visitor.getObjects(StoreInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0));
        List layers = this.visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        CascadeRemovalReporterTest.assertTrue((boolean)layers.contains(bl));
        CascadeRemovalReporterTest.assertTrue((boolean)layers.contains(ll));
        List resources = this.visitor.getObjects(ResourceInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE});
        CascadeRemovalReporterTest.assertTrue((boolean)resources.contains(br));
        CascadeRemovalReporterTest.assertTrue((boolean)resources.contains(lr));
    }

    public void testCascadeWorkspace() {
        WorkspaceInfo ws = this.catalog.getWorkspaceByName(MockData.CITE_PREFIX);
        CascadeRemovalReporterTest.assertNotNull((Object)ws);
        List stores = this.getCatalog().getStoresByWorkspace(ws, StoreInfo.class);
        ws.accept((CatalogVisitor)this.visitor);
        CascadeRemovalReporterTest.assertTrue((boolean)stores.containsAll(this.visitor.getObjects(StoreInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE})));
    }

    public void testCascadeStyle() {
        String styleName = MockData.LAKES.getLocalPart();
        String layerName = this.getLayerId(MockData.LAKES);
        StyleInfo style = this.catalog.getStyleByName(styleName);
        CascadeRemovalReporterTest.assertNotNull((Object)style);
        LayerInfo buildings = this.catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        buildings.getStyles().add(style);
        this.catalog.save(buildings);
        buildings = this.catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS));
        CascadeRemovalReporterTest.assertTrue((boolean)buildings.getStyles().contains(style));
        style.accept((CatalogVisitor)this.visitor);
        CascadeRemovalReporterTest.assertEquals((String)style.getId(), (String)((StyleInfo)this.visitor.getObjects(StyleInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.DELETE}).get(0)).getId());
        String lakesId = this.catalog.getLayerByName(layerName).getId();
        CascadeRemovalReporterTest.assertEquals((String)lakesId, (String)((LayerInfo)this.visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.STYLE_RESET}).get(0)).getId());
        String buildingsId = this.catalog.getLayerByName(this.getLayerId(MockData.BUILDINGS)).getId();
        CascadeRemovalReporterTest.assertEquals((String)buildingsId, (String)((LayerInfo)this.visitor.getObjects(LayerInfo.class, new CascadeRemovalReporter.ModificationType[]{CascadeRemovalReporter.ModificationType.EXTRA_STYLE_REMOVED}).get(0)).getId());
    }
}

