/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.catalog.impl;

import java.io.Serializable;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import junit.framework.TestCase;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CatalogException;
import org.geoserver.catalog.CatalogFactory;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.Keyword;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.MetadataMap;
import org.geoserver.catalog.NamespaceInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.StyleInfo;
import org.geoserver.catalog.WMSLayerInfo;
import org.geoserver.catalog.WMSStoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.catalog.event.CatalogAddEvent;
import org.geoserver.catalog.event.CatalogListener;
import org.geoserver.catalog.event.CatalogModifyEvent;
import org.geoserver.catalog.event.CatalogPostModifyEvent;
import org.geoserver.catalog.event.CatalogRemoveEvent;
import org.geoserver.catalog.impl.CatalogImpl;
import org.geoserver.catalog.impl.RunnerBase;

public class CatalogImplTest
extends TestCase {
    protected Catalog catalog;
    protected WorkspaceInfo ws;
    protected NamespaceInfo ns;
    protected DataStoreInfo ds;
    protected CoverageStoreInfo cs;
    protected WMSStoreInfo wms;
    protected FeatureTypeInfo ft;
    protected CoverageInfo cv;
    protected WMSLayerInfo wl;
    protected LayerInfo l;
    protected StyleInfo s;
    private static final int GET_LAYER_BY_ID_WITH_CONCURRENT_ADD_TEST_COUNT = 500;
    private static final int GET_LAYER_BY_ID_WITH_CONCURRENT_ADD_THREAD_COUNT = 10;

    protected void setUp() throws Exception {
        this.catalog = this.createCatalog();
        CatalogFactory factory = this.catalog.getFactory();
        this.ns = factory.createNamespace();
        this.ns.setPrefix("nsPrefix");
        this.ns.setURI("nsURI");
        this.ws = factory.createWorkspace();
        this.ws.setName("wsName");
        this.ds = factory.createDataStore();
        this.ds.setEnabled(true);
        this.ds.setName("dsName");
        this.ds.setDescription("dsDescription");
        this.ds.setWorkspace(this.ws);
        this.ft = factory.createFeatureType();
        this.ft.setEnabled(true);
        this.ft.setName("ftName");
        this.ft.setAbstract("ftAbstract");
        this.ft.setDescription("ftDescription");
        this.ft.setStore((StoreInfo)this.ds);
        this.ft.setNamespace(this.ns);
        this.cs = factory.createCoverageStore();
        this.cs.setName("csName");
        this.cs.setType("fakeCoverageType");
        this.cs.setURL("file://fake");
        this.cv = factory.createCoverage();
        this.cv.setName("cvName");
        this.cv.setStore((StoreInfo)this.cs);
        this.wms = factory.createWebMapServer();
        this.wms.setName("wmsName");
        this.wms.setType("WMS");
        this.wms.setCapabilitiesURL("http://fake.url");
        this.wms.setWorkspace(this.ws);
        this.wl = factory.createWMSLayer();
        this.wl.setEnabled(true);
        this.wl.setName("wmsLayer");
        this.wl.setStore((StoreInfo)this.wms);
        this.wl.setNamespace(this.ns);
        this.s = factory.createStyle();
        this.s.setName("styleName");
        this.s.setFilename("styleFilename");
        this.l = factory.createLayer();
        this.l.setEnabled(true);
        this.l.setResource((ResourceInfo)this.ft);
        this.l.setDefaultStyle(this.s);
    }

    protected Catalog createCatalog() {
        return new CatalogImpl();
    }

    protected void addWorkspace() {
        this.catalog.add(this.ws);
    }

    protected void addNamespace() {
        this.catalog.add(this.ns);
    }

    protected void addDataStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.ds);
    }

    protected void addCoverageStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.cs);
    }

    protected void addWMSStore() {
        this.addWorkspace();
        this.catalog.add((StoreInfo)this.wms);
    }

    protected void addFeatureType() {
        this.addDataStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.ft);
    }

    protected void addCoverage() {
        this.addCoverageStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.cv);
    }

    protected void addWMSLayer() {
        this.addWMSStore();
        this.addNamespace();
        this.catalog.add((ResourceInfo)this.wl);
    }

    protected void addStyle() {
        this.catalog.add(this.s);
    }

    protected void addLayer() {
        this.addFeatureType();
        this.addStyle();
        this.catalog.add(this.l);
    }

    public void testAddNamespace() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getNamespaces().isEmpty());
        this.catalog.add(this.ns);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getNamespaces().size());
        NamespaceInfo ns2 = this.catalog.getFactory().createNamespace();
        try {
            this.catalog.add(ns2);
            CatalogImplTest.fail((String)"adding without a prefix should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setPrefix("ns2Prefix");
        try {
            this.catalog.add(ns2);
            CatalogImplTest.fail((String)"adding without a uri should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setURI("bad uri");
        try {
            this.catalog.add(ns2);
            CatalogImplTest.fail((String)"adding an invalid uri should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setURI("ns2URI");
        try {
            this.catalog.getNamespaces().add(ns2);
            CatalogImplTest.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.add(ns2);
    }

    public void testRemoveNamespace() {
        this.catalog.add(this.ns);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getNamespaces().size());
        try {
            CatalogImplTest.assertFalse((boolean)this.catalog.getNamespaces().remove(this.ns));
            CatalogImplTest.fail((String)"removing directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove(this.ns);
        CatalogImplTest.assertTrue((boolean)this.catalog.getNamespaces().isEmpty());
    }

    public void testGetNamespaceById() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespace(this.ns.getId());
        CatalogImplTest.assertNotNull((Object)ns2);
        CatalogImplTest.assertFalse((this.ns == ns2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ns, (Object)ns2);
    }

    public void testGetNamespaceByPrefix() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespaceByPrefix(this.ns.getPrefix());
        CatalogImplTest.assertNotNull((Object)ns2);
        CatalogImplTest.assertFalse((this.ns == ns2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ns, (Object)ns2);
        NamespaceInfo ns3 = this.catalog.getNamespaceByPrefix(null);
        CatalogImplTest.assertNotNull((Object)ns3);
        CatalogImplTest.assertFalse((this.ns == ns3 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ns, (Object)ns3);
        NamespaceInfo ns4 = this.catalog.getNamespaceByPrefix("default");
        CatalogImplTest.assertNotNull((Object)ns4);
        CatalogImplTest.assertFalse((this.ns == ns4 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ns, (Object)ns4);
    }

    public void testGetNamespaceByURI() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespaceByURI(this.ns.getURI());
        CatalogImplTest.assertNotNull((Object)ns2);
        CatalogImplTest.assertFalse((this.ns == ns2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ns, (Object)ns2);
    }

    public void testModifyNamespace() {
        this.catalog.add(this.ns);
        NamespaceInfo ns2 = this.catalog.getNamespaceByPrefix(this.ns.getPrefix());
        ns2.setPrefix(null);
        ns2.setURI(null);
        try {
            this.catalog.save(ns2);
            CatalogImplTest.fail((String)"setting prefix to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setPrefix("ns2Prefix");
        try {
            this.catalog.save(ns2);
            CatalogImplTest.fail((String)"setting uri to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ns2.setURI("ns2URI");
        NamespaceInfo ns3 = this.catalog.getNamespaceByPrefix(this.ns.getPrefix());
        CatalogImplTest.assertEquals((String)"nsPrefix", (String)ns3.getPrefix());
        CatalogImplTest.assertEquals((String)"nsURI", (String)ns3.getURI());
        this.catalog.save(ns2);
        ns3 = this.catalog.getNamespaceByPrefix("ns2Prefix");
        CatalogImplTest.assertEquals((Object)ns2, (Object)ns3);
        CatalogImplTest.assertEquals((String)"ns2Prefix", (String)ns3.getPrefix());
        CatalogImplTest.assertEquals((String)"ns2URI", (String)ns3.getURI());
    }

    public void testNamespaceEvents() {
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        NamespaceInfo ns = this.catalog.getFactory().createNamespace();
        ns.setPrefix("ns2Prefix");
        ns.setURI("ns2URI");
        CatalogImplTest.assertTrue((boolean)l.added.isEmpty());
        CatalogImplTest.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.add(ns);
        CatalogImplTest.assertEquals((int)1, (int)l.added.size());
        CatalogImplTest.assertEquals((Object)ns, (Object)l.added.get(0).getSource());
        CatalogImplTest.assertEquals((int)1, (int)l.modified.size());
        CatalogImplTest.assertEquals((Object)this.catalog, (Object)l.modified.get(0).getSource());
        CatalogImplTest.assertEquals((String)"defaultNamespace", (String)((String)l.modified.get(0).getPropertyNames().get(0)));
        ns = this.catalog.getNamespaceByPrefix("ns2Prefix");
        ns.setURI("changed");
        this.catalog.save(ns);
        CatalogImplTest.assertEquals((int)2, (int)l.modified.size());
        CatalogImplTest.assertEquals((int)1, (int)l.modified.get(1).getPropertyNames().size());
        CatalogImplTest.assertTrue((boolean)((String)l.modified.get(1).getPropertyNames().get(0)).equalsIgnoreCase("uri"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(1).getOldValues().contains("ns2URI"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(1).getNewValues().contains("changed"));
        CatalogImplTest.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove(ns);
        CatalogImplTest.assertEquals((int)1, (int)l.removed.size());
        CatalogImplTest.assertEquals((Object)ns, (Object)l.removed.get(0).getSource());
    }

    public void testAddWorkspace() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getWorkspaces().isEmpty());
        this.catalog.add(this.ws);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getWorkspaces().size());
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        try {
            this.catalog.getWorkspaces().add(ws2);
            CatalogImplTest.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.catalog.add(ws2);
            CatalogImplTest.fail((String)"addign without a name should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ws2.setName("ws2");
        this.catalog.add(ws2);
    }

    public void testRemoveWorkspace() {
        this.catalog.add(this.ws);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getWorkspaces().size());
        try {
            CatalogImplTest.assertFalse((boolean)this.catalog.getWorkspaces().remove(this.ws));
            CatalogImplTest.fail((String)"removing directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove(this.ws);
        CatalogImplTest.assertTrue((boolean)this.catalog.getWorkspaces().isEmpty());
    }

    public void testAutoSetDefaultWorkspace() {
        this.catalog.add(this.ws);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getWorkspaces().size());
        CatalogImplTest.assertEquals((Object)this.ws, (Object)this.catalog.getDefaultWorkspace());
        CatalogImplTest.assertNull((Object)this.catalog.getDefaultNamespace());
    }

    public void testRemoveDefaultWorkspace() {
        this.catalog.add(this.ws);
        CatalogImplTest.assertNotNull((Object)this.catalog.getDefaultWorkspace());
        this.catalog.remove(this.ws);
        CatalogImplTest.assertNull((Object)this.catalog.getDefaultWorkspace());
    }

    public void testAutoCascadeDefaultWorksapce() {
        CatalogFactory factory = this.catalog.getFactory();
        WorkspaceInfo ws1 = factory.createWorkspace();
        ws1.setName("ws1Name");
        WorkspaceInfo ws2 = factory.createWorkspace();
        ws2.setName("ws2Name");
        this.catalog.add(ws1);
        this.catalog.add(ws2);
        CatalogImplTest.assertEquals((Object)ws1, (Object)this.catalog.getDefaultWorkspace());
        this.catalog.remove(ws1);
        CatalogImplTest.assertEquals((Object)ws2, (Object)this.catalog.getDefaultWorkspace());
    }

    public void testAutoSetDefaultNamespace() {
        this.catalog.add(this.ns);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getNamespaces().size());
        CatalogImplTest.assertEquals((Object)this.ns, (Object)this.catalog.getDefaultNamespace());
    }

    public void testRemoveDefaultNamespace() {
        this.catalog.add(this.ns);
        this.catalog.remove(this.ns);
        CatalogImplTest.assertNull((Object)this.catalog.getDefaultNamespace());
    }

    public void testAutoCascadeDefaultNamespace() {
        CatalogFactory factory = this.catalog.getFactory();
        NamespaceInfo ns1 = factory.createNamespace();
        ns1.setPrefix("1");
        ns1.setURI("http://www.geoserver.org/1");
        NamespaceInfo ns2 = factory.createNamespace();
        ns2.setPrefix("2");
        ns2.setURI("http://www.geoserver.org/2");
        this.catalog.add(ns1);
        this.catalog.add(ns2);
        CatalogImplTest.assertEquals((Object)ns1, (Object)this.catalog.getDefaultNamespace());
        this.catalog.remove(ns1);
        CatalogImplTest.assertEquals((Object)ns2, (Object)this.catalog.getDefaultNamespace());
    }

    public void testAutoSetDefaultStore() {
        this.catalog.add(this.ws);
        this.catalog.add((StoreInfo)this.ds);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getDataStores().size());
        CatalogImplTest.assertEquals((Object)this.ds, (Object)this.catalog.getDefaultDataStore(this.ws));
    }

    public void testRemoveDefaultStore() {
        this.catalog.add(this.ws);
        this.catalog.add((StoreInfo)this.ds);
        this.catalog.remove((StoreInfo)this.ds);
        CatalogImplTest.assertNull((Object)this.catalog.getDefaultDataStore(this.ws));
    }

    public void testGetWorkspaceById() {
        this.catalog.add(this.ws);
        WorkspaceInfo ws2 = this.catalog.getWorkspace(this.ws.getId());
        CatalogImplTest.assertNotNull((Object)ws2);
        CatalogImplTest.assertFalse((this.ws == ws2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ws, (Object)ws2);
    }

    public void testGetWorkspaceByName() {
        this.catalog.add(this.ws);
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName(this.ws.getName());
        CatalogImplTest.assertNotNull((Object)ws2);
        CatalogImplTest.assertFalse((this.ws == ws2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ws, (Object)ws2);
        WorkspaceInfo ws3 = this.catalog.getWorkspaceByName(null);
        CatalogImplTest.assertNotNull((Object)ws3);
        CatalogImplTest.assertFalse((this.ws == ws3 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ws, (Object)ws3);
        WorkspaceInfo ws4 = this.catalog.getWorkspaceByName("default");
        CatalogImplTest.assertNotNull((Object)ws4);
        CatalogImplTest.assertFalse((this.ws == ws4 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ws, (Object)ws4);
    }

    public void testModifyWorkspace() {
        this.catalog.add(this.ws);
        WorkspaceInfo ws2 = this.catalog.getWorkspaceByName(this.ws.getName());
        ws2.setName(null);
        try {
            this.catalog.save(ws2);
            CatalogImplTest.fail((String)"setting name to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ws2.setName("ws2");
        WorkspaceInfo ws3 = this.catalog.getWorkspaceByName(this.ws.getName());
        CatalogImplTest.assertEquals((String)"wsName", (String)ws3.getName());
        this.catalog.save(ws2);
        ws3 = this.catalog.getWorkspaceByName(ws2.getName());
        CatalogImplTest.assertEquals((Object)ws2, (Object)ws3);
        CatalogImplTest.assertEquals((String)"ws2", (String)ws3.getName());
    }

    public void testWorkspaceEvents() {
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
        ws.setName("ws2");
        CatalogImplTest.assertTrue((boolean)l.added.isEmpty());
        CatalogImplTest.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.add(ws);
        CatalogImplTest.assertEquals((int)1, (int)l.added.size());
        CatalogImplTest.assertEquals((Object)ws, (Object)l.added.get(0).getSource());
        CatalogImplTest.assertEquals((Object)this.catalog, (Object)l.modified.get(0).getSource());
        CatalogImplTest.assertEquals((String)"defaultWorkspace", (String)((String)l.modified.get(0).getPropertyNames().get(0)));
        ws = this.catalog.getWorkspaceByName("ws2");
        ws.setName("changed");
        this.catalog.save(ws);
        CatalogImplTest.assertEquals((int)2, (int)l.modified.size());
        CatalogImplTest.assertTrue((boolean)l.modified.get(1).getPropertyNames().contains("name"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(1).getOldValues().contains("ws2"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(1).getNewValues().contains("changed"));
        CatalogImplTest.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove(ws);
        CatalogImplTest.assertEquals((int)1, (int)l.removed.size());
        CatalogImplTest.assertEquals((Object)ws, (Object)l.removed.get(0).getSource());
    }

    public void testAddDataStore() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getDataStores().isEmpty());
        this.ds.setWorkspace(null);
        try {
            this.catalog.add((StoreInfo)this.ds);
            CatalogImplTest.fail((String)"adding with no workspace should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.ds.setWorkspace(this.ws);
        this.catalog.add(this.ws);
        this.catalog.add((StoreInfo)this.ds);
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getDataStores().size());
        DataStoreInfo retrieved = this.catalog.getDataStore(this.ds.getId());
        DataStoreInfo ds2 = this.catalog.getFactory().createDataStore();
        try {
            this.catalog.add((StoreInfo)ds2);
            CatalogImplTest.fail((String)"adding without a name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ds2.setName("ds2Name");
        try {
            this.catalog.getDataStores().add(ds2);
            CatalogImplTest.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ds2.setWorkspace(this.ws);
        this.catalog.add((StoreInfo)ds2);
        CatalogImplTest.assertEquals((int)2, (int)this.catalog.getDataStores().size());
    }

    public void testAddDataStoreDefaultWorkspace() {
        this.catalog.setDefaultWorkspace(this.ws);
        DataStoreInfo ds2 = this.catalog.getFactory().createDataStore();
        ds2.setName("ds2Name");
        this.catalog.add((StoreInfo)ds2);
        CatalogImplTest.assertEquals((Object)this.ws, (Object)ds2.getWorkspace());
    }

    public void testRemoveDataStore() {
        this.addDataStore();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getDataStores().size());
        try {
            CatalogImplTest.assertFalse((boolean)this.catalog.getDataStores().remove(this.ds));
            CatalogImplTest.fail((String)"removing directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove((StoreInfo)this.ds);
        CatalogImplTest.assertTrue((boolean)this.catalog.getDataStores().isEmpty());
    }

    public void testGetDataStoreById() {
        this.addDataStore();
        DataStoreInfo ds2 = this.catalog.getDataStore(this.ds.getId());
        CatalogImplTest.assertNotNull((Object)ds2);
        CatalogImplTest.assertFalse((this.ds == ds2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ds, (Object)ds2);
    }

    public void testGetDataStoreByName() {
        this.addDataStore();
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        CatalogImplTest.assertNotNull((Object)ds2);
        CatalogImplTest.assertFalse((this.ds == ds2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ds, (Object)ds2);
        DataStoreInfo ds3 = this.catalog.getDataStoreByName(this.ws, null);
        CatalogImplTest.assertNotNull((Object)ds3);
        CatalogImplTest.assertFalse((this.ds == ds3 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ds, (Object)ds3);
        DataStoreInfo ds4 = this.catalog.getDataStoreByName(this.ws, "default");
        CatalogImplTest.assertNotNull((Object)ds4);
        CatalogImplTest.assertFalse((this.ds == ds4 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ds, (Object)ds4);
        DataStoreInfo ds5 = this.catalog.getDataStoreByName("default", "default");
        CatalogImplTest.assertNotNull((Object)ds5);
        CatalogImplTest.assertFalse((this.ds == ds5 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ds, (Object)ds5);
    }

    public void testModifyDataStore() {
        this.addDataStore();
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        ds2.setName("dsName2");
        ds2.setDescription("dsDescription2");
        DataStoreInfo ds3 = this.catalog.getDataStoreByName(this.ds.getName());
        CatalogImplTest.assertEquals((String)"dsName", (String)ds3.getName());
        CatalogImplTest.assertEquals((String)"dsDescription", (String)ds3.getDescription());
        this.catalog.save((StoreInfo)ds2);
        ds3 = this.catalog.getDataStoreByName("dsName2");
        CatalogImplTest.assertEquals((Object)ds2, (Object)ds3);
        CatalogImplTest.assertEquals((String)"dsName2", (String)ds3.getName());
        CatalogImplTest.assertEquals((String)"dsDescription2", (String)ds3.getDescription());
    }

    public void testChangeDataStoreWorkspace() throws Exception {
        this.addDataStore();
        WorkspaceInfo ws2 = this.catalog.getFactory().createWorkspace();
        ws2.setName("newWorkspace");
        this.catalog.add(ws2);
        ws2 = this.catalog.getWorkspaceByName(ws2.getName());
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        ds2.setWorkspace(ws2);
        this.catalog.save((StoreInfo)ds2);
        CatalogImplTest.assertNull((Object)this.catalog.getDataStoreByName(this.ws, ds2.getName()));
        CatalogImplTest.assertNotNull((Object)this.catalog.getDataStoreByName(ws2, ds2.getName()));
    }

    public void testDataStoreEvents() {
        this.addWorkspace();
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        CatalogImplTest.assertEquals((int)0, (int)l.added.size());
        this.catalog.add((StoreInfo)this.ds);
        CatalogImplTest.assertEquals((int)1, (int)l.added.size());
        CatalogImplTest.assertEquals((Object)this.ds, (Object)l.added.get(0).getSource());
        CatalogImplTest.assertEquals((int)1, (int)l.modified.size());
        CatalogImplTest.assertEquals((Object)this.catalog, (Object)l.modified.get(0).getSource());
        DataStoreInfo ds2 = this.catalog.getDataStoreByName(this.ds.getName());
        ds2.setDescription("changed");
        CatalogImplTest.assertEquals((int)1, (int)l.modified.size());
        this.catalog.save((StoreInfo)ds2);
        CatalogImplTest.assertEquals((int)2, (int)l.modified.size());
        CatalogModifyEvent me = l.modified.get(1);
        CatalogImplTest.assertEquals((Object)ds2, (Object)me.getSource());
        CatalogImplTest.assertEquals((int)1, (int)me.getPropertyNames().size());
        CatalogImplTest.assertEquals((String)"description", (String)((String)me.getPropertyNames().get(0)));
        CatalogImplTest.assertEquals((int)1, (int)me.getOldValues().size());
        CatalogImplTest.assertEquals((int)1, (int)me.getNewValues().size());
        CatalogImplTest.assertEquals((Object)"dsDescription", me.getOldValues().get(0));
        CatalogImplTest.assertEquals((Object)"changed", me.getNewValues().get(0));
        CatalogImplTest.assertEquals((int)0, (int)l.removed.size());
        this.catalog.remove((StoreInfo)this.ds);
        CatalogImplTest.assertEquals((int)1, (int)l.removed.size());
        CatalogImplTest.assertEquals((Object)this.ds, (Object)l.removed.get(0).getSource());
    }

    public void testAddFeatureType() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getFeatureTypes().isEmpty());
        this.addFeatureType();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getFeatureTypes().size());
        FeatureTypeInfo ft2 = this.catalog.getFactory().createFeatureType();
        try {
            this.catalog.add((ResourceInfo)ft2);
            CatalogImplTest.fail((String)"adding with no name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ft2.setName("ft2Name");
        try {
            this.catalog.add((ResourceInfo)ft2);
            CatalogImplTest.fail((String)"adding with no store should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        ft2.setStore((StoreInfo)this.ds);
        ft2.getKeywords().add(new Keyword("keyword"));
        this.catalog.add((ResourceInfo)ft2);
        FeatureTypeInfo ft3 = this.catalog.getFactory().createFeatureType();
        ft3.setName("ft3Name");
        try {
            this.catalog.getFeatureTypes().add(ft3);
            CatalogImplTest.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAddCoverage() {
        CatalogImplTest.assertNotNull((Object)this.catalog.getCoverages());
        CatalogImplTest.assertTrue((boolean)this.catalog.getCoverages().isEmpty());
        this.addCoverage();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getCoverages().size());
        CoverageInfo cv2 = this.catalog.getFactory().createCoverage();
        try {
            this.catalog.add((ResourceInfo)cv2);
            CatalogImplTest.fail((String)"adding with no name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cv2.setName("cv2Name");
        try {
            this.catalog.add((ResourceInfo)cv2);
            CatalogImplTest.fail((String)"adding with no store should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        cv2.setStore((StoreInfo)this.cs);
        this.catalog.add((ResourceInfo)cv2);
        CatalogImplTest.assertEquals((int)2, (int)this.catalog.getCoverages().size());
        CoverageInfo fromCatalog = this.catalog.getCoverageByName("cv2Name");
        CatalogImplTest.assertNotNull((Object)fromCatalog);
        CatalogImplTest.assertNotNull((Object)fromCatalog.getParameters());
        CoverageInfo cv3 = this.catalog.getFactory().createCoverage();
        cv3.setName("cv3Name");
        try {
            this.catalog.getCoverages().add(cv3);
            CatalogImplTest.fail((String)"adding directly should throw an exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void testAddWMSLayer() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getResources(WMSLayerInfo.class).isEmpty());
        this.addWMSLayer();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getResources(WMSLayerInfo.class).size());
    }

    public void testRemoveFeatureType() {
        this.addFeatureType();
        CatalogImplTest.assertFalse((boolean)this.catalog.getFeatureTypes().isEmpty());
        try {
            this.catalog.getFeatureTypes().remove(this.ft);
            CatalogImplTest.fail((String)"removing directly should cause exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.remove((ResourceInfo)this.ft);
        CatalogImplTest.assertTrue((boolean)this.catalog.getFeatureTypes().isEmpty());
    }

    public void testRemoveWMSLayer() {
        this.addWMSLayer();
        CatalogImplTest.assertFalse((boolean)this.catalog.getResources(WMSLayerInfo.class).isEmpty());
        this.catalog.remove((ResourceInfo)this.wl);
        CatalogImplTest.assertTrue((boolean)this.catalog.getResources(WMSLayerInfo.class).isEmpty());
    }

    public void testGetFeatureTypeById() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureType(this.ft.getId());
        CatalogImplTest.assertNotNull((Object)ft2);
        CatalogImplTest.assertFalse((this.ft == ft2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ft, (Object)ft2);
    }

    public void testGetFeatureTypeByName() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureTypeByName(this.ft.getName());
        CatalogImplTest.assertNotNull((Object)ft2);
        CatalogImplTest.assertFalse((this.ft == ft2 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)this.ft, (Object)ft2);
        NamespaceInfo ns2 = this.catalog.getFactory().createNamespace();
        ns2.setPrefix("ns2Prefix");
        ns2.setURI("ns2URI");
        this.catalog.add(ns2);
        FeatureTypeInfo ft3 = this.catalog.getFactory().createFeatureType();
        ft3.setName("ft3Name");
        ft3.setStore((StoreInfo)this.ds);
        ft3.setNamespace(ns2);
        this.catalog.add((ResourceInfo)ft3);
        FeatureTypeInfo ft4 = this.catalog.getFeatureTypeByName(ns2.getPrefix(), ft3.getName());
        CatalogImplTest.assertNotNull((Object)ft4);
        CatalogImplTest.assertFalse((ft4 == ft3 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)ft3, (Object)ft4);
        ft4 = this.catalog.getFeatureTypeByName(ns2.getURI(), ft3.getName());
        CatalogImplTest.assertNotNull((Object)ft4);
        CatalogImplTest.assertFalse((ft4 == ft3 ? 1 : 0) != 0);
        CatalogImplTest.assertEquals((Object)ft3, (Object)ft4);
    }

    public void testGetFeatureTypesByStore() {
        this.catalog.add(this.ns);
        this.catalog.add(this.ws);
        this.catalog.setDefaultNamespace(this.ns);
        this.catalog.setDefaultWorkspace(this.ws);
        DataStoreInfo ds1 = this.catalog.getFactory().createDataStore();
        ds1.setName("ds1");
        this.catalog.add((StoreInfo)ds1);
        FeatureTypeInfo ft1 = this.catalog.getFactory().createFeatureType();
        ft1.setName("ft1");
        ft1.setStore((StoreInfo)ds1);
        this.catalog.add((ResourceInfo)ft1);
        FeatureTypeInfo ft2 = this.catalog.getFactory().createFeatureType();
        ft2.setName("ft2");
        ft2.setStore((StoreInfo)ds1);
        this.catalog.add((ResourceInfo)ft2);
        DataStoreInfo ds2 = this.catalog.getFactory().createDataStore();
        ds2.setName("ds2");
        this.catalog.add((StoreInfo)ds2);
        FeatureTypeInfo ft3 = this.catalog.getFactory().createFeatureType();
        ft3.setName("ft3");
        ft3.setStore((StoreInfo)ds2);
        this.catalog.add((ResourceInfo)ft3);
        List ft = this.catalog.getFeatureTypesByStore(ds1);
        CatalogImplTest.assertEquals((int)2, (int)ft.size());
        ft = this.catalog.getFeatureTypesByStore(ds2);
        CatalogImplTest.assertEquals((int)1, (int)ft.size());
        List r = this.catalog.getResourcesByStore((StoreInfo)ds1, ResourceInfo.class);
        CatalogImplTest.assertEquals((int)2, (int)r.size());
        CatalogImplTest.assertEquals((Object)ft1, r.get(0));
        CatalogImplTest.assertEquals((Object)ft2, r.get(1));
    }

    public void testModifyFeatureType() {
        this.addFeatureType();
        FeatureTypeInfo ft2 = this.catalog.getFeatureTypeByName(this.ft.getName());
        ft2.setDescription("ft2Description");
        ft2.getKeywords().add(new Keyword("ft2"));
        FeatureTypeInfo ft3 = this.catalog.getFeatureTypeByName(this.ft.getName());
        CatalogImplTest.assertEquals((String)"ftName", (String)ft3.getName());
        CatalogImplTest.assertEquals((String)"ftDescription", (String)ft3.getDescription());
        CatalogImplTest.assertTrue((boolean)ft3.getKeywords().isEmpty());
        this.catalog.save((ResourceInfo)ft2);
        ft3 = this.catalog.getFeatureTypeByName(this.ft.getName());
        CatalogImplTest.assertEquals((Object)ft2, (Object)ft3);
        CatalogImplTest.assertEquals((String)"ft2Description", (String)ft3.getDescription());
        CatalogImplTest.assertEquals((int)1, (int)ft3.getKeywords().size());
    }

    public void testFeatureTypeEvents() {
        this.addNamespace();
        this.addDataStore();
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setName("ftName");
        ft.setDescription("ftDescription");
        ft.setStore((StoreInfo)this.ds);
        CatalogImplTest.assertTrue((boolean)l.added.isEmpty());
        this.catalog.add((ResourceInfo)ft);
        CatalogImplTest.assertEquals((int)1, (int)l.added.size());
        CatalogImplTest.assertEquals((Object)ft, (Object)l.added.get(0).getSource());
        ft = this.catalog.getFeatureTypeByName("ftName");
        ft.setDescription("changed");
        CatalogImplTest.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.save((ResourceInfo)ft);
        CatalogImplTest.assertEquals((int)1, (int)l.modified.size());
        CatalogImplTest.assertEquals((Object)ft, (Object)l.modified.get(0).getSource());
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getPropertyNames().contains("description"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getOldValues().contains("ftDescription"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getNewValues().contains("changed"));
        CatalogImplTest.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove((ResourceInfo)ft);
        CatalogImplTest.assertEquals((int)1, (int)l.removed.size());
        CatalogImplTest.assertEquals((Object)ft, (Object)l.removed.get(0).getSource());
    }

    public void testModifyMetadata() {
        this.addNamespace();
        this.addDataStore();
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setName("ftName");
        ft.setDescription("ftDescription");
        ft.setStore((StoreInfo)this.ds);
        CatalogImplTest.assertTrue((boolean)l.added.isEmpty());
        this.catalog.add((ResourceInfo)ft);
        CatalogImplTest.assertEquals((int)1, (int)l.added.size());
        CatalogImplTest.assertEquals((Object)ft, (Object)l.added.get(0).getSource());
        ft = this.catalog.getFeatureTypeByName("ftName");
        ft.getMetadata().put("newValue", (Serializable)((Object)"abcd"));
        MetadataMap newMetadata = new MetadataMap((Map)ft.getMetadata());
        this.catalog.save((ResourceInfo)ft);
        CatalogImplTest.assertEquals((int)1, (int)l.modified.size());
        CatalogImplTest.assertEquals((Object)ft, (Object)l.modified.get(0).getSource());
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getPropertyNames().contains("metadata"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getOldValues().contains(new MetadataMap()));
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getNewValues().contains(newMetadata));
    }

    public void testAddLayer() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getLayers().isEmpty());
        this.addLayer();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getLayers().size());
        LayerInfo l2 = this.catalog.getFactory().createLayer();
        try {
            this.catalog.add(l2);
            CatalogImplTest.fail((String)"adding with no name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.catalog.add(l2);
            CatalogImplTest.fail((String)"adding with no resource should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        l2.setResource((ResourceInfo)this.ft);
        l2.setDefaultStyle(this.s);
        this.catalog.add(l2);
        CatalogImplTest.assertEquals((int)2, (int)this.catalog.getLayers().size());
    }

    public void testGetLayerById() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayer(this.l.getId());
        CatalogImplTest.assertNotNull((Object)l2);
        CatalogImplTest.assertNotSame((Object)this.l, (Object)l2);
        CatalogImplTest.assertEquals((Object)this.l, (Object)l2);
    }

    public void testGetLayerByName() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        CatalogImplTest.assertNotNull((Object)l2);
        CatalogImplTest.assertNotSame((Object)this.l, (Object)l2);
        CatalogImplTest.assertEquals((Object)this.l, (Object)l2);
    }

    public void testGetLayerByNameWithColon() {
        FeatureTypeInfo ft = this.catalog.getFactory().createFeatureType();
        ft.setEnabled(true);
        ft.setName("foo:bar");
        ft.setAbstract("ftAbstract");
        ft.setDescription("ftDescription");
        ft.setStore((StoreInfo)this.ds);
        ft.setNamespace(this.ns);
        this.catalog.add((ResourceInfo)ft);
        LayerInfo l = this.catalog.getFactory().createLayer();
        l.setEnabled(true);
        l.setResource((ResourceInfo)ft);
        l.setDefaultStyle(this.s);
        this.catalog.add(l);
        CatalogImplTest.assertNotNull((Object)this.catalog.getLayerByName("foo:bar"));
    }

    public void testGetLayerByResource() {
        this.addLayer();
        List layers = this.catalog.getLayers((ResourceInfo)this.ft);
        CatalogImplTest.assertEquals((int)1, (int)layers.size());
        LayerInfo l2 = (LayerInfo)layers.get(0);
        CatalogImplTest.assertNotSame((Object)this.l, (Object)l2);
        CatalogImplTest.assertEquals((Object)this.l, (Object)l2);
    }

    public void testRemoveLayer() {
        this.addLayer();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getLayers().size());
        this.catalog.remove(this.l);
        CatalogImplTest.assertTrue((boolean)this.catalog.getLayers().isEmpty());
    }

    public void testModifyLayer() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        l2.setResource(null);
        LayerInfo l3 = this.catalog.getLayerByName(this.l.getName());
        CatalogImplTest.assertEquals((String)this.l.getName(), (String)l3.getName());
        try {
            this.catalog.save(l2);
            CatalogImplTest.fail((String)"setting resource to null should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        l2.setResource((ResourceInfo)this.ft);
        this.catalog.save(l2);
        l3 = this.catalog.getLayerByName(this.ft.getName());
        CatalogImplTest.assertNotNull((Object)l3);
    }

    public void testEnableLayer() {
        this.addLayer();
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        CatalogImplTest.assertTrue((boolean)l2.isEnabled());
        CatalogImplTest.assertTrue((boolean)l2.enabled());
        CatalogImplTest.assertTrue((boolean)l2.getResource().isEnabled());
        l2.setEnabled(false);
        this.catalog.save(l2);
        l2 = this.catalog.getLayerByName(l2.getName());
        CatalogImplTest.assertFalse((boolean)l2.isEnabled());
        CatalogImplTest.assertFalse((boolean)l2.enabled());
        CatalogImplTest.assertFalse((boolean)l2.getResource().isEnabled());
    }

    public void testLayerEvents() {
        this.addFeatureType();
        TestListener tl = new TestListener();
        this.catalog.addListener((CatalogListener)tl);
        CatalogImplTest.assertTrue((boolean)tl.added.isEmpty());
        this.catalog.add(this.l);
        CatalogImplTest.assertEquals((int)1, (int)tl.added.size());
        CatalogImplTest.assertEquals((Object)this.l, (Object)tl.added.get(0).getSource());
        LayerInfo l2 = this.catalog.getLayerByName(this.l.getName());
        l2.setPath("newPath");
        CatalogImplTest.assertTrue((boolean)tl.modified.isEmpty());
        this.catalog.save(l2);
        CatalogImplTest.assertEquals((int)1, (int)tl.modified.size());
        CatalogImplTest.assertEquals((Object)l2, (Object)tl.modified.get(0).getSource());
        CatalogImplTest.assertTrue((boolean)tl.modified.get(0).getPropertyNames().contains("path"));
        CatalogImplTest.assertTrue((boolean)tl.modified.get(0).getOldValues().contains(null));
        CatalogImplTest.assertTrue((boolean)tl.modified.get(0).getNewValues().contains("newPath"));
        CatalogImplTest.assertTrue((boolean)tl.removed.isEmpty());
        this.catalog.remove(l2);
        CatalogImplTest.assertEquals((int)1, (int)tl.removed.size());
        CatalogImplTest.assertEquals((Object)l2, (Object)tl.removed.get(0).getSource());
    }

    public void testAddStyle() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getStyles().isEmpty());
        this.addStyle();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getStyles().size());
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        try {
            this.catalog.add(s2);
            CatalogImplTest.fail((String)"adding without name should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setName("s2Name");
        try {
            this.catalog.add(s2);
            CatalogImplTest.fail((String)"adding without fileName should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setFilename("s2Filename");
        try {
            this.catalog.getStyles().add(s2);
            CatalogImplTest.fail((String)"adding directly should throw exception");
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.catalog.add(s2);
        CatalogImplTest.assertEquals((int)2, (int)this.catalog.getStyles().size());
    }

    public void testGetStyleById() {
        this.addStyle();
        StyleInfo s2 = this.catalog.getStyle(this.s.getId());
        CatalogImplTest.assertNotNull((Object)s2);
        CatalogImplTest.assertNotSame((Object)this.s, (Object)s2);
        CatalogImplTest.assertEquals((Object)this.s, (Object)s2);
    }

    public void testGetStyleByName() {
        this.addStyle();
        StyleInfo s2 = this.catalog.getStyleByName(this.s.getName());
        CatalogImplTest.assertNotNull((Object)s2);
        CatalogImplTest.assertNotSame((Object)this.s, (Object)s2);
        CatalogImplTest.assertEquals((Object)this.s, (Object)s2);
    }

    public void testModifyStyle() {
        this.addStyle();
        StyleInfo s2 = this.catalog.getStyleByName(this.s.getName());
        s2.setName(null);
        s2.setFilename(null);
        StyleInfo s3 = this.catalog.getStyleByName(this.s.getName());
        CatalogImplTest.assertEquals((Object)this.s, (Object)s3);
        try {
            this.catalog.save(s2);
            CatalogImplTest.fail((String)"setting name to null should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setName("s2Name");
        try {
            this.catalog.save(s2);
            CatalogImplTest.fail((String)"setting filename to null should fail");
        }
        catch (Exception exception) {
            // empty catch block
        }
        s2.setFilename("s2Filename");
        this.catalog.save(s2);
        s3 = this.catalog.getStyleByName("styleName");
        CatalogImplTest.assertNull((Object)s3);
        s3 = this.catalog.getStyleByName(s2.getName());
        CatalogImplTest.assertEquals((Object)s2, (Object)s3);
    }

    public void testRemoveStyle() {
        this.addStyle();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getStyles().size());
        this.catalog.remove(this.s);
        CatalogImplTest.assertTrue((boolean)this.catalog.getStyles().isEmpty());
    }

    public void testStyleEvents() {
        TestListener l = new TestListener();
        this.catalog.addListener((CatalogListener)l);
        CatalogImplTest.assertTrue((boolean)l.added.isEmpty());
        this.catalog.add(this.s);
        CatalogImplTest.assertEquals((int)1, (int)l.added.size());
        CatalogImplTest.assertEquals((Object)this.s, (Object)l.added.get(0).getSource());
        StyleInfo s2 = this.catalog.getStyleByName(this.s.getName());
        s2.setFilename("changed");
        CatalogImplTest.assertTrue((boolean)l.modified.isEmpty());
        this.catalog.save(s2);
        CatalogImplTest.assertEquals((int)1, (int)l.modified.size());
        CatalogImplTest.assertEquals((Object)s2, (Object)l.modified.get(0).getSource());
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getPropertyNames().contains("filename"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getOldValues().contains("styleFilename"));
        CatalogImplTest.assertTrue((boolean)l.modified.get(0).getNewValues().contains("changed"));
        CatalogImplTest.assertTrue((boolean)l.removed.isEmpty());
        this.catalog.remove(s2);
        CatalogImplTest.assertEquals((int)1, (int)l.removed.size());
        CatalogImplTest.assertEquals((Object)s2, (Object)l.removed.get(0).getSource());
    }

    public void testProxyBehaviour() throws Exception {
        this.testAddLayer();
        LayerInfo l = this.catalog.getLayerByName(this.ft.getName());
        CatalogImplTest.assertTrue((boolean)(l instanceof Proxy));
        ResourceInfo r = l.getResource();
        CatalogImplTest.assertTrue((boolean)(r instanceof Proxy));
        r.setName("changed");
        this.catalog.save(l);
        l = this.catalog.getLayerByName(this.ft.getName());
        CatalogImplTest.assertEquals((String)"changed", (String)l.getResource().getName());
    }

    public void testProxyListBehaviour() throws Exception {
        this.catalog.add(this.s);
        StyleInfo s2 = this.catalog.getFactory().createStyle();
        s2.setName("a" + this.s.getName());
        s2.setFilename("a.sld");
        this.catalog.add(s2);
        List styles = this.catalog.getStyles();
        CatalogImplTest.assertEquals((int)2, (int)styles.size());
        CatalogImplTest.assertEquals((String)this.s.getName(), (String)((StyleInfo)styles.get(0)).getName());
        CatalogImplTest.assertEquals((String)("a" + this.s.getName()), (String)((StyleInfo)styles.get(1)).getName());
        Collections.sort(styles, new Comparator<StyleInfo>(){

            @Override
            public int compare(StyleInfo o1, StyleInfo o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        CatalogImplTest.assertEquals((String)("a" + this.s.getName()), (String)((StyleInfo)styles.get(0)).getName());
        CatalogImplTest.assertEquals((String)this.s.getName(), (String)((StyleInfo)styles.get(1)).getName());
    }

    public void testExceptionThrowingListener() throws Exception {
        ExceptionThrowingListener l = new ExceptionThrowingListener();
        this.catalog.addListener((CatalogListener)l);
        l.throwCatalogException = false;
        WorkspaceInfo ws = this.catalog.getFactory().createWorkspace();
        ws.setName("foo");
        this.catalog.add(ws);
        l.throwCatalogException = true;
        ws = this.catalog.getFactory().createWorkspace();
        ws.setName("bar");
        try {
            this.catalog.add(ws);
            CatalogImplTest.fail();
        }
        catch (CatalogException catalogException) {
            // empty catch block
        }
    }

    public void testAddWMSStore() {
        CatalogImplTest.assertTrue((boolean)this.catalog.getStores(WMSStoreInfo.class).isEmpty());
        this.addWMSStore();
        CatalogImplTest.assertEquals((int)1, (int)this.catalog.getStores(WMSStoreInfo.class).size());
        WMSStoreInfo retrieved = (WMSStoreInfo)this.catalog.getStore(this.wms.getId(), WMSStoreInfo.class);
        WMSStoreInfo wms2 = this.catalog.getFactory().createWebMapServer();
        wms2.setName("wms2Name");
        wms2.setWorkspace(this.ws);
        this.catalog.add((StoreInfo)wms2);
        CatalogImplTest.assertEquals((int)2, (int)this.catalog.getStores(WMSStoreInfo.class).size());
    }

    public void testGetLayerByIdWithConcurrentAdd() throws Exception {
        this.addDataStore();
        this.addNamespace();
        LayerInfo layer = this.catalog.getFactory().createLayer();
        layer.setResource((ResourceInfo)this.ft);
        layer.setName("LAYER");
        this.catalog.add(layer);
        String id = layer.getId();
        CountDownLatch ready = new CountDownLatch(11);
        CountDownLatch done = new CountDownLatch(10);
        ArrayList<LayerAddRunner> runners = new ArrayList<LayerAddRunner>();
        int i = 0;
        while (i < 10) {
            LayerAddRunner runner = new LayerAddRunner(ready, done, i);
            new Thread(runner).start();
            runners.add(runner);
            ++i;
        }
        ready.countDown();
        ready.await();
        i = 0;
        while (i < 500) {
            this.catalog.getLayer(id);
            ++i;
        }
        done.await();
        RunnerBase.checkForRunnerExceptions(runners);
    }

    static class ExceptionThrowingListener
    implements CatalogListener {
        public boolean throwCatalogException;

        ExceptionThrowingListener() {
        }

        public void handleAddEvent(CatalogAddEvent event) throws CatalogException {
            if (this.throwCatalogException) {
                throw new CatalogException();
            }
            throw new RuntimeException();
        }

        public void handleModifyEvent(CatalogModifyEvent event) throws CatalogException {
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) throws CatalogException {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) throws CatalogException {
        }

        public void reloaded() {
        }
    }

    class LayerAddRunner
    extends RunnerBase {
        private int idx;

        protected LayerAddRunner(CountDownLatch ready, CountDownLatch done, int idx) {
            super(ready, done);
            this.idx = idx;
        }

        protected void runInternal() throws Exception {
            CatalogFactory factory = CatalogImplTest.this.catalog.getFactory();
            int i = 0;
            while (i < 500) {
                LayerInfo layer = factory.createLayer();
                layer.setResource((ResourceInfo)CatalogImplTest.this.ft);
                layer.setName("LAYER-" + i + "-" + this.idx);
                CatalogImplTest.this.catalog.add(layer);
                ++i;
            }
        }
    }

    static class TestListener
    implements CatalogListener {
        public List<CatalogAddEvent> added = new ArrayList<CatalogAddEvent>();
        public List<CatalogModifyEvent> modified = new ArrayList<CatalogModifyEvent>();
        public List<CatalogRemoveEvent> removed = new ArrayList<CatalogRemoveEvent>();

        TestListener() {
        }

        public void handleAddEvent(CatalogAddEvent event) {
            this.added.add(event);
        }

        public void handleModifyEvent(CatalogModifyEvent event) {
            this.modified.add(event);
        }

        public void handlePostModifyEvent(CatalogPostModifyEvent event) {
        }

        public void handleRemoveEvent(CatalogRemoveEvent event) {
            this.removed.add(event);
        }

        public void reloaded() {
        }
    }
}

