/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.config.util;

import java.util.ArrayList;
import java.util.List;
import junit.framework.TestCase;
import org.geoserver.catalog.impl.LayerIdentifier;
import org.geoserver.config.util.LayerIdentifierInfoListConverter;

public class LayerIdentifierInfoListConverterTest
extends TestCase {
    public void testFromString() {
        String serialized = "[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"},{\"authority\":\"auth2\",\"identifier\":\"IDENTIFIER_2\"}]";
        ArrayList<LayerIdentifier> expected = new ArrayList<LayerIdentifier>();
        LayerIdentifier id1 = new LayerIdentifier();
        id1.setAuthority("auth1");
        id1.setIdentifier("IDENTIFIER_1");
        expected.add(id1);
        LayerIdentifier id2 = new LayerIdentifier();
        id2.setAuthority("auth2");
        id2.setIdentifier("IDENTIFIER_2");
        expected.add(id2);
        List actual = LayerIdentifierInfoListConverter.fromString((String)"[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"},{\"authority\":\"auth2\",\"identifier\":\"IDENTIFIER_2\"}]");
        LayerIdentifierInfoListConverterTest.assertEquals(expected, (Object)actual);
    }

    public void testFromInvalidString() {
        String serialized = "[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]";
        try {
            LayerIdentifierInfoListConverter.fromString((String)"[{\"name:\"auth1\",\"href\":\"http://geoserver.org/auth1?\"},]");
            LayerIdentifierInfoListConverterTest.fail((String)"Expected IAE");
        }
        catch (IllegalArgumentException e) {
            LayerIdentifierInfoListConverterTest.assertTrue((boolean)true);
        }
    }

    public void testToString() {
        ArrayList<LayerIdentifier> list = new ArrayList<LayerIdentifier>();
        LayerIdentifier id1 = new LayerIdentifier();
        id1.setAuthority("auth1");
        id1.setIdentifier("IDENTIFIER_1");
        list.add(id1);
        LayerIdentifier id2 = new LayerIdentifier();
        id2.setAuthority("auth2");
        id2.setIdentifier("IDENTIFIER_2");
        list.add(id2);
        String actual = LayerIdentifierInfoListConverter.toString(list);
        System.out.println(actual);
        String expected = "[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"},{\"authority\":\"auth2\",\"identifier\":\"IDENTIFIER_2\"}]";
        LayerIdentifierInfoListConverterTest.assertEquals((String)expected, (String)actual);
    }

    public void testToStringListWithNullElement() {
        ArrayList<LayerIdentifier> list = new ArrayList<LayerIdentifier>();
        LayerIdentifier id1 = new LayerIdentifier();
        id1.setAuthority("auth1");
        id1.setIdentifier("IDENTIFIER_1");
        list.add(id1);
        list.add(null);
        String actual = LayerIdentifierInfoListConverter.toString(list);
        String expected = "[{\"authority\":\"auth1\",\"identifier\":\"IDENTIFIER_1\"}]";
        LayerIdentifierInfoListConverterTest.assertEquals((String)expected, (String)actual);
    }

    public void testToStringListWithOnlyNullElements() {
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(null);
        list.add(null);
        list.add(null);
        LayerIdentifierInfoListConverterTest.assertNull((Object)LayerIdentifierInfoListConverter.toString(list));
    }

    public void testToStringEmptyList() {
        ArrayList list = new ArrayList();
        String actual = LayerIdentifierInfoListConverter.toString(list);
        LayerIdentifierInfoListConverterTest.assertNull((Object)actual);
    }
}

