/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.template;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.GeometryFactory;
import freemarker.template.Configuration;
import freemarker.template.ObjectWrapper;
import freemarker.template.Template;
import java.io.StringWriter;
import java.io.Writer;
import junit.framework.TestCase;
import org.geoserver.template.FeatureWrapper;
import org.geotools.data.DataUtilities;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.feature.DefaultFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.opengis.feature.Feature;
import org.opengis.feature.simple.SimpleFeatureType;

public class FeatureWrapperTest
extends TestCase {
    SimpleFeatureCollection features;
    Configuration cfg;

    protected void setUp() throws Exception {
        super.setUp();
        GeometryFactory gf = new GeometryFactory();
        SimpleFeatureType featureType = DataUtilities.createType((String)"testType", (String)"string:String,int:Integer,double:Double,geom:Point");
        this.features = new DefaultFeatureCollection(null, null){};
        this.features.add((Feature)SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"one", new Integer(1), new Double(1.1), gf.createPoint(new Coordinate(1.0, 1.0))}, (String)"fid.1"));
        this.features.add((Feature)SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"two", new Integer(2), new Double(2.2), gf.createPoint(new Coordinate(2.0, 2.0))}, (String)"fid.2"));
        this.features.add((Feature)SimpleFeatureBuilder.build((SimpleFeatureType)featureType, (Object[])new Object[]{"three", new Integer(3), new Double(3.3), gf.createPoint(new Coordinate(3.0, 3.0))}, (String)"fid.3"));
        this.cfg = new Configuration();
        this.cfg.setClassForTemplateLoading(((Object)((Object)this)).getClass(), "");
        this.cfg.setObjectWrapper((ObjectWrapper)new FeatureWrapper());
    }

    public void testFeatureCollection() throws Exception {
        Template template = this.cfg.getTemplate("FeatureCollection.ftl");
        StringWriter out = new StringWriter();
        template.process((Object)this.features, (Writer)out);
        FeatureWrapperTest.assertEquals((String)"fid.1\nfid.2\nfid.3\n", (String)out.toString().replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    public void testFeatureSimple() throws Exception {
        Template template = this.cfg.getTemplate("FeatureSimple.ftl");
        StringWriter out = new StringWriter();
        template.process(this.features.iterator().next(), (Writer)out);
        FeatureWrapperTest.assertEquals((String)"one\n1\n1.1\nPOINT (1 1)", (String)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }

    public void testFeatureDynamic() throws Exception {
        Template template = this.cfg.getTemplate("FeatureDynamic.ftl");
        StringWriter out = new StringWriter();
        template.process(this.features.iterator().next(), (Writer)out);
        FeatureWrapperTest.assertEquals((String)"string=one\nint=1\ndouble=1.1\ngeom=POINT (1 1)\n", (String)out.toString().replace(',', '.').replaceAll("\r\n", "\n").replaceAll("\r", "\n"));
    }
}

