/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.feature.retype;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Collections;
import javax.xml.namespace.QName;
import junit.framework.TestCase;
import org.geoserver.data.test.MockData;
import org.geoserver.data.util.IOUtils;
import org.geoserver.feature.retype.RetypingDataStore;
import org.geoserver.feature.retype.RetypingFeatureSource;
import org.geotools.data.DataStore;
import org.geotools.data.property.PropertyDataStore;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureLocking;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class RetypingFeatureSourceTest
extends TestCase {
    static final String RENAMED = "houses";
    RetypingDataStore rts;
    private File data;
    private PropertyDataStore store;

    protected void setUp() throws Exception {
        this.data = File.createTempFile("retype", "data", new File("./target"));
        this.data.delete();
        this.data.mkdir();
        this.copyTestData(MockData.BUILDINGS, this.data);
        this.copyTestData(MockData.BRIDGES, this.data);
        this.store = new PropertyDataStore(this.data);
    }

    void copyTestData(QName testData, File data) throws IOException {
        String fileName = String.valueOf(testData.getLocalPart()) + ".properties";
        URL properties = MockData.class.getResource(fileName);
        IOUtils.copy((InputStream)properties.openStream(), (File)new File(data, fileName));
    }

    public void testSimpleRename() throws IOException {
        SimpleFeatureSource fs = this.store.getFeatureSource(MockData.BUILDINGS.getLocalPart());
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs.getSchema());
        tb.setName(RENAMED);
        SimpleFeatureType target = tb.buildFeatureType();
        SimpleFeatureSource retyped = RetypingFeatureSource.getRetypingSource((SimpleFeatureSource)fs, (SimpleFeatureType)target);
        RetypingFeatureSourceTest.assertTrue((boolean)(retyped instanceof SimpleFeatureLocking));
        RetypingFeatureSourceTest.assertEquals((Object)target, (Object)retyped.getSchema());
        RetypingFeatureSourceTest.assertEquals((Object)target, (Object)((DataStore)retyped.getDataStore()).getSchema(RENAMED));
        RetypingFeatureSourceTest.assertEquals((Object)target, (Object)retyped.getFeatures().getSchema());
        SimpleFeatureIterator it = retyped.getFeatures().features();
        SimpleFeature f = (SimpleFeature)it.next();
        it.close();
        RetypingFeatureSourceTest.assertEquals((Object)target, (Object)f.getType());
    }

    public void testConflictingRename() throws IOException {
        SimpleFeatureSource fs = this.store.getFeatureSource(MockData.BUILDINGS.getLocalPart());
        RetypingFeatureSourceTest.assertEquals((int)2, (int)this.store.getTypeNames().length);
        RetypingFeatureSourceTest.assertNotNull((Object)this.store.getSchema(MockData.BRIDGES.getLocalPart()));
        SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
        tb.init((SimpleFeatureType)fs.getSchema());
        tb.setName(MockData.BRIDGES.getLocalPart());
        SimpleFeatureType target = tb.buildFeatureType();
        SimpleFeatureSource retyped = RetypingFeatureSource.getRetypingSource((SimpleFeatureSource)fs, (SimpleFeatureType)target);
        RetypingFeatureSourceTest.assertEquals((Object)target, (Object)retyped.getSchema());
        DataStore rs = (DataStore)retyped.getDataStore();
        RetypingFeatureSourceTest.assertEquals((int)1, (int)rs.getTypeNames().length);
        RetypingFeatureSourceTest.assertEquals((String)MockData.BRIDGES.getLocalPart(), (String)rs.getTypeNames()[0]);
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String fid = String.valueOf(MockData.BRIDGES.getLocalPart()) + ".1107531701011";
        Id fidFilter = ff.id(Collections.singleton(ff.featureId(fid)));
        SimpleFeatureIterator it = retyped.getFeatures((Filter)fidFilter).features();
        RetypingFeatureSourceTest.assertTrue((boolean)it.hasNext());
        SimpleFeature f = (SimpleFeature)it.next();
        RetypingFeatureSourceTest.assertFalse((boolean)it.hasNext());
        it.close();
        RetypingFeatureSourceTest.assertEquals((Object)"114", (Object)f.getAttribute("FID"));
        RetypingFeatureSourceTest.assertEquals((Object)"215 Main Street", (Object)f.getAttribute("ADDRESS"));
    }
}

