/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.logging;

import com.mockrunner.mock.web.MockServletContext;
import java.io.File;
import java.net.URL;
import javax.servlet.ServletContext;
import javax.servlet.ServletContextEvent;
import junit.framework.TestCase;
import org.apache.commons.io.FileUtils;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Logger;
import org.geoserver.logging.LoggingStartupContextListener;

public class LoggingStartupContextListenerTest
extends TestCase {
    public void testLogLocationFromServletContext() throws Exception {
        File tmp = File.createTempFile("log", "tmp", new File("target"));
        tmp.delete();
        tmp.mkdirs();
        File logs = new File(tmp, "logs");
        LoggingStartupContextListenerTest.assertTrue((boolean)logs.mkdirs());
        FileUtils.copyURLToFile((URL)((Object)((Object)this)).getClass().getResource("logging.xml"), (File)new File(tmp, "logging.xml"));
        MockServletContext context = new MockServletContext();
        context.setInitParameter("GEOSERVER_DATA_DIR", tmp.getPath());
        context.setInitParameter("GEOSERVER_LOG_LOCATION", new File(tmp, "foo.log").getAbsolutePath());
        Logger logger = Logger.getRootLogger();
        LoggingStartupContextListenerTest.assertNull((Object)logger.getAppender("geoserverlogfile"));
        String rel = System.getProperty("RELINQUISH_LOG4J_CONTROL");
        System.setProperty("RELINQUISH_LOG4J_CONTROL", "false");
        try {
            new LoggingStartupContextListener().contextInitialized(new ServletContextEvent((ServletContext)context));
        }
        finally {
            System.setProperty("RELINQUISH_LOG4J_CONTROL", "rel");
        }
        Appender appender = logger.getAppender("geoserverlogfile");
        LoggingStartupContextListenerTest.assertNotNull((Object)appender);
        LoggingStartupContextListenerTest.assertTrue((boolean)(appender instanceof FileAppender));
        LoggingStartupContextListenerTest.assertEquals((String)new File(tmp, "foo.log").getCanonicalPath(), (String)((FileAppender)appender).getFile());
    }
}

