/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.security.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Properties;
import org.easymock.EasyMock;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.CoverageStoreInfo;
import org.geoserver.catalog.DataStoreInfo;
import org.geoserver.catalog.FeatureTypeInfo;
import org.geoserver.catalog.LayerInfo;
import org.geoserver.catalog.ResourceInfo;
import org.geoserver.catalog.StoreInfo;
import org.geoserver.catalog.WorkspaceInfo;
import org.geoserver.security.DataAccessManager;
import org.geoserver.security.DataAccessManagerAdapter;
import org.geoserver.security.ResourceAccessManager;
import org.geoserver.security.impl.DataAccessRuleDAO;
import org.geoserver.security.impl.DefaultDataAccessManager;
import org.geoserver.security.impl.MemoryDataAccessRuleDAO;
import org.geoserver.security.impl.SecureObjectsTest;
import org.geotools.data.DataStore;
import org.geotools.data.FeatureStore;
import org.geotools.factory.Hints;
import org.opengis.util.ProgressListener;
import org.springframework.security.Authentication;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.providers.TestingAuthenticationToken;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAuthorizationTest
extends SecureObjectsTest {
    protected Authentication rwUser;
    protected Authentication roUser;
    protected Authentication anonymous;
    protected Authentication milUser;
    protected TestingAuthenticationToken root;
    protected Catalog catalog;
    protected WorkspaceInfo toppWs;
    protected WorkspaceInfo nurcWs;
    protected LayerInfo statesLayer;
    protected LayerInfo landmarksLayer;
    protected LayerInfo basesLayer;
    protected LayerInfo arcGridLayer;
    protected LayerInfo roadsLayer;
    protected FeatureTypeInfo states;
    protected CoverageInfo arcGrid;
    protected FeatureTypeInfo roads;
    protected FeatureTypeInfo landmarks;
    protected FeatureTypeInfo bases;
    protected DataStoreInfo statesStore;
    protected DataStoreInfo roadsStore;
    protected CoverageStoreInfo arcGridStore;
    protected List<LayerInfo> layers;
    protected List<FeatureTypeInfo> featureTypes;
    protected List<CoverageInfo> coverages;
    protected List<WorkspaceInfo> workspaces;

    @Override
    protected void setUp() throws Exception {
        super.setUp();
        this.rwUser = new TestingAuthenticationToken((Object)"rw", (Object)"supersecret", new GrantedAuthority[]{new GrantedAuthorityImpl("READER"), new GrantedAuthorityImpl("WRITER")});
        this.roUser = new TestingAuthenticationToken((Object)"ro", (Object)"supersecret", new GrantedAuthority[]{new GrantedAuthorityImpl("READER")});
        this.anonymous = new TestingAuthenticationToken((Object)"anonymous", null);
        this.milUser = new TestingAuthenticationToken((Object)"military", (Object)"supersecret", new GrantedAuthority[]{new GrantedAuthorityImpl("MILITARY")});
        this.root = new TestingAuthenticationToken((Object)"admin", (Object)"geoserver", new GrantedAuthority[]{new GrantedAuthorityImpl("ROLE_ADMINISTRATOR")});
        this.catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)this.catalog.getWorkspace((String)EasyMock.anyObject())).andReturn((Object)((WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class))).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.catalog});
        this.toppWs = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)this.toppWs.getName()).andReturn((Object)"topp").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.toppWs});
        this.nurcWs = (WorkspaceInfo)EasyMock.createNiceMock(WorkspaceInfo.class);
        EasyMock.expect((Object)this.nurcWs.getName()).andReturn((Object)"nurc").anyTimes();
        EasyMock.replay((Object[])new Object[]{this.nurcWs});
        this.statesLayer = this.buildLayer("states", this.toppWs, FeatureTypeInfo.class);
        this.roadsLayer = this.buildLayer("roads", this.toppWs, FeatureTypeInfo.class);
        this.landmarksLayer = this.buildLayer("landmarks", this.toppWs, FeatureTypeInfo.class);
        this.basesLayer = this.buildLayer("bases", this.toppWs, FeatureTypeInfo.class);
        this.arcGridLayer = this.buildLayer("arc.grid", this.nurcWs, CoverageInfo.class);
        this.states = (FeatureTypeInfo)this.statesLayer.getResource();
        this.statesStore = this.states.getStore();
        this.arcGrid = (CoverageInfo)this.arcGridLayer.getResource();
        this.arcGridStore = this.arcGrid.getStore();
        this.roads = (FeatureTypeInfo)this.roadsLayer.getResource();
        this.roadsStore = this.roads.getStore();
        this.landmarks = (FeatureTypeInfo)this.landmarksLayer.getResource();
        this.bases = (FeatureTypeInfo)this.basesLayer.getResource();
    }

    protected LayerInfo buildLayer(String name, WorkspaceInfo ws, Class<? extends ResourceInfo> resourceClass) throws Exception {
        StoreInfo store;
        FeatureStore fs = (FeatureStore)EasyMock.createNiceMock(FeatureStore.class);
        EasyMock.replay((Object[])new Object[]{fs});
        DataStore dstore = (DataStore)EasyMock.createNiceMock(DataStore.class);
        EasyMock.replay((Object[])new Object[]{dstore});
        if (resourceClass.equals(CoverageInfo.class)) {
            store = (StoreInfo)EasyMock.createNiceMock(CoverageStoreInfo.class);
        } else {
            store = (StoreInfo)EasyMock.createNiceMock(DataStoreInfo.class);
            EasyMock.expect((Object)((DataStore)((DataStoreInfo)store).getDataStore(null))).andReturn((Object)dstore);
        }
        EasyMock.expect((Object)store.getWorkspace()).andReturn((Object)ws).anyTimes();
        EasyMock.replay((Object[])new Object[]{store});
        ResourceInfo resource = (ResourceInfo)EasyMock.createNiceMock(resourceClass);
        EasyMock.expect((Object)resource.getStore()).andReturn((Object)store).anyTimes();
        EasyMock.expect((Object)resource.getName()).andReturn((Object)name).anyTimes();
        if (resource instanceof FeatureTypeInfo) {
            EasyMock.expect((Object)((FeatureTypeInfo)resource).getFeatureSource((ProgressListener)EasyMock.anyObject(), (Hints)EasyMock.anyObject())).andReturn((Object)fs).anyTimes();
        }
        EasyMock.replay((Object[])new Object[]{resource});
        LayerInfo layer = (LayerInfo)EasyMock.createNiceMock(LayerInfo.class);
        EasyMock.expect((Object)layer.getName()).andReturn((Object)name).anyTimes();
        EasyMock.expect((Object)layer.getResource()).andReturn((Object)resource).anyTimes();
        EasyMock.replay((Object[])new Object[]{layer});
        return layer;
    }

    protected ResourceAccessManager buildManager(String propertyFile) throws Exception {
        return new DataAccessManagerAdapter(this.buildLegacyAccessManager(propertyFile));
    }

    protected DataAccessManager buildLegacyAccessManager(String propertyFile) throws Exception {
        Properties props = new Properties();
        props.load(((Object)((Object)this)).getClass().getResourceAsStream(propertyFile));
        return new DefaultDataAccessManager((DataAccessRuleDAO)new MemoryDataAccessRuleDAO(this.catalog, props));
    }

    protected void populateCatalog() {
        this.layers = Arrays.asList(this.statesLayer, this.roadsLayer, this.landmarksLayer, this.basesLayer, this.arcGridLayer);
        this.featureTypes = new ArrayList<FeatureTypeInfo>();
        this.coverages = new ArrayList<CoverageInfo>();
        for (LayerInfo layer : this.layers) {
            if (layer.getResource() instanceof FeatureTypeInfo) {
                this.featureTypes.add((FeatureTypeInfo)layer.getResource());
                continue;
            }
            this.coverages.add((CoverageInfo)layer.getResource());
        }
        this.workspaces = Arrays.asList(this.toppWs, this.nurcWs);
        this.catalog = (Catalog)EasyMock.createNiceMock(Catalog.class);
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:states")).andReturn((Object)this.states).anyTimes();
        EasyMock.expect((Object)((FeatureTypeInfo)this.catalog.getResourceByName("topp:states", FeatureTypeInfo.class))).andReturn((Object)this.states).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayerByName("topp:states")).andReturn((Object)this.statesLayer).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageByName("nurc:arcgrid")).andReturn((Object)this.arcGrid).anyTimes();
        EasyMock.expect((Object)((CoverageInfo)this.catalog.getResourceByName("nurc:arcgrid", CoverageInfo.class))).andReturn((Object)this.arcGrid).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:roads")).andReturn((Object)this.roads).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:landmarks")).andReturn((Object)this.landmarks).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypeByName("topp:bases")).andReturn((Object)this.bases).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName("states")).andReturn((Object)this.statesStore).anyTimes();
        EasyMock.expect((Object)this.catalog.getDataStoreByName("roads")).andReturn((Object)this.roadsStore).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverageStoreByName("arcGrid")).andReturn((Object)this.arcGridStore).anyTimes();
        EasyMock.expect((Object)this.catalog.getLayers()).andReturn(this.layers).anyTimes();
        EasyMock.expect((Object)this.catalog.getFeatureTypes()).andReturn(this.featureTypes).anyTimes();
        EasyMock.expect((Object)this.catalog.getCoverages()).andReturn(this.coverages).anyTimes();
        EasyMock.expect((Object)this.catalog.getWorkspaces()).andReturn(this.workspaces).anyTimes();
        EasyMock.expect((Object)this.catalog.getWorkspaceByName("topp")).andReturn((Object)this.toppWs).anyTimes();
        EasyMock.expect((Object)this.catalog.getWorkspaceByName("nurc")).andReturn((Object)this.nurcWs).anyTimes();
        EasyMock.replay((Object[])new Object[]{this.catalog});
    }
}

