/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.ows;

import com.mockrunner.mock.web.MockHttpServletRequest;
import com.mockrunner.mock.web.MockHttpServletResponse;
import com.mockrunner.mock.web.MockServletOutputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Collections;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.xml.parsers.DocumentBuilderFactory;
import junit.framework.TestCase;
import org.apache.xpath.XPathAPI;
import org.geoserver.ows.DefaultServiceExceptionHandler;
import org.geoserver.ows.HelloWorld;
import org.geoserver.ows.Request;
import org.geoserver.platform.Service;
import org.geoserver.platform.ServiceException;
import org.geotools.util.Version;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class DefaultServiceExceptionHandlerTest
extends TestCase {
    private DefaultServiceExceptionHandler handler;
    private MockHttpServletRequest request;
    private MockHttpServletResponse response;
    private Request requestInfo;

    protected void setUp() throws Exception {
        super.setUp();
        HelloWorld helloWorld = new HelloWorld();
        Service service = new Service("hello", (Object)helloWorld, new Version("1.0.0"), Collections.singletonList("hello"));
        this.request = new MockHttpServletRequest(){

            public int getServerPort() {
                return 8080;
            }
        };
        this.request.setScheme("http");
        this.request.setServerName("localhost");
        this.request.setContextPath("geoserver");
        MockServletOutputStream output = new MockServletOutputStream();
        this.response = new MockHttpServletResponse();
        this.handler = new DefaultServiceExceptionHandler();
        this.requestInfo = new Request();
        this.requestInfo.setHttpRequest((HttpServletRequest)this.request);
        this.requestInfo.setHttpResponse((HttpServletResponse)this.response);
        this.requestInfo.setService("hello");
        this.requestInfo.setVersion("1.0.0");
    }

    public void testHandleServiceException() throws Exception {
        ServiceException exception = new ServiceException("hello service exception");
        exception.setCode("helloCode");
        exception.setLocator("helloLocator");
        exception.getExceptionText().add("helloText");
        this.handler.handleServiceException(exception, this.requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(this.response.getOutputStreamContent().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        DefaultServiceExceptionHandlerTest.assertEquals((String)"ows:ExceptionReport", (String)doc.getDocumentElement().getNodeName());
    }

    public void testHandleServiceExceptionEncoding() throws Exception {
        String message = "foo & <foo> \"foo's\"";
        ServiceException exception = new ServiceException(message);
        exception.setLocator("test-locator");
        this.handler.handleServiceException(exception, this.requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(this.response.getOutputStreamContent().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionText = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        DefaultServiceExceptionHandlerTest.assertNotNull((Object)exceptionText);
        DefaultServiceExceptionHandlerTest.assertEquals((String)"round-tripped through character entities", (String)message, (String)exceptionText.getTextContent());
    }

    public void testHandleServiceExceptionEncodingMore() throws Exception {
        String message1 = "foo & <foo> \"foo's\"";
        String message2 = "a \"different\" <message>";
        ServiceException exception = new ServiceException(message1);
        exception.setLocator("test-locator");
        exception.getExceptionText().add(message2);
        this.handler.handleServiceException(exception, this.requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(this.response.getOutputStreamContent().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionText = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        DefaultServiceExceptionHandlerTest.assertNotNull((Object)exceptionText);
        String message = String.valueOf(message1) + "\n" + message2;
        DefaultServiceExceptionHandlerTest.assertEquals((String)"round-tripped through character entities", (String)message, (String)exceptionText.getTextContent());
    }

    public void testHandleServiceExceptionCauses() throws Exception {
        IllegalArgumentException illegalArgument = new IllegalArgumentException("Illegal argument here");
        IOException ioException = new IOException("I/O exception here");
        ioException.initCause(illegalArgument);
        ServiceException serviceException = new ServiceException("hello service exception");
        serviceException.setCode("helloCode");
        serviceException.setLocator("helloLocator");
        serviceException.getExceptionText().add("helloText");
        serviceException.initCause((Throwable)ioException);
        this.handler.handleServiceException(serviceException, this.requestInfo);
        ByteArrayInputStream input = new ByteArrayInputStream(this.response.getOutputStreamContent().getBytes());
        DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
        docBuilderFactory.setNamespaceAware(true);
        Document doc = docBuilderFactory.newDocumentBuilder().parse(input);
        Node exceptionText = XPathAPI.selectSingleNode((Node)doc, (String)"ows:ExceptionReport/ows:Exception/ows:ExceptionText/text()");
        DefaultServiceExceptionHandlerTest.assertNotNull((Object)exceptionText);
        DefaultServiceExceptionHandlerTest.assertTrue((exceptionText.getNodeValue().indexOf(illegalArgument.getMessage()) != -1 ? 1 : 0) != 0);
        DefaultServiceExceptionHandlerTest.assertTrue((exceptionText.getNodeValue().indexOf(ioException.getMessage()) != -1 ? 1 : 0) != 0);
        DefaultServiceExceptionHandlerTest.assertTrue((exceptionText.getNodeValue().indexOf(serviceException.getMessage()) != -1 ? 1 : 0) != 0);
    }
}

