/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.kvp;

import junit.framework.TestCase;
import net.opengis.wcs11.AxisSubsetType;
import net.opengis.wcs11.FieldSubsetType;
import net.opengis.wcs11.RangeSubsetType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.wcs.kvp.RangeSubsetKvpParser;
import org.vfny.geoserver.wcs.WcsException;

public class RangeSubsetKvpParserTest
extends TestCase {
    RangeSubsetKvpParser parser = new RangeSubsetKvpParser();

    public void testSimpleFields() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance;temperature");
        RangeSubsetKvpParserTest.assertNotNull((Object)rs);
        RangeSubsetKvpParserTest.assertEquals((int)2, (int)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        RangeSubsetKvpParserTest.assertEquals((String)"radiance", (String)field.getIdentifier().getValue());
        RangeSubsetKvpParserTest.assertEquals(null, (String)field.getInterpolationType());
        field = (FieldSubsetType)rs.getFieldSubset().get(1);
        RangeSubsetKvpParserTest.assertEquals((String)"temperature", (String)field.getIdentifier().getValue());
        RangeSubsetKvpParserTest.assertEquals(null, (String)field.getInterpolationType());
    }

    public void testInvalidInterpolation() throws Exception {
        try {
            this.parser.parse("radiance:mindReadingWarper");
            RangeSubsetKvpParserTest.fail((String)"We do not support _that_ interpolation!");
        }
        catch (WcsException e) {
            RangeSubsetKvpParserTest.assertEquals((String)WcsException.WcsExceptionCode.InvalidParameterValue.toString(), (String)e.getCode());
            RangeSubsetKvpParserTest.assertEquals((String)"RangeSubset", (String)e.getLocator());
        }
    }

    public void testInterpolation() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance:linear;temperature:nearest");
        RangeSubsetKvpParserTest.assertNotNull((Object)rs);
        RangeSubsetKvpParserTest.assertEquals((int)2, (int)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        RangeSubsetKvpParserTest.assertEquals((String)"radiance", (String)field.getIdentifier().getValue());
        RangeSubsetKvpParserTest.assertEquals((String)"linear", (String)field.getInterpolationType());
        field = (FieldSubsetType)rs.getFieldSubset().get(1);
        RangeSubsetKvpParserTest.assertEquals((String)"temperature", (String)field.getIdentifier().getValue());
        RangeSubsetKvpParserTest.assertEquals((String)"nearest", (String)field.getInterpolationType());
    }

    public void testAxisSingleKey() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance[bands[Red]]");
        RangeSubsetKvpParserTest.assertNotNull((Object)rs);
        RangeSubsetKvpParserTest.assertEquals((int)1, (int)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        RangeSubsetKvpParserTest.assertEquals((String)"radiance", (String)field.getIdentifier().getValue());
        RangeSubsetKvpParserTest.assertEquals((int)1, (int)field.getAxisSubset().size());
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        RangeSubsetKvpParserTest.assertEquals((String)"bands", (String)axis.getIdentifier());
        EList keys = axis.getKey();
        RangeSubsetKvpParserTest.assertEquals((int)1, (int)keys.size());
        RangeSubsetKvpParserTest.assertEquals((Object)"Red", keys.get(0));
    }

    public void testAxisKeys() throws Exception {
        RangeSubsetType rs = (RangeSubsetType)this.parser.parse("radiance[bands[Red,Green,Blue]]");
        RangeSubsetKvpParserTest.assertNotNull((Object)rs);
        RangeSubsetKvpParserTest.assertEquals((int)1, (int)rs.getFieldSubset().size());
        FieldSubsetType field = (FieldSubsetType)rs.getFieldSubset().get(0);
        RangeSubsetKvpParserTest.assertEquals((String)"radiance", (String)field.getIdentifier().getValue());
        RangeSubsetKvpParserTest.assertEquals((int)1, (int)field.getAxisSubset().size());
        AxisSubsetType axis = (AxisSubsetType)field.getAxisSubset().get(0);
        RangeSubsetKvpParserTest.assertEquals((String)"bands", (String)axis.getIdentifier());
        EList keys = axis.getKey();
        RangeSubsetKvpParserTest.assertEquals((int)3, (int)keys.size());
        RangeSubsetKvpParserTest.assertEquals((Object)"Red", keys.get(0));
        RangeSubsetKvpParserTest.assertEquals((Object)"Green", keys.get(1));
        RangeSubsetKvpParserTest.assertEquals((Object)"Blue", keys.get(2));
    }
}

