/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wcs.response;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import net.opengis.wcs11.GetCapabilitiesType;
import org.eclipse.emf.common.util.EList;
import org.geoserver.catalog.Catalog;
import org.geoserver.catalog.CoverageInfo;
import org.geoserver.catalog.MetadataLinkInfo;
import org.geoserver.config.ContactInfo;
import org.geoserver.config.GeoServer;
import org.geoserver.config.GeoServerInfo;
import org.geoserver.ows.URLMangler;
import org.geoserver.ows.util.ResponseUtils;
import org.geoserver.wcs.WCSInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.geotools.xml.transform.TransformerBase;
import org.geotools.xml.transform.Translator;
import org.vfny.geoserver.global.CoverageInfoLabelComparator;
import org.vfny.geoserver.wcs.WcsException;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.AttributesImpl;

public class WCSCapsTransformer
extends TransformerBase {
    private static final Logger LOGGER = Logging.getLogger((String)WCSCapsTransformer.class.getPackage().getName());
    protected static final String WCS_URI = "http://www.opengis.net/wcs/1.1.1";
    protected static final String CUR_VERSION = "1.1.1";
    protected static final String XSI_PREFIX = "xsi";
    protected static final String XSI_URI = "http://www.w3.org/2001/XMLSchema-instance";
    private WCSInfo wcs;
    private Catalog catalog;

    public WCSCapsTransformer(GeoServer gs) {
        this.wcs = (WCSInfo)gs.getService(WCSInfo.class);
        this.catalog = gs.getCatalog();
        this.setNamespaceDeclarationEnabled(false);
    }

    public Translator createTranslator(ContentHandler handler) {
        return new WCS111CapsTranslator(handler);
    }

    private class WCS111CapsTranslator
    extends TransformerBase.TranslatorSupport {
        private GetCapabilitiesType request;

        public WCS111CapsTranslator(ContentHandler handler) {
            super(handler, null, null);
        }

        public void encode(Object o) throws IllegalArgumentException {
            EList sections;
            boolean allSections;
            if (!(o instanceof GetCapabilitiesType)) {
                throw new IllegalArgumentException(new StringBuffer("Not a GetCapabilitiesType: ").append(o).toString());
            }
            this.request = (GetCapabilitiesType)o;
            int updateSequence = WCSCapsTransformer.this.wcs.getGeoServer().getGlobal().getUpdateSequence();
            int requestedUpdateSequence = -1;
            if (this.request.getUpdateSequence() != null) {
                try {
                    requestedUpdateSequence = Integer.parseInt(this.request.getUpdateSequence());
                }
                catch (NumberFormatException e) {
                    throw new WcsException("Invalid update sequence number format, should be an integer", WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
                if (requestedUpdateSequence > updateSequence) {
                    throw new WcsException("Invalid update sequence value, it's higher than the current value, " + updateSequence, WcsException.WcsExceptionCode.InvalidUpdateSequence, "updateSequence");
                }
            }
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "version", "version", "", WCSCapsTransformer.CUR_VERSION);
            attributes.addAttribute("", "xmlns:wcs", "xmlns:wcs", "", WCSCapsTransformer.WCS_URI);
            attributes.addAttribute("", "xmlns:xlink", "xmlns:xlink", "", "http://www.w3.org/1999/xlink");
            attributes.addAttribute("", "xmlns:ogc", "xmlns:ogc", "", "http://www.opengis.net/ogc");
            attributes.addAttribute("", "xmlns:ows", "xmlns:ows", "", "http://www.opengis.net/ows/1.1");
            attributes.addAttribute("", "xmlns:gml", "xmlns:gml", "", "http://www.opengis.net/gml");
            String prefixDef = new StringBuffer("xmlns:").append(WCSCapsTransformer.XSI_PREFIX).toString();
            attributes.addAttribute("", prefixDef, prefixDef, "", WCSCapsTransformer.XSI_URI);
            String locationAtt = new StringBuffer(WCSCapsTransformer.XSI_PREFIX).append(":schemaLocation").toString();
            String locationDef = ResponseUtils.buildSchemaURL((String)this.request.getBaseUrl(), (String)"wcs/1.1.1/wcsGetCapabilities.xsd");
            attributes.addAttribute("", locationAtt, locationAtt, "", locationDef);
            attributes.addAttribute("", "updateSequence", "updateSequence", "", String.valueOf(updateSequence));
            this.start("wcs:Capabilities", attributes);
            if (this.request.getSections() == null) {
                allSections = true;
                sections = Collections.emptyList();
            } else {
                sections = this.request.getSections().getSection();
                allSections = sections.contains("All");
            }
            HashSet<String> knownSections = new HashSet<String>(Arrays.asList("ServiceIdentification", "ServiceProvider", "OperationsMetadata", "Contents", "All"));
            for (String section : sections) {
                if (knownSections.contains(section)) continue;
                throw new WcsException("Unknown section " + section, WcsException.WcsExceptionCode.InvalidParameterValue, "Sections");
            }
            if (requestedUpdateSequence < updateSequence) {
                if (allSections || sections.contains("ServiceIdentification")) {
                    this.handleServiceIdentification();
                }
                if (allSections || sections.contains("ServiceProvider")) {
                    this.handleServiceProvider();
                }
                if (allSections || sections.contains("OperationsMetadata")) {
                    this.handleOperationsMetadata();
                }
                if (allSections || sections.contains("Contents")) {
                    this.handleContents();
                }
            }
            this.end("wcs:Capabilities");
        }

        private void handleServiceIdentification() {
            this.start("ows:ServiceIdentification");
            this.element("ows:Title", WCSCapsTransformer.this.wcs.getTitle());
            this.element("ows:Abstract", WCSCapsTransformer.this.wcs.getAbstract());
            this.handleKeywords(WCSCapsTransformer.this.wcs.getKeywords());
            this.element("ows:ServiceType", "WCS");
            this.element("ows:ServiceTypeVersion", "1.1.0");
            this.element("ows:ServiceTypeVersion", WCSCapsTransformer.CUR_VERSION);
            String fees = WCSCapsTransformer.this.wcs.getFees();
            if (fees == null || "".equals(fees)) {
                fees = "NONE";
            }
            this.element("ows:Fees", fees);
            String accessConstraints = WCSCapsTransformer.this.wcs.getAccessConstraints();
            if (accessConstraints == null || "".equals(accessConstraints)) {
                accessConstraints = "NONE";
            }
            this.element("ows:AccessConstraints", accessConstraints);
            this.end("ows:ServiceIdentification");
        }

        private void handleServiceProvider() {
            this.start("ows:ServiceProvider");
            GeoServerInfo gs = WCSCapsTransformer.this.wcs.getGeoServer().getGlobal();
            this.element("ows:ProviderName", gs.getContact().getContactOrganization());
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", gs.getOnlineResource());
            this.element("ows:ProviderSite", null, attributes);
            this.handleContact();
            this.end("ows:ServiceProvider");
        }

        private void handleOperationsMetadata() {
            this.start("ows:OperationsMetadata");
            this.handleOperation("GetCapabilities", null);
            this.handleOperation("DescribeCoverage", null);
            this.handleOperation("GetCoverage", (Map<String, List<String>>)new HashMap<String, List<String>>(){
                {
                    this.put("store", Arrays.asList("True", "False"));
                }
            });
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, "PostEncoding");
            this.start("ows:Constraint", attributes);
            this.start("ows:AllowedValues");
            this.element("ows:Value", "XML");
            this.end("ows:AllowedValues");
            this.end("ows:Constraint");
            this.end("ows:OperationsMetadata");
        }

        private void handleOperation(String capabilityName, Map<String, List<String>> parameters) {
            AttributesImpl attributes = new AttributesImpl();
            attributes.addAttribute(null, "name", "name", null, capabilityName);
            this.start("ows:Operation", attributes);
            String url = ResponseUtils.appendQueryString((String)ResponseUtils.buildURL((String)this.request.getBaseUrl(), (String)"wcs", null, (URLMangler.URLType)URLMangler.URLType.SERVICE), (String)"");
            this.start("ows:DCP");
            this.start("ows:HTTP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.element("ows:Get", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            attributes = new AttributesImpl();
            attributes.addAttribute("", "xlink:href", "xlink:href", "", url);
            this.start("ows:DCP");
            this.start("ows:HTTP");
            this.element("ows:Post", null, attributes);
            this.end("ows:HTTP");
            this.end("ows:DCP");
            if (parameters != null && !parameters.isEmpty()) {
                for (Map.Entry<String, List<String>> param : parameters.entrySet()) {
                    attributes = new AttributesImpl();
                    attributes.addAttribute("", "name", "name", "", param.getKey());
                    this.start("ows:Parameter", attributes);
                    this.start("ows:AllowedValues");
                    for (String value : param.getValue()) {
                        this.element("ows:Value", value);
                    }
                    this.end("ows:AllowedValues");
                    this.end("ows:Parameter");
                }
            }
            this.end("ows:Operation");
        }

        private void handleKeywords(List kwords) {
            this.start("ows:Keywords");
            if (kwords != null) {
                Iterator it = kwords.iterator();
                while (it.hasNext()) {
                    this.element("ows:Keyword", it.next().toString());
                }
            }
            this.end("ows:Keywords");
        }

        private void handleContact() {
            GeoServer gs = WCSCapsTransformer.this.wcs.getGeoServer();
            this.start("ows:ServiceContact");
            ContactInfo contact = gs.getGlobal().getContact();
            this.elementIfNotEmpty("ows:IndividualName", contact.getContactPerson());
            this.elementIfNotEmpty("ows:PositionName", contact.getContactPosition());
            this.start("ows:ContactInfo");
            this.start("ows:Phone");
            this.elementIfNotEmpty("ows:Voice", contact.getContactVoice());
            this.elementIfNotEmpty("ows:Facsimile", contact.getContactFacsimile());
            this.end("ows:Phone");
            this.start("ows:Address");
            this.elementIfNotEmpty("ows:DeliveryPoint", contact.getAddress());
            this.elementIfNotEmpty("ows:City", contact.getAddressCity());
            this.elementIfNotEmpty("ows:AdministrativeArea", contact.getAddressState());
            this.elementIfNotEmpty("ows:PostalCode", contact.getAddressPostalCode());
            this.elementIfNotEmpty("ows:Country", contact.getAddressCountry());
            this.elementIfNotEmpty("ows:ElectronicMailAddress", contact.getContactEmail());
            this.end("ows:Address");
            String or = gs.getGlobal().getOnlineResource();
            if (or != null && !"".equals(or.trim())) {
                AttributesImpl attributes = new AttributesImpl();
                attributes.addAttribute("", "xlink:href", "xlink:href", "", or);
                this.start("ows:OnlineResource", attributes);
                this.end("OnlineResource");
            }
            this.end("ows:ContactInfo");
            this.end("ows:ServiceContact");
        }

        private void handleEnvelope(ReferencedEnvelope envelope) {
            this.start("ows:WGS84BoundingBox");
            this.element("ows:LowerCorner", new StringBuffer(Double.toString(envelope.getLowerCorner().getOrdinate(0))).append(" ").append(envelope.getLowerCorner().getOrdinate(1)).toString());
            this.element("ows:UpperCorner", new StringBuffer(Double.toString(envelope.getUpperCorner().getOrdinate(0))).append(" ").append(envelope.getUpperCorner().getOrdinate(1)).toString());
            this.end("ows:WGS84BoundingBox");
        }

        private void handleContents() {
            this.start("wcs:Contents");
            List coverages = WCSCapsTransformer.this.wcs.getGeoServer().getCatalog().getCoverages();
            Iterator it = coverages.iterator();
            while (it.hasNext()) {
                CoverageInfo cv = (CoverageInfo)it.next();
                if (cv.enabled()) continue;
                it.remove();
            }
            if (this.request.getNamespace() != null) {
                String namespace = this.request.getNamespace();
                Iterator it2 = coverages.iterator();
                while (it2.hasNext()) {
                    CoverageInfo cv = (CoverageInfo)it2.next();
                    if (namespace.equals(cv.getStore().getWorkspace().getName())) continue;
                    it2.remove();
                }
            }
            Collections.sort(coverages, new CoverageInfoLabelComparator());
            for (CoverageInfo cv : coverages) {
                if (!cv.enabled()) continue;
                this.handleCoverageSummary(cv);
            }
            this.end("wcs:Contents");
        }

        private void handleCoverageSummary(CoverageInfo cv) {
            this.start("wcs:CoverageSummary");
            this.elementIfNotEmpty("ows:Title", cv.getTitle());
            this.elementIfNotEmpty("ows:Abstract", cv.getDescription());
            this.handleKeywords(cv.getKeywords());
            this.handleMetadataLinks(cv.getMetadataLinks(), "simple");
            this.handleEnvelope(cv.getLatLonBoundingBox());
            this.element("wcs:Identifier", cv.getName());
            this.end("wcs:CoverageSummary");
        }

        private void handleMetadataLinks(List<MetadataLinkInfo> links, String linkType) {
            for (MetadataLinkInfo mdl : links) {
                if (mdl == null) continue;
                AttributesImpl attributes = new AttributesImpl();
                if (mdl.getAbout() != null && mdl.getAbout() != "") {
                    attributes.addAttribute("", "about", "about", "", mdl.getAbout());
                }
                if (mdl.getMetadataType() != null && mdl.getMetadataType() != "") {
                    attributes.addAttribute("", "xlink:type", "xlink:type", "", linkType);
                }
                if (attributes.getLength() <= 0) continue;
                this.element("ows:Metadata", null, attributes);
            }
        }

        private void elementIfNotEmpty(String elementName, String content) {
            if (content != null && !"".equals(content.trim())) {
                this.element(elementName, content);
            }
        }
    }
}

