/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs;

import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import javax.xml.namespace.QName;
import junit.framework.Test;
import org.custommonkey.xmlunit.XMLAssert;
import org.geoserver.catalog.Catalog;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSTestSupport;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class AliasTest
extends WFSTestSupport {
    private Catalog catalog;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new AliasTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        this.catalog = (Catalog)applicationContext.getBean("catalog");
    }

    protected void populateDataDirectory(MockData dataDirectory) throws Exception {
        this.addAliasedType(dataDirectory, MockData.FIFTEEN, "ft15");
    }

    private void addAliasedType(MockData dataDirectory, QName name, String alias) throws IOException {
        URL properties = MockData.class.getResource(name.getLocalPart() + ".properties");
        URL style = MockData.class.getResource(name.getLocalPart() + ".sld");
        String styleName = null;
        HashMap<String, String> extra = new HashMap<String, String>();
        if (style != null) {
            styleName = name.getLocalPart();
            dataDirectory.addStyle(styleName, style);
            extra.put("style", styleName);
        }
        extra.put("alias", alias);
        dataDirectory.addPropertiesType(name, properties, extra);
    }

    public void testAliasFifteen() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:ft15&version=1.0.0&service=wfs");
        AliasTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        AliasTest.assertTrue((doc.getElementsByTagName("gml:featureMember").getLength() > 0 ? 1 : 0) != 0);
        AliasTest.assertTrue((doc.getElementsByTagName("cdf:ft15").getLength() > 0 ? 1 : 0) != 0);
    }

    public void testGetByFeatureId() throws Exception {
        Document doc = this.getAsDOM("wfs?request=GetFeature&typename=cdf:ft15&version=1.0.0&featureId=ft15.1");
        AliasTest.assertEquals((String)"wfs:FeatureCollection", (String)doc.getDocumentElement().getNodeName());
        AliasTest.assertEquals((int)1, (int)doc.getElementsByTagName("gml:featureMember").getLength());
        NodeList features = doc.getElementsByTagName("cdf:ft15");
        AliasTest.assertEquals((int)1, (int)features.getLength());
        Node feature = features.item(0);
        Node fidNode = feature.getAttributes().getNamedItem("fid");
        AliasTest.assertEquals((String)"ft15.1", (String)fidNode.getTextContent());
    }

    public void testDescribeFeatureType() throws Exception {
        Document doc = this.getAsDOM("wfs?request=DescribeFeatureType&typename=cdf:ft15&version=1.0.0");
        this.print(doc);
        AliasTest.assertEquals((String)"xsd:schema", (String)doc.getDocumentElement().getNodeName());
        XMLAssert.assertXpathEvaluatesTo((String)"ft15", (String)"/xs:schema/xs:element/@name", (Document)doc);
    }
}

