/*
 * Decompiled with CFR 0.152.
 */
package org.geoserver.wfs.v1_1;

import java.util.StringTokenizer;
import junit.framework.Test;
import org.geoserver.config.ServiceInfo;
import org.geoserver.data.test.MockData;
import org.geoserver.test.OneTimeSetupTest;
import org.geoserver.wfs.WFSInfo;
import org.geoserver.wfs.WFSTestSupport;
import org.geotools.referencing.CRS;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WFSReprojectionTest
extends WFSTestSupport {
    private static final String TARGET_CRS_CODE = "EPSG:900913";
    MathTransform tx;

    public static Test suite() {
        return new OneTimeSetupTest.OneTimeTestSetup((OneTimeSetupTest)new WFSReprojectionTest());
    }

    protected void setUpInternal() throws Exception {
        super.setUpInternal();
        CoordinateReferenceSystem epsgTarget = CRS.decode((String)TARGET_CRS_CODE);
        CoordinateReferenceSystem epsg32615 = CRS.decode((String)"urn:x-ogc:def:crs:EPSG:6.11.2:32615");
        this.tx = CRS.findMathTransform((CoordinateReferenceSystem)epsg32615, (CoordinateReferenceSystem)epsgTarget);
        WFSInfo wfs = this.getWFS();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
    }

    public void testGetFeatureGet() throws Exception {
        Document dom1 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart());
        this.print(dom1);
        Document dom2 = this.getAsDOM("wfs?request=getfeature&service=wfs&version=1.0.0&typename=" + MockData.POLYGONS.getLocalPart() + "&srsName=" + TARGET_CRS_CODE);
        this.print(dom2);
        this.runTest(dom1, dom2);
    }

    public void testGetFeaturePost() throws Exception {
        String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\"> " + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom1 = this.postAsDOM("wfs", xml);
        xml = "<wfs:GetFeature service=\"WFS\" version=\"1.0.0\" xmlns:cdf=\"http://www.opengis.net/cite/data\" xmlns:ogc=\"http://www.opengis.net/ogc\" xmlns:wfs=\"http://www.opengis.net/wfs\" > <wfs:Query srsName=\"EPSG:900913\" typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\"> " + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom2 = this.postAsDOM("wfs", xml);
        this.runTest(dom1, dom2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeatureWithProjectedBoxGet() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String q = "wfs?request=getfeature&service=wfs&version=1.1&typeName=" + MockData.POLYGONS.getLocalPart();
            Document dom = this.getAsDOM(q);
            Element envelope = this.getFirstElementByTagName(dom, "gml:Envelope");
            String lc = this.getFirstElementByTagName(envelope, "gml:lowerCorner").getFirstChild().getNodeValue();
            String uc = this.getFirstElementByTagName(envelope, "gml:upperCorner").getFirstChild().getNodeValue();
            double[] c = new double[]{Double.parseDouble(lc.split(" ")[0]), Double.parseDouble(lc.split(" ")[1]), Double.parseDouble(uc.split(" ")[0]), Double.parseDouble(uc.split(" ")[1])};
            double[] cr = new double[4];
            this.tx.transform(c, 0, cr, 0, 2);
            q = q + "&bbox=" + cr[0] + "," + cr[1] + "," + cr[2] + "," + cr[3] + "," + TARGET_CRS_CODE;
            dom = this.getAsDOM(q);
            WFSReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName(MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart()).getLength());
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testGetFeatureWithProjectedBoxPost() throws Exception {
        WFSInfo wfs = this.getWFS();
        boolean oldFeatureBounding = wfs.isFeatureBounding();
        wfs.setFeatureBounding(true);
        this.getGeoServer().save((ServiceInfo)wfs);
        try {
            String q = "wfs?request=getfeature&service=wfs&version=1.1&typeName=" + MockData.POLYGONS.getLocalPart();
            Document dom = this.getAsDOM(q);
            Element envelope = this.getFirstElementByTagName(dom, "gml:Envelope");
            String lc = this.getFirstElementByTagName(envelope, "gml:lowerCorner").getFirstChild().getNodeValue();
            String uc = this.getFirstElementByTagName(envelope, "gml:upperCorner").getFirstChild().getNodeValue();
            double[] c = new double[]{Double.parseDouble(lc.split(" ")[0]), Double.parseDouble(lc.split(" ")[1]), Double.parseDouble(uc.split(" ")[0]), Double.parseDouble(uc.split(" ")[1])};
            double[] cr = new double[4];
            this.tx.transform(c, 0, cr, 0, 2);
            String xml = "<wfs:GetFeature service=\"WFS\" version=\"1.1.0\" xmlns:" + MockData.POLYGONS.getPrefix() + "=\"" + MockData.POLYGONS.getNamespaceURI() + "\"" + " xmlns:ogc=\"http://www.opengis.net/ogc\" " + " xmlns:gml=\"http://www.opengis.net/gml\" " + " xmlns:wfs=\"http://www.opengis.net/wfs\" " + "> " + "<wfs:Query typeName=\"" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "\">" + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "<ogc:Filter>" + "<ogc:BBOX>" + "<ogc:PropertyName>polygonProperty</ogc:PropertyName>" + "<gml:Envelope srsName=\"" + TARGET_CRS_CODE + "\">" + "<gml:lowerCorner>" + cr[0] + " " + cr[1] + "</gml:lowerCorner>" + "<gml:upperCorner>" + cr[2] + " " + cr[3] + "</gml:upperCorner>" + "</gml:Envelope>" + "</ogc:BBOX>" + "</ogc:Filter>" + "</wfs:Query> " + "</wfs:GetFeature>";
            dom = this.postAsDOM("wfs", xml);
            WFSReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName(MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart()).getLength());
        }
        finally {
            wfs.setFeatureBounding(oldFeatureBounding);
            this.getGeoServer().save((ServiceInfo)wfs);
        }
    }

    private void runTest(Document dom1, Document dom2) throws Exception {
        Element box = this.getFirstElementByTagName(dom1.getDocumentElement(), "gml:Box");
        Element coordinates = this.getFirstElementByTagName(box, "gml:coordinates");
        double[] d1 = this.coordinates(coordinates.getFirstChild().getNodeValue());
        box = this.getFirstElementByTagName(dom2.getDocumentElement(), "gml:Box");
        coordinates = this.getFirstElementByTagName(box, "gml:coordinates");
        double[] d2 = this.coordinates(coordinates.getFirstChild().getNodeValue());
        double[] d3 = new double[d1.length];
        this.tx.transform(d1, 0, d3, 0, d1.length / 2);
        for (int i = 0; i < d2.length; ++i) {
            WFSReprojectionTest.assertEquals((double)d2[i], (double)d3[i], (double)0.001);
        }
    }

    private double[] coordinates(String string) {
        StringTokenizer st = new StringTokenizer(string, " ");
        double[] coordinates = new double[st.countTokens() * 2];
        int i = 0;
        while (st.hasMoreTokens()) {
            String tuple = st.nextToken();
            coordinates[i++] = Double.parseDouble(tuple.split(",")[0]);
            coordinates[i++] = Double.parseDouble(tuple.split(",")[1]);
        }
        return coordinates;
    }

    public void testFilterReprojection() throws Exception {
        String xml = "<wfs:GetFeature service='WFS' version='1.0.0' xmlns:cdf='http://www.opengis.net/cite/data' xmlns:ogc='http://www.opengis.net/ogc' xmlns:wfs='http://www.opengis.net/wfs' > <wfs:Query typeName='" + MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart() + "' " + " srsName='" + TARGET_CRS_CODE + "'> " + "> " + "<wfs:PropertyName>cgf:polygonProperty</wfs:PropertyName> " + "<ogc:Filter>" + "<ogc:Intersects>" + "<ogc:PropertyName>polygonProperty</ogc:PropertyName>" + "<gml:Point xmlns:gml='http://www.opengis.net/gml'>" + "<gml:coordinates decimal='.' cs=',' ts=' '>-1.035246176730227E7,504135.14926478104</gml:coordinates>" + "</gml:Point>" + "</ogc:Intersects>" + "</ogc:Filter>" + "</wfs:Query> " + "</wfs:GetFeature>";
        Document dom = this.postAsDOM("wfs", xml);
        WFSReprojectionTest.assertEquals((int)1, (int)dom.getElementsByTagName(MockData.POLYGONS.getPrefix() + ":" + MockData.POLYGONS.getLocalPart()).getLength());
    }
}

