/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.geotools.arcsde.data.ArcSdeFeatureSource;
import org.geotools.arcsde.data.FeatureTypeInfo;
import org.geotools.data.ResourceInfo;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.util.InternationalString;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArcSdeResourceInfo
implements ResourceInfo {
    private FeatureTypeInfo info;
    private ArcSdeFeatureSource source;
    private Set<String> cachedKeywords;
    private URI namespace;

    ArcSdeResourceInfo(FeatureTypeInfo info, ArcSdeFeatureSource source) {
        this.info = info;
        this.source = source;
        String nsUri = info.getFeatureType().getName().getNamespaceURI();
        if (nsUri != null) {
            this.namespace = URI.create(nsUri);
        }
    }

    public synchronized ReferencedEnvelope getBounds() {
        ReferencedEnvelope bounds;
        try {
            bounds = this.source.getBounds();
        }
        catch (IOException e) {
            CoordinateReferenceSystem crs = this.info.getFeatureType().getCoordinateReferenceSystem();
            bounds = new ReferencedEnvelope(crs);
        }
        return bounds;
    }

    public CoordinateReferenceSystem getCRS() {
        return this.info.getFeatureType().getCoordinateReferenceSystem();
    }

    public String getDescription() {
        return null;
    }

    public synchronized Set<String> getKeywords() {
        if (this.cachedKeywords == null) {
            this.cachedKeywords = new HashSet<String>();
            this.cachedKeywords.add("ArcSDE");
            this.cachedKeywords.add(this.info.getFeatureTypeName());
            if (this.info.isInProcessView()) {
                this.cachedKeywords.add("in-process view");
            }
            if (this.info.isVersioned()) {
                this.cachedKeywords.add("versioned");
            }
            if (this.info.isView()) {
                this.cachedKeywords.add("registered view");
            }
            if (this.info.isWritable()) {
                this.cachedKeywords.add("writable");
            }
        }
        return new HashSet<String>(this.cachedKeywords);
    }

    public String getName() {
        return this.info.getFeatureTypeName();
    }

    public URI getSchema() {
        return this.namespace;
    }

    public String getTitle() {
        InternationalString description = this.info.getFeatureType().getDescription();
        return description == null ? this.info.getFeatureTypeName() : description.toString();
    }

    public boolean isVersioned() {
        return this.info.isVersioned();
    }

    public boolean isView() {
        return this.info.isView();
    }

    public boolean isInProcessView() {
        return this.info.isInProcessView();
    }
}

