/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeRelease;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.BasePoolableObjectFactory;
import org.apache.commons.pool.ObjectPool;
import org.apache.commons.pool.PoolableObjectFactory;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ArcSDEPooledConnection;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.data.DataSourceException;
import org.geotools.util.logging.Logging;

public class ArcSDEConnectionPool {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.pool");
    protected static final Level INFO_LOG_LEVEL = Level.WARNING;
    public static final int DEFAULT_CONNECTIONS = 2;
    public static final int DEFAULT_MAX_CONNECTIONS = 10;
    public static final int DEFAULT_MAX_WAIT_TIME = 2000;
    private SeConnectionFactory seConnectionFactory;
    private ArcSDEConnectionConfig config;
    private ObjectPool pool;

    protected ArcSDEConnectionPool(ArcSDEConnectionConfig config) throws DataSourceException {
        if (config == null) {
            throw new NullPointerException("parameter config can't be null");
        }
        this.config = config;
        LOGGER.fine("populating ArcSDE connection pool");
        this.seConnectionFactory = new SeConnectionFactory(this.config);
        int minConnections = config.getMinConnections();
        int maxConnections = config.getMaxConnections();
        byte exhaustedAction = 1;
        long maxWait = config.getConnTimeOut().longValue();
        this.pool = new GenericObjectPool((PoolableObjectFactory)this.seConnectionFactory, maxConnections, exhaustedAction, maxWait, true, true);
        LOGGER.info("Created ArcSDE connection pool for " + config);
        ArcSDEPooledConnection[] preload = new ArcSDEPooledConnection[minConnections];
        try {
            int i;
            for (i = 0; i < minConnections; ++i) {
                preload[i] = (ArcSDEPooledConnection)((Object)this.pool.borrowObject());
                if (i != 0) continue;
                SeRelease seRelease = preload[i].getRelease();
                String sdeDesc = seRelease.getDesc();
                int major = seRelease.getMajor();
                int minor = seRelease.getMinor();
                int bugFix = seRelease.getBugFix();
                String desc = "ArcSDE " + major + "." + minor + "." + bugFix + " " + sdeDesc;
                LOGGER.info("Connected to " + desc);
            }
            for (i = 0; i < minConnections; ++i) {
                this.pool.returnObject((Object)preload[i]);
            }
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "can't connect to " + config, e);
            throw new DataSourceException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getPoolSize() {
        ObjectPool objectPool = this.pool;
        synchronized (objectPool) {
            return this.pool.getNumActive() + this.pool.getNumIdle();
        }
    }

    public void close() {
        if (this.pool != null) {
            try {
                this.pool.close();
                this.pool = null;
                LOGGER.fine("SDE connection pool closed. ");
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Closing pool: " + e.getMessage(), e);
            }
        }
    }

    public boolean isClosed() {
        return this.pool == null;
    }

    protected void finalize() {
        this.close();
    }

    public synchronized int getAvailableCount() {
        return this.pool.getNumIdle();
    }

    public synchronized int getInUseCount() {
        return this.pool.getNumActive();
    }

    public ArcSDEPooledConnection getConnection() throws DataSourceException, UnavailableConnectionException {
        if (this.pool == null) {
            throw new IllegalStateException("The ConnectionPool has been closed.");
        }
        try {
            ArcSDEPooledConnection connection = (ArcSDEPooledConnection)((Object)this.pool.borrowObject());
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer((Object)((Object)connection) + " out of connection pool");
            }
            connection.markActive();
            return connection;
        }
        catch (NoSuchElementException e) {
            LOGGER.log(Level.WARNING, "Out of connections: " + e.getMessage(), e);
            throw new UnavailableConnectionException(this.pool.getNumActive(), this.config);
        }
        catch (SeException se) {
            LOGGER.log(Level.WARNING, "ArcSDE error getting connection: " + se.getSeError().getErrDesc(), se);
            throw new DataSourceException("ArcSDE Error Message: " + se.getSeError().getErrDesc(), (Throwable)se);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Unknown problem getting connection: " + e.getMessage(), e);
            throw new DataSourceException("Unknown problem fetching connection from connection pool", (Throwable)e);
        }
    }

    public synchronized void markConnectionAsFailed(ArcSDEPooledConnection conn) {
        LOGGER.warning("ArcSDE connection '" + (Object)((Object)conn) + "' has been marked as failed.  Current pool state is " + this.getAvailableCount() + " avail/" + this.getPoolSize() + " total");
        this.seConnectionFactory.markObjectInvalid((Object)conn);
    }

    public List getAvailableLayerNames() throws DataSourceException {
        ArcSDEPooledConnection conn = null;
        LinkedList<String> layerNames = new LinkedList<String>();
        try {
            conn = this.getConnection();
            Iterator it = conn.getLayers().iterator();
            while (it.hasNext()) {
                layerNames.add(((SeLayer)it.next()).getQualifiedName());
            }
        }
        catch (SeException ex) {
            throw new DataSourceException("Error querying the layers list" + ex.getSeError().getSdeError() + " (" + ex.getSeError().getErrDesc() + ") ", (Throwable)ex);
        }
        catch (UnavailableConnectionException ex) {
            throw new DataSourceException("No free connection found to query the layers list", (Throwable)ex);
        }
        finally {
            if (conn != null) {
                conn.close();
            }
        }
        return layerNames;
    }

    public ArcSDEConnectionConfig getConfig() {
        return this.config;
    }

    public String toString() {
        StringBuffer ret = new StringBuffer();
        ret.append("[ACTIVE: ");
        ret.append(this.pool.getNumActive() + "/" + ((GenericObjectPool)this.pool).getMaxActive());
        ret.append("  INACTIVE: ");
        ret.append(this.pool.getNumIdle() + "/" + ((GenericObjectPool)this.pool).getMaxIdle() + "]");
        return ret.toString();
    }

    class SeConnectionFactory
    extends BasePoolableObjectFactory {
        private ArcSDEConnectionConfig config;
        private List invalidConnections = new ArrayList(2);

        public SeConnectionFactory(ArcSDEConnectionConfig config) {
            this.config = config;
        }

        public void markObjectInvalid(Object o) {
            this.invalidConnections.add((SeConnection)o);
        }

        public Object makeObject() throws IOException {
            NegativeArraySizeException cause = null;
            for (int i = 0; i < 3; ++i) {
                try {
                    ArcSDEPooledConnection seConn = new ArcSDEPooledConnection(ArcSDEConnectionPool.this.pool, this.config);
                    return seConn;
                }
                catch (NegativeArraySizeException nase) {
                    LOGGER.warning("Strange failed ArcSDE connection error.  Trying again (try " + (i + 1) + " of 3)");
                    cause = nase;
                    continue;
                }
                catch (SeException e) {
                    throw new ArcSdeException(e);
                }
            }
            throw new DataSourceException("Couldn't create ArcSDEPooledConnection because of strange SDE internal exception.  Tried 3 times, giving up.", cause);
        }

        public void activateObject(Object obj) {
            ArcSDEPooledConnection conn = (ArcSDEPooledConnection)((Object)obj);
            conn.markActive();
            LOGGER.finest("activating connection " + obj);
        }

        public void passivateObject(Object obj) {
            LOGGER.finest("passivating connection " + obj);
            ArcSDEPooledConnection conn = (ArcSDEPooledConnection)((Object)obj);
            conn.markInactive();
        }

        public boolean validateObject(Object obj) {
            boolean valid;
            ArcSDEPooledConnection conn = (ArcSDEPooledConnection)((Object)obj);
            boolean bl = valid = !conn.isClosed();
            if (valid) {
                if (this.invalidConnections.contains(obj)) {
                    valid = false;
                }
                try {
                    LOGGER.finest("Validating SDE Connection");
                    String user = conn.getUser();
                    LOGGER.finer("Connection validated, returned user " + user);
                }
                catch (SeException e) {
                    LOGGER.info("Can't validate SeConnection, discarding it: " + (Object)((Object)conn));
                    valid = false;
                }
            }
            return valid;
        }

        public void destroyObject(Object obj) {
            ArcSDEPooledConnection conn = (ArcSDEPooledConnection)((Object)obj);
            conn.destroy();
        }
    }
}

