/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.gce;

import com.esri.sde.sdk.client.SDEPoint;
import com.esri.sde.sdk.client.SeColumnDefinition;
import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeCoordinateReference;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeExtent;
import com.esri.sde.sdk.client.SeQuery;
import com.esri.sde.sdk.client.SeRaster;
import com.esri.sde.sdk.client.SeRasterAttr;
import com.esri.sde.sdk.client.SeRasterBand;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeRow;
import com.esri.sde.sdk.client.SeSqlConstruct;
import com.esri.sde.sdk.client.SeTable;
import java.awt.geom.Point2D;
import java.awt.image.DataBuffer;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferUShort;
import java.awt.image.IndexColorModel;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.arcsde.ArcSdeException;
import org.geotools.arcsde.data.ArcSDEDataStoreConfig;
import org.geotools.arcsde.gce.ArcSDEGridCoverage2DReaderJAI;
import org.geotools.arcsde.gce.CompressionType;
import org.geotools.arcsde.gce.InterleaveType;
import org.geotools.arcsde.gce.InterpolationType;
import org.geotools.arcsde.gce.RasterBandInfo;
import org.geotools.arcsde.gce.RasterCellType;
import org.geotools.arcsde.gce.RasterDatasetInfo;
import org.geotools.arcsde.gce.RasterInfo;
import org.geotools.arcsde.gce.RasterReaderFactory;
import org.geotools.arcsde.gce.RasterUtils;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.arcsde.session.ArcSDEConnectionPool;
import org.geotools.arcsde.session.ArcSDEConnectionPoolFactory;
import org.geotools.arcsde.session.ArcSDEPooledConnection;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.arcsde.util.ArcSDEUtils;
import org.geotools.coverage.grid.io.AbstractGridCoverage2DReader;
import org.geotools.coverage.grid.io.AbstractGridFormat;
import org.geotools.coverage.grid.io.imageio.GeoToolsWriteParams;
import org.geotools.data.DataSourceException;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.parameter.DefaultParameterDescriptorGroup;
import org.geotools.parameter.ParameterGroup;
import org.geotools.referencing.crs.DefaultEngineeringCRS;
import org.geotools.util.logging.Logging;
import org.opengis.coverage.grid.Format;
import org.opengis.coverage.grid.GridCoverageWriter;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ArcSDERasterFormat
extends AbstractGridFormat
implements Format {
    protected static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.gce");
    private final Map<String, RasterDatasetInfo> rasterInfos = new WeakHashMap<String, RasterDatasetInfo>();
    private final Map<String, ArcSDEDataStoreConfig> connectionConfigs = new WeakHashMap<String, ArcSDEDataStoreConfig>();
    private static final ArcSDERasterFormat instance = new ArcSDERasterFormat();
    private boolean statisticsMandatory = true;

    private ArcSDERasterFormat() {
        this.setInfo();
    }

    public static ArcSDERasterFormat getInstance() {
        return instance;
    }

    private void setInfo() {
        HashMap<String, String> info = new HashMap<String, String>();
        info.put("name", "ArcSDE Raster");
        info.put("description", "ArcSDE Raster Format");
        info.put("vendor", "Geotools");
        info.put("docURL", "");
        info.put("version", GeoTools.getVersion().toString());
        this.mInfo = info;
        this.readParameters = new ParameterGroup((ParameterDescriptorGroup)new DefaultParameterDescriptorGroup(this.mInfo, new GeneralParameterDescriptor[]{READ_GRIDGEOMETRY2D, OVERVIEW_POLICY}));
    }

    public AbstractGridCoverage2DReader getReader(Object source) {
        return this.getReader(source, null);
    }

    public AbstractGridCoverage2DReader getReader(Object source, Hints hints) {
        try {
            if (source == null) {
                throw new DataSourceException("No source set to read this coverage.");
            }
            String coverageUrl = this.parseCoverageUrl(source);
            ArcSDEConnectionConfig connectionConfig = this.getConnectionConfig(coverageUrl);
            ArcSDEConnectionPool connectionPool = this.setupConnectionPool(connectionConfig);
            RasterDatasetInfo rasterInfo = this.getRasterInfo(coverageUrl, connectionPool);
            RasterReaderFactory rasterReaderFactory = new RasterReaderFactory(connectionPool);
            return new ArcSDEGridCoverage2DReaderJAI(this, rasterReaderFactory, rasterInfo, hints);
        }
        catch (IOException dse) {
            LOGGER.log(Level.SEVERE, "Unable to creata ArcSDERasterReader for " + source + ".", dse);
            throw new RuntimeException(dse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RasterDatasetInfo getRasterInfo(String coverageUrl, ArcSDEConnectionPool connectionPool) throws IOException {
        RasterDatasetInfo rasterInfo = this.rasterInfos.get(coverageUrl);
        if (rasterInfo == null) {
            Map<String, RasterDatasetInfo> map = this.rasterInfos;
            synchronized (map) {
                rasterInfo = this.rasterInfos.get(coverageUrl);
                if (rasterInfo == null) {
                    ArcSDEPooledConnection scon;
                    try {
                        scon = connectionPool.getConnection();
                    }
                    catch (UnavailableConnectionException e) {
                        throw new DataSourceException((Throwable)e);
                    }
                    try {
                        rasterInfo = this.gatherCoverageMetadata(scon, coverageUrl);
                        this.rasterInfos.put(coverageUrl, rasterInfo);
                    }
                    finally {
                        if (!scon.isPassivated()) {
                            scon.close();
                        }
                    }
                }
            }
        }
        return rasterInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ArcSDEConnectionConfig getConnectionConfig(String coverageUrl) {
        ArcSDEDataStoreConfig sdeConfig = this.connectionConfigs.get(coverageUrl);
        if (sdeConfig == null) {
            Map<String, ArcSDEDataStoreConfig> map = this.connectionConfigs;
            synchronized (map) {
                sdeConfig = this.connectionConfigs.get(coverageUrl);
                if (sdeConfig == null) {
                    sdeConfig = ArcSDERasterFormat.sdeURLToConnectionConfig(new StringBuffer(coverageUrl));
                    this.connectionConfigs.put(coverageUrl, sdeConfig);
                }
            }
        }
        return sdeConfig.getSessionConfig();
    }

    public GridCoverageWriter getWriter(Object destination) {
        return null;
    }

    public boolean accepts(Object input) {
        StringBuffer url;
        if (input instanceof File) {
            url = new StringBuffer(((File)input).getPath());
        } else if (input instanceof String) {
            url = new StringBuffer((String)input);
        } else {
            return false;
        }
        try {
            ArcSDERasterFormat.sdeURLToConnectionConfig(url);
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public String getName() {
        return (String)this.mInfo.get("name");
    }

    public String getDescription() {
        return (String)this.mInfo.get("description");
    }

    public String getVendor() {
        return (String)this.mInfo.get("vendor");
    }

    public String getDocURL() {
        return (String)this.mInfo.get("docURL");
    }

    public String getVersion() {
        return (String)this.mInfo.get("version");
    }

    public GeoToolsWriteParams getDefaultImageIOWriteParameters() {
        throw new UnsupportedOperationException("ArcSDE Rasters are read only for now.");
    }

    private String parseCoverageUrl(Object input) {
        String coverageUrl;
        if (input instanceof String) {
            coverageUrl = (String)input;
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("connecting to ArcSDE Raster: " + coverageUrl);
            }
        } else if (input instanceof File) {
            coverageUrl = ((File)input).getPath();
            if (LOGGER.isLoggable(Level.FINE)) {
                LOGGER.fine("connectiong via file-hack to ArcSDE Raster: " + coverageUrl);
            }
        } else {
            throw new IllegalArgumentException("Unsupported input type: " + input.getClass());
        }
        return coverageUrl;
    }

    private ArcSDEConnectionPool setupConnectionPool(ArcSDEConnectionConfig sdeConfig) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Getting ArcSDE connection pool for " + sdeConfig);
        }
        ArcSDEConnectionPool connectionPool = ArcSDEConnectionPoolFactory.getInstance().createPool(sdeConfig);
        return connectionPool;
    }

    public static ArcSDEDataStoreConfig sdeURLToConnectionConfig(StringBuffer sdeUrl) {
        String sdeHost;
        int sdePort;
        if (sdeUrl.indexOf("sde:/") == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName -- Got " + sdeUrl);
        }
        if (sdeUrl.indexOf("sde://") == -1) {
            sdeUrl.delete(0, 5);
        } else {
            sdeUrl.delete(0, 6);
        }
        int idx = sdeUrl.indexOf(":");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdeUser = sdeUrl.substring(0, idx);
        sdeUrl.delete(0, idx);
        idx = sdeUrl.indexOf("@");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdePass = sdeUrl.substring(1, idx);
        sdeUrl.delete(0, idx);
        idx = sdeUrl.indexOf(":");
        if (idx == -1) {
            sdePort = 5151;
            idx = sdeUrl.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
            }
            sdeHost = sdeUrl.substring(1, idx).toString();
            sdeUrl.delete(0, idx);
        } else {
            sdeHost = sdeUrl.substring(1, idx).toString();
            sdeUrl.delete(0, idx);
            idx = sdeUrl.indexOf("/");
            if (idx == -1) {
                throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
            }
            sdePort = Integer.parseInt(sdeUrl.substring(1, idx).toString());
            sdeUrl.delete(0, idx);
        }
        idx = sdeUrl.indexOf("#");
        if (idx == -1) {
            throw new IllegalArgumentException("ArcSDE Raster URL must be of the form sde://user:pass@sdehost:port/[dbname]#rasterTableName");
        }
        String sdeDBName = sdeUrl.substring(1, idx).toString();
        sdeUrl.delete(0, idx);
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("dbtype", "arcsde");
        params.put("server", sdeHost);
        params.put("port", String.valueOf(sdePort));
        params.put("instance", sdeDBName);
        params.put("user", sdeUser);
        params.put("password", sdePass);
        params.put("pool.minConnections", String.valueOf(2));
        params.put("pool.maxConnections", String.valueOf(10));
        params.put("pool.timeOut", String.valueOf(2000));
        return new ArcSDEDataStoreConfig(params);
    }

    private RasterDatasetInfo gatherCoverageMetadata(ArcSDEPooledConnection scon, String coverageUrl) throws IOException {
        int bitsPerSample;
        SeRasterBand sampleBand;
        long rasterColumnId;
        SeRasterColumn rasterColumn;
        LOGGER.fine("Gathering raster dataset metadata for " + coverageUrl);
        String sdeUrl = coverageUrl;
        if (sdeUrl.indexOf(";") != -1) {
            sdeUrl = sdeUrl.substring(0, sdeUrl.indexOf(";"));
        }
        String rasterTable = sdeUrl.substring(sdeUrl.indexOf("#") + 1);
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.fine("Building ArcSDEGridCoverageReader2D for " + rasterTable);
        }
        String[] rasterColumns = this.getRasterColumns(scon, rasterTable);
        ArrayList<RasterInfo> rastersLayoutInfo = new ArrayList<RasterInfo>();
        List<SeRasterAttr> rasterAttributes = this.getSeRasterAttr(scon, rasterTable, rasterColumns);
        if (rasterAttributes.size() == 0) {
            throw new IllegalArgumentException("Table " + rasterTable + " contains no raster datasets");
        }
        try {
            SeRasterAttr ratt = rasterAttributes.get(0);
            rasterColumn = new SeRasterColumn((SeConnection)scon, ratt.getRasterColumnId());
            rasterColumnId = rasterColumn.getID().longValue();
            sampleBand = ratt.getBands()[0];
            bitsPerSample = RasterCellType.valueOf(ratt.getPixelType()).getBitsPerSample();
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        SeCoordinateReference seCoordRef = rasterColumn.getCoordRef();
        if (seCoordRef == null) {
            throw new IllegalArgumentException(rasterTable + " has no coordinate reference system set");
        }
        LOGGER.finer("Looking CRS for raster column " + rasterTable);
        CoordinateReferenceSystem coverageCrs = ArcSDEUtils.findCompatibleCRS(seCoordRef);
        if (DefaultEngineeringCRS.CARTESIAN_2D == coverageCrs) {
            LOGGER.warning("Raster " + rasterTable + " has not CRS set, using DefaultEngineeringCRS.CARTESIAN_2D");
        }
        Map<Long, IndexColorModel> rastersColorMaps = sampleBand.hasColorMap() ? this.loadColorMaps(rasterColumnId, bitsPerSample, scon) : Collections.emptyMap();
        try {
            for (SeRasterAttr rAtt : rasterAttributes) {
                LOGGER.fine("Gathering raster metadata for " + rasterTable + " raster " + rAtt.getRasterId().longValue());
                if (rAtt.getMaxLevel() == 0) {
                    throw new IllegalArgumentException("Raster cotains no pyramid levels, we don't support non pyramid rasters");
                }
                if (rAtt.getNumBands() == 0) {
                    throw new IllegalArgumentException("Raster " + rAtt.getRasterId().longValue() + " in " + rasterTable + " contains no raster attribtues");
                }
                if (this.statisticsMandatory && !rAtt.getBandInfo(1).hasStats()) {
                    throw new IllegalArgumentException(rasterTable + " has no statistics generated (or not all it's rasters have). " + "Please use sderaster -o stats to create them before use");
                }
                RasterInfo rasterInfo = new RasterInfo(rAtt, coverageCrs);
                rastersLayoutInfo.add(rasterInfo);
                GeneralEnvelope originalEnvelope = this.calculateOriginalEnvelope(rAtt, coverageCrs);
                rasterInfo.setOriginalEnvelope(originalEnvelope);
                List<RasterBandInfo> bands = this.setUpBandInfo(scon, rAtt, rastersColorMaps);
                rasterInfo.setBands(bands);
                if (!LOGGER.isLoggable(Level.FINER)) continue;
                LOGGER.finer("Gathered metadata for " + rasterTable + "#" + rAtt.getRasterId().longValue() + ":\n" + rasterInfo.toString());
            }
        }
        catch (SeException e) {
            throw new ArcSdeException("Gathering raster dataset information", e);
        }
        RasterDatasetInfo rasterInfo = new RasterDatasetInfo();
        rasterInfo.setRasterTable(rasterTable);
        rasterInfo.setRasterColumns(rasterColumns);
        rasterInfo.setPyramidInfo(rastersLayoutInfo);
        return rasterInfo;
    }

    private GeneralEnvelope calculateOriginalEnvelope(SeRasterAttr rasterAttributes, CoordinateReferenceSystem coverageCrs) throws IOException {
        SeExtent sdeExtent;
        try {
            sdeExtent = rasterAttributes.getExtent();
        }
        catch (SeException e) {
            throw new ArcSdeException("Exception getting the raster extent", e);
        }
        GeneralEnvelope originalEnvelope = new GeneralEnvelope(coverageCrs);
        originalEnvelope.setRange(0, sdeExtent.getMinX(), sdeExtent.getMaxX());
        originalEnvelope.setRange(1, sdeExtent.getMinY(), sdeExtent.getMaxY());
        return originalEnvelope;
    }

    private String[] getRasterColumns(ArcSDEPooledConnection scon, String rasterTable) throws IOException {
        SeColumnDefinition[] cols;
        SeTable sTable = scon.getTable(rasterTable);
        try {
            cols = sTable.describe();
        }
        catch (SeException e) {
            throw new ArcSdeException("Exception fetching the list of columns for table " + rasterTable, e);
        }
        ArrayList<String> fetchColumns = new ArrayList<String>(cols.length / 2);
        for (int i = 0; i < cols.length; ++i) {
            if (cols[i].getType() != SeColumnDefinition.TYPE_RASTER) continue;
            fetchColumns.add(cols[i].getName());
        }
        if (fetchColumns.size() == 0) {
            throw new DataSourceException("Couldn't find any TYPE_RASTER columns in ArcSDE table " + rasterTable);
        }
        String[] rasterColumns = fetchColumns.toArray(new String[fetchColumns.size()]);
        return rasterColumns;
    }

    private List<SeRasterAttr> getSeRasterAttr(ArcSDEPooledConnection scon, String rasterTable, String[] rasterColumns) throws IOException {
        LOGGER.fine("Gathering raster attributes for " + rasterTable);
        LinkedList<SeRasterAttr> rasterAttList = new LinkedList<SeRasterAttr>();
        SeQuery query = null;
        try {
            query = new SeQuery((SeConnection)scon, rasterColumns, new SeSqlConstruct(rasterTable));
            query.prepareQuery();
            query.execute();
            SeRow row = query.fetch();
            while (row != null) {
                SeRasterAttr rasterAttributes = row.getRaster(0);
                rasterAttList.addFirst(rasterAttributes);
                row = query.fetch();
            }
        }
        catch (SeException se) {
            throw new ArcSdeException("Error fetching raster attributes for " + rasterTable, se);
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SeException e) {
                    throw new ArcSdeException(e);
                }
            }
        }
        LOGGER.fine("Found " + rasterAttList.size() + " raster attributes for " + rasterTable);
        return rasterAttList;
    }

    private List<RasterBandInfo> setUpBandInfo(ArcSDEPooledConnection scon, SeRasterAttr rasterAttributes, Map<Long, IndexColorModel> rastersColorMaps) throws IOException {
        RasterCellType cellType;
        SeRasterBand[] seBands;
        int numBands;
        try {
            numBands = rasterAttributes.getNumBands();
            seBands = rasterAttributes.getBands();
            cellType = RasterCellType.valueOf(rasterAttributes.getPixelType());
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        ArrayList<RasterBandInfo> detachedBandInfo = new ArrayList<RasterBandInfo>(numBands);
        for (int bandN = 0; bandN < numBands; ++bandN) {
            SeRasterBand band = seBands[bandN];
            RasterBandInfo bandInfo = new RasterBandInfo();
            int bitsPerSample = cellType.getBitsPerSample();
            this.setBandInfo(numBands, bandInfo, band, scon, bitsPerSample, rastersColorMaps);
            detachedBandInfo.add(bandInfo);
        }
        return detachedBandInfo;
    }

    private void setBandInfo(int numBands, RasterBandInfo bandInfo, SeRasterBand band, ArcSDEPooledConnection scon, int bitsPerSample, Map<Long, IndexColorModel> colorMaps) throws IOException {
        SDEPoint tOrigin;
        bandInfo.bandId = band.getId().longValue();
        bandInfo.bandNumber = band.getBandNumber();
        bandInfo.bandName = "Band " + bandInfo.bandNumber;
        boolean hasColorMap = band.hasColorMap();
        if (hasColorMap) {
            IndexColorModel colorMap = colorMaps.get(bandInfo.bandId);
            LOGGER.finest("Setting band's color map: " + colorMap);
            bandInfo.nativeColorMap = colorMap;
            bandInfo.colorMap = RasterUtils.ensureNoDataPixelIsAvailable(colorMap);
        } else {
            bandInfo.nativeColorMap = null;
        }
        bandInfo.compressionType = CompressionType.valueOf(band.getCompressionType());
        bandInfo.cellType = RasterCellType.valueOf(band.getPixelType());
        bandInfo.interleaveType = InterleaveType.valueOf(band.getInterleave());
        bandInfo.interpolationType = InterpolationType.valueOf(band.getInterpolation());
        bandInfo.hasStats = band.hasStats();
        if (bandInfo.hasStats) {
            try {
                bandInfo.statsMin = band.getStatsMin();
                bandInfo.statsMax = band.getStatsMax();
                bandInfo.statsMean = band.getStatsMean();
                bandInfo.statsStdDev = band.getStatsStdDev();
            }
            catch (SeException e) {
                throw new ArcSdeException(e);
            }
        } else {
            bandInfo.statsMin = Double.NaN;
            bandInfo.statsMax = Double.NaN;
            bandInfo.statsMean = Double.NaN;
            bandInfo.statsStdDev = Double.NaN;
        }
        if (bandInfo.getColorMap() != null) {
            bandInfo.noDataValue = RasterUtils.determineNoDataValue(bandInfo.getColorMap());
        } else {
            double statsMin = bandInfo.getStatsMin();
            double statsMax = bandInfo.getStatsMax();
            RasterCellType nativeCellType = bandInfo.getCellType();
            bandInfo.noDataValue = RasterUtils.determineNoDataValue(numBands, statsMin, statsMax, nativeCellType);
        }
        try {
            tOrigin = band.getTileOrigin();
        }
        catch (SeException e) {
            throw new ArcSdeException(e);
        }
        bandInfo.tileOrigin = new Point2D.Double(tOrigin.getX(), tOrigin.getY());
    }

    private Map<Long, IndexColorModel> loadColorMaps(long rasterColumnId, int bitsPerSample, ArcSDEPooledConnection scon) throws IOException {
        LOGGER.fine("Reading colormap for raster column " + rasterColumnId);
        String auxTableName = this.getAuxTableName(rasterColumnId, scon);
        LOGGER.fine("Quering auxiliary table " + auxTableName + " for color map data");
        HashMap<Long, IndexColorModel> colorMaps = new HashMap<Long, IndexColorModel>();
        SeQuery query = null;
        try {
            SeSqlConstruct sqlConstruct = new SeSqlConstruct();
            sqlConstruct.setTables(new String[]{auxTableName});
            String whereClause = "TYPE = 3";
            sqlConstruct.setWhere(whereClause);
            query = new SeQuery((SeConnection)scon, new String[]{"RASTERBAND_ID", "OBJECT"}, sqlConstruct);
            query.prepareQuery();
            query.execute();
            SeRow row = query.fetch();
            while (row != null) {
                long bandId = ((Number)row.getObject(0)).longValue();
                ByteArrayInputStream colorMapIS = row.getBlob(1);
                DataBuffer colorMapData = this.readColorMap(colorMapIS);
                IndexColorModel colorModel = RasterUtils.sdeColorMapToJavaColorModel(colorMapData, bitsPerSample);
                colorMaps.put(bandId, colorModel);
                row = query.fetch();
            }
        }
        catch (SeException e) {
            throw new ArcSdeException("Error fetching colormap data for column " + rasterColumnId + " from table " + auxTableName, e);
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SeException e) {
                    LOGGER.log(Level.INFO, "ignoring exception when closing query to fetch colormap data", e);
                }
            }
        }
        LOGGER.fine("Read color map data for " + colorMaps.size() + " rasters");
        return colorMaps;
    }

    private String getAuxTableName(long rasterColumnId, ArcSDEPooledConnection scon) throws IOException {
        String owner;
        SeQuery query = null;
        try {
            String dbaName = scon.getSdeDbaName();
            String rastersColumnsTable = dbaName + ".SDE_RASTER_COLUMNS";
            SeSqlConstruct sqlCons = new SeSqlConstruct(rastersColumnsTable);
            sqlCons.setWhere("RASTERCOLUMN_ID = " + rasterColumnId);
            try {
                query = new SeQuery((SeConnection)scon, new String[]{"OWNER"}, sqlCons);
                query.prepareQuery();
            }
            catch (SeException e) {
                rastersColumnsTable = dbaName + ".RASTER_COLUMNS";
                sqlCons = new SeSqlConstruct(rastersColumnsTable);
                sqlCons.setWhere("RASTERCOLUMN_ID = " + rasterColumnId);
                query = new SeQuery((SeConnection)scon, new String[]{"OWNER"}, sqlCons);
                query.prepareQuery();
            }
            query.execute();
            SeRow row = query.fetch();
            if (row == null) {
                throw new IllegalArgumentException("No raster column registered with id " + rasterColumnId);
            }
            owner = row.getString(0);
            query.close();
        }
        catch (SeException e) {
            throw new ArcSdeException("Error getting auxiliary table for raster column " + rasterColumnId, e);
        }
        finally {
            if (query != null) {
                try {
                    query.close();
                }
                catch (SeException e) {
                    LOGGER.log(Level.INFO, "ignoring exception when closing query to fetch colormap data", e);
                }
            }
        }
        String auxTableName = owner + ".SDE_AUX_" + rasterColumnId;
        return auxTableName;
    }

    private DataBuffer readColorMap(ByteArrayInputStream colorMapIS) throws IOException {
        DataBuffer buff;
        int numBanks;
        DataInputStream dataIn = new DataInputStream(colorMapIS);
        dataIn.readInt();
        int colorSpaceType = dataIn.readInt();
        if (colorSpaceType == SeRaster.SE_COLORMAP_RGB) {
            numBanks = 3;
        } else if (colorSpaceType == SeRaster.SE_COLORMAP_RGBA) {
            numBanks = 4;
        } else {
            throw new IllegalStateException("Got unknown colormap type: " + colorSpaceType);
        }
        LOGGER.finest("Colormap has " + numBanks + " color components");
        int buffType = dataIn.readInt();
        int numElems = dataIn.readInt();
        LOGGER.finest("ColorMap length: " + numElems);
        if (buffType == SeRaster.SE_COLORMAP_DATA_BYTE) {
            LOGGER.finest("Creating Byte data buffer for " + numBanks + " banks and " + numElems + " elements per bank");
            buff = new DataBufferByte(numElems, numBanks);
            for (int elem = 0; elem < numElems; ++elem) {
                for (int bank = 0; bank < numBanks; ++bank) {
                    int val = dataIn.readUnsignedByte();
                    buff.setElem(bank, elem, val);
                }
            }
        } else if (buffType == SeRaster.SE_COLORMAP_DATA_SHORT) {
            LOGGER.finest("Creating Short data buffer for " + numBanks + " banks and " + numElems + " elements per bank");
            buff = new DataBufferUShort(numElems, numBanks);
            for (int elem = 0; elem < numElems; ++elem) {
                for (int bank = 0; bank < numBanks; ++bank) {
                    int val = dataIn.readUnsignedShort();
                    buff.setElem(bank, elem, val);
                }
            }
        } else {
            throw new IllegalStateException("Unknown databuffer type from colormap header: " + buffType + " expected one of TYPE_BYTE, TYPE_SHORT");
        }
        assert (dataIn.read() == -1) : "color map data should have been exausted";
        return buff;
    }

    void setStatisticsMandatory(boolean statisticsMandatory) {
        this.statisticsMandatory = statisticsMandatory;
    }
}

