/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.session;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeException;
import com.esri.sde.sdk.client.SeLayer;
import com.esri.sde.sdk.client.SeRasterColumn;
import com.esri.sde.sdk.client.SeTable;
import java.util.HashMap;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Vector;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.commons.pool.ObjectPool;
import org.geotools.arcsde.session.ArcSDEConnectionConfig;
import org.geotools.data.DataSourceException;
import org.geotools.util.logging.Logging;

public class ArcSDEPooledConnection
extends SeConnection {
    private static final Logger LOGGER = Logging.getLogger((String)"org.geotools.arcsde.pool");
    private ObjectPool pool;
    private ArcSDEConnectionConfig config;
    private static int connectionCounter;
    private int connectionId;
    private boolean transactionInProgress;
    private boolean isPassivated;
    private Map<String, SeLayer> cachedLayers = new HashMap<String, SeLayer>();
    private Map<String, SeRasterColumn> cachedRasters = new HashMap<String, SeRasterColumn>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArcSDEPooledConnection(ObjectPool pool, ArcSDEConnectionConfig config) throws SeException {
        super(config.getServerName(), config.getPortNumber().intValue(), config.getDatabaseName(), config.getUserName(), config.getPassword());
        this.config = config;
        this.pool = pool;
        this.setConcurrency(SeConnection.SE_UNPROTECTED_POLICY);
        Class<ArcSDEPooledConnection> clazz = ArcSDEPooledConnection.class;
        synchronized (ArcSDEPooledConnection.class) {
            this.connectionId = ++connectionCounter;
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public final boolean isClosed() {
        return super.isClosed();
    }

    void markActive() {
        this.isPassivated = false;
    }

    void markInactive() {
        this.isPassivated = true;
    }

    public boolean isPassivated() {
        return this.isPassivated;
    }

    private void checkActive() {
        if (this.isPassivated()) {
            throw new IllegalStateException("Unrecoverable error: " + this.toString() + " is passivated, shall not be used!");
        }
    }

    public synchronized SeLayer getLayer(String layerName) throws DataSourceException {
        SeLayer seLayer;
        this.checkActive();
        if (!this.cachedLayers.containsKey(layerName)) {
            try {
                this.cacheLayers();
            }
            catch (SeException e) {
                throw new DataSourceException("Can't obtain layer " + layerName, (Throwable)e);
            }
        }
        if ((seLayer = this.cachedLayers.get(layerName)) == null) {
            throw new NoSuchElementException("Layer '" + layerName + "' not found");
        }
        return seLayer;
    }

    public synchronized SeRasterColumn getRasterColumn(String rasterName) throws DataSourceException {
        SeRasterColumn raster;
        this.checkActive();
        if (!this.cachedRasters.containsKey(rasterName)) {
            try {
                this.cacheRasters();
            }
            catch (SeException e) {
                throw new DataSourceException("Can't obtain raster " + rasterName, (Throwable)e);
            }
        }
        if ((raster = this.cachedRasters.get(rasterName)) == null) {
            throw new NoSuchElementException("Raster '" + rasterName + "' not found");
        }
        return raster;
    }

    public synchronized SeTable getTable(String tableName) throws DataSourceException {
        this.checkActive();
        try {
            return new SeTable((SeConnection)this, tableName);
        }
        catch (SeException e) {
            throw new DataSourceException("Can't access table " + tableName, (Throwable)e);
        }
    }

    private void cacheLayers() throws SeException {
        Vector layers = this.getLayers();
        this.cachedLayers.clear();
        for (SeLayer layer : layers) {
            this.cachedLayers.put(layer.getQualifiedName(), layer);
        }
    }

    private void cacheRasters() throws SeException {
        Vector rasters = this.getRasterColumns();
        this.cachedRasters.clear();
        for (SeRasterColumn raster : rasters) {
            this.cachedRasters.put(raster.getQualifiedTableName(), raster);
        }
    }

    public void startTransaction() throws SeException {
        this.checkActive();
        super.startTransaction();
        this.transactionInProgress = true;
    }

    public void commitTransaction() throws SeException {
        this.checkActive();
        super.commitTransaction();
        this.transactionInProgress = false;
    }

    public boolean isTransactionActive() {
        this.checkActive();
        return this.transactionInProgress;
    }

    public void rollbackTransaction() throws SeException {
        this.checkActive();
        super.rollbackTransaction();
        this.transactionInProgress = false;
    }

    public void close() throws IllegalStateException {
        this.checkActive();
        if (this.transactionInProgress) {
            throw new IllegalStateException("Transaction is in progress, should commit or rollback before closing");
        }
        try {
            if (LOGGER.isLoggable(Level.FINER)) {
                LOGGER.finer("<- returning " + this.toString() + " to pool");
            }
            this.pool.returnObject((Object)this);
        }
        catch (Exception e) {
            LOGGER.log(Level.SEVERE, e.getMessage(), e);
        }
    }

    public String toString() {
        return "ArcSDEPooledConnection[" + this.connectionId + "]";
    }

    void destroy() {
        try {
            super.close();
        }
        catch (SeException e) {
            LOGGER.info("closing connection: " + e.getMessage());
        }
    }

    public boolean equals(Object other) {
        return other == this;
    }

    public int hashCode() {
        return 0x11 ^ this.config.hashCode();
    }
}

