/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde;

import com.esri.sde.sdk.client.SeConnection;
import com.esri.sde.sdk.client.SeRelease;
import com.esri.sde.sdk.pe.PeCoordinateSystem;
import com.esri.sde.sdk.pe.PeFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.geotools.arcsde.data.ArcSDEDataStore;
import org.geotools.arcsde.data.ArcSDEDataStoreConfig;
import org.geotools.arcsde.data.ViewRegisteringFactoryHelper;
import org.geotools.arcsde.session.Command;
import org.geotools.arcsde.session.Commands;
import org.geotools.arcsde.session.ISession;
import org.geotools.arcsde.session.ISessionPool;
import org.geotools.arcsde.session.ISessionPoolFactory;
import org.geotools.arcsde.session.SessionPoolFactory;
import org.geotools.arcsde.session.UnavailableConnectionException;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataSourceException;
import org.geotools.data.DataStore;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.util.SimpleInternationalString;
import org.geotools.util.logging.Logging;
import org.opengis.util.InternationalString;

public final class ArcSDEDataStoreFactory
implements DataStoreFactorySpi {
    protected static final Logger LOGGER = Logging.getLogger((String)ArcSDEDataStoreFactory.class.getName());
    public static final String FACTORY_DESCRIPTION = "ESRI(tm) ArcSDE 9.2+ vector data store";
    private static List<DataAccessFactory.Param> paramMetadata = new ArrayList<DataAccessFactory.Param>(10);
    public static final int JSDE_VERSION_DUMMY = -1;
    public static final int JSDE_VERSION_90 = 0;
    public static final int JSDE_VERSION_91 = 1;
    public static final int JSDE_VERSION_92 = 2;
    private static int JSDE_CLIENT_VERSION;
    public static final DataAccessFactory.Param NAMESPACE_PARAM;
    public static final DataAccessFactory.Param DBTYPE_PARAM;
    public static final DataAccessFactory.Param SERVER_PARAM;
    public static final DataAccessFactory.Param PORT_PARAM;
    public static final DataAccessFactory.Param INSTANCE_PARAM;
    public static final DataAccessFactory.Param USER_PARAM;
    public static final DataAccessFactory.Param PASSWORD_PARAM;
    public static final DataAccessFactory.Param MIN_CONNECTIONS_PARAM;
    public static final DataAccessFactory.Param MAX_CONNECTIONS_PARAM;
    public static final DataAccessFactory.Param TIMEOUT_PARAM;
    public static final DataAccessFactory.Param VERSION_PARAM;
    public static final DataAccessFactory.Param ALLOW_NON_SPATIAL_PARAM;
    private static final ISessionPoolFactory poolFactory;

    private static void determineJsdeVersion() {
        try {
            Class.forName("com.esri.sde.sdk.GeoToolsDummyAPI");
            JSDE_CLIENT_VERSION = -1;
        }
        catch (Throwable t) {
            try {
                Class.forName("com.esri.sde.sdk.client.SeDBTune");
                JSDE_CLIENT_VERSION = 2;
                LOGGER.fine("Using ArcSDE API version 9.2 (or higher)");
            }
            catch (Throwable t2) {
                try {
                    int[] projcss = PeFactory.projcsCodelist();
                    if (projcss.length == 16380) {
                        JSDE_CLIENT_VERSION = 1;
                        LOGGER.fine("Using ArcSDE API version 9.1");
                    } else {
                        JSDE_CLIENT_VERSION = 0;
                        LOGGER.fine("Using ArcSDE API version 9.0 (or an earlier 8.x version)");
                    }
                }
                catch (Throwable crap) {
                    JSDE_CLIENT_VERSION = 0;
                }
            }
        }
    }

    public ArcSDEDataStoreFactory() {
        if (!this.isAvailable()) {
            LOGGER.finest("The ESRI ArcSDE Java API seems to not be on your classpath. Please verify that all needed jars are. ArcSDE data stores will not be available.");
        }
    }

    public DataStore createNewDataStore(Map map) {
        throw new UnsupportedOperationException("ArcSDE DataStore does not support the creation of new databases. This should be done through database's specific tools");
    }

    public DataStore createDataStore(Map params) throws IOException {
        if (JSDE_CLIENT_VERSION == -1) {
            throw new DataSourceException("Can't connect to ArcSDE with the dummy jar.");
        }
        ArcSDEDataStore sdeDStore = null;
        ArcSDEDataStoreConfig config = new ArcSDEDataStoreConfig(params);
        sdeDStore = this.createDataStore(config);
        ViewRegisteringFactoryHelper.registerSqlViews(sdeDStore, params);
        return sdeDStore;
    }

    final ArcSDEDataStore createDataStore(ArcSDEDataStoreConfig config) throws IOException {
        ISessionPool connPool = poolFactory.createPool(config.getSessionConfig());
        return this.createDataStore(config, connPool);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    final ArcSDEDataStore createDataStore(ArcSDEDataStoreConfig config, ISessionPool connPool) throws IOException {
        String versionName;
        ISession session;
        try {
            session = connPool.getSession(false);
        }
        catch (UnavailableConnectionException e) {
            throw new RuntimeException(e);
        }
        try {
            String versionName2;
            SeRelease releaseInfo = session.getRelease();
            int majVer = releaseInfo.getMajor();
            int minVer = releaseInfo.getMinor();
            if (majVer == 9 && minVer > 1 && JSDE_CLIENT_VERSION < 1) {
                LOGGER.severe("\n\n**************************\nDANGER DANGER DANGER!!!  You're using the ArcSDE 9.0 (or earlier) jars with ArcSDE " + majVer + "." + minVer + " on host '" + config.getServerName() + "' .  " + "This PROBABLY WON'T WORK.  If you have issues " + "or unexplained exceptions when rendering maps, upgrade your ArcSDE jars to version " + "9.2 or higher.  See http://docs.codehaus.org/display/GEOTOOLS/ArcSDE+Plugin\n" + "**************************\n\n");
            }
            if ((versionName2 = config.getVersion()) != null && !"".equals(versionName2.trim())) {
                session.issue((Command)new Commands.GetVersionCommand(versionName2));
            }
        }
        finally {
            session.dispose();
        }
        String namespaceUri = config.getNamespaceUri();
        if (namespaceUri != null && "".equals(namespaceUri.trim())) {
            namespaceUri = null;
        }
        if ((versionName = config.getVersion()) != null && "".equals(versionName.trim())) {
            versionName = null;
        }
        boolean allowNonSpatialTables = config.isAllowNonSpatialTables();
        ArcSDEDataStore sdeDStore = new ArcSDEDataStore(connPool, namespaceUri, versionName, allowNonSpatialTables);
        return sdeDStore;
    }

    public String getDisplayName() {
        return "ArcSDE";
    }

    public String getDescription() {
        return FACTORY_DESCRIPTION;
    }

    public boolean canProcess(Map params) {
        if (JSDE_CLIENT_VERSION == -1) {
            return false;
        }
        boolean canProcess = true;
        try {
            new ArcSDEDataStoreConfig(params);
        }
        catch (NullPointerException ex) {
            canProcess = false;
        }
        catch (IllegalArgumentException ex) {
            canProcess = false;
        }
        return canProcess;
    }

    public boolean isAvailable() {
        if (JSDE_CLIENT_VERSION == -1) {
            LOGGER.warning("You must download and install the *real* ArcSDE JSDE jar files. Currently the GeoTools ArcSDE 'dummy jar' is on your classpath. ArcSDE connectivity is DISABLED. See http://docs.codehaus.org/display/GEOTOOLS/ArcSDE+Plugin");
            return false;
        }
        try {
            LOGGER.finest(SeConnection.class.getName() + " is in place.");
            LOGGER.finest(PeCoordinateSystem.class.getName() + " is in place.");
        }
        catch (Throwable t) {
            return false;
        }
        return true;
    }

    public DataAccessFactory.Param[] getParametersInfo() {
        return paramMetadata.toArray(new DataAccessFactory.Param[paramMetadata.size()]);
    }

    public Map getImplementationHints() {
        return Collections.EMPTY_MAP;
    }

    public static int getSdeClientVersion() {
        return JSDE_CLIENT_VERSION;
    }

    static {
        NAMESPACE_PARAM = new DataAccessFactory.Param("namespace", String.class, "namespace associated to this data store", false);
        DBTYPE_PARAM = new DataAccessFactory.Param("dbtype", String.class, "fixed value. Must be \"arcsde\"", true, (Object)"arcsde");
        SERVER_PARAM = new DataAccessFactory.Param("server", String.class, "sever name where the ArcSDE gateway is running", true);
        PORT_PARAM = new DataAccessFactory.Param("port", Integer.class, "port number in wich the ArcSDE server is listening for connections.Generally it's 5151", true, (Object)5151);
        INSTANCE_PARAM = new DataAccessFactory.Param("instance", String.class, "the specific database to connect to. Only applicable to certain databases. Value ignored if not applicable.", false);
        USER_PARAM = new DataAccessFactory.Param("user", String.class, "name of a valid database user account.", true);
        PASSWORD_PARAM = new DataAccessFactory.Param("password", String.class, (InternationalString)new SimpleInternationalString("the database user's password."), false, null, Collections.singletonMap("isPassword", Boolean.TRUE));
        MIN_CONNECTIONS_PARAM = new DataAccessFactory.Param("pool.minConnections", Integer.class, "Minimun number of open connections", false, (Object)2);
        MAX_CONNECTIONS_PARAM = new DataAccessFactory.Param("pool.maxConnections", Integer.class, "Maximun number of open connections (will not work if < 2)", false, (Object)6);
        TIMEOUT_PARAM = new DataAccessFactory.Param("pool.timeOut", Integer.class, "Milliseconds to wait for an available connection before failing to connect", false, (Object)500);
        VERSION_PARAM = new DataAccessFactory.Param("database.version", String.class, "The ArcSDE database version to use.", false);
        ALLOW_NON_SPATIAL_PARAM = new DataAccessFactory.Param("datastore.allowNonSpatialTables", Boolean.class, "If enabled, registered non-spatial tables are also published.", false, (Object)Boolean.FALSE);
        paramMetadata.add(NAMESPACE_PARAM);
        paramMetadata.add(DBTYPE_PARAM);
        paramMetadata.add(SERVER_PARAM);
        paramMetadata.add(PORT_PARAM);
        paramMetadata.add(INSTANCE_PARAM);
        paramMetadata.add(USER_PARAM);
        paramMetadata.add(PASSWORD_PARAM);
        paramMetadata.add(MIN_CONNECTIONS_PARAM);
        paramMetadata.add(MAX_CONNECTIONS_PARAM);
        paramMetadata.add(TIMEOUT_PARAM);
        paramMetadata.add(VERSION_PARAM);
        paramMetadata.add(ALLOW_NON_SPATIAL_PARAM);
        ArcSDEDataStoreFactory.determineJsdeVersion();
        poolFactory = SessionPoolFactory.getInstance();
    }
}

