/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.data;

import java.io.IOException;
import java.util.NoSuchElementException;
import org.geotools.arcsde.data.ArcSdeFeatureWriter;
import org.geotools.arcsde.data.ArcTransactionState;
import org.geotools.arcsde.data.FIDReader;
import org.geotools.arcsde.data.versioning.ArcSdeVersionHandler;
import org.geotools.data.FeatureEvent;
import org.geotools.data.FeatureListenerManager;
import org.geotools.data.FeatureReader;
import org.geotools.data.Transaction;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class TransactionFeatureWriter
extends ArcSdeFeatureWriter {
    private ArcTransactionState state;

    public TransactionFeatureWriter(FIDReader fidReader, SimpleFeatureType featureType, FeatureReader<SimpleFeatureType, SimpleFeature> filteredContent, ArcTransactionState state, ArcSdeVersionHandler versionHandler, FeatureListenerManager listenerManager) throws NoSuchElementException, IOException {
        super(fidReader, featureType, filteredContent, state.getConnection(), listenerManager, versionHandler);
        this.state = state;
        assert (state.getConnection().isTransactionActive());
    }

    @Override
    public void close() throws IOException {
        if (this.filteredContent != null) {
            this.filteredContent.close();
            this.filteredContent = null;
        }
    }

    @Override
    public void write() throws IOException {
        try {
            super.write();
            String typeName = this.feature.getFeatureType().getTypeName();
            this.state.addChange(typeName);
        }
        catch (IOException e) {
            this.state.getTransaction().rollback();
            throw e;
        }
    }

    @Override
    public void remove() throws IOException {
        try {
            super.remove();
        }
        catch (IOException e) {
            this.state.getTransaction().rollback();
            throw e;
        }
    }

    @Override
    protected void doFireFeaturesAdded(String typeName, ReferencedEnvelope bounds, Filter filter) {
        Transaction transaction = this.state.getTransaction();
        FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.ADDED, bounds, filter);
        this.listenerManager.fireEvent(typeName, transaction, event);
    }

    @Override
    protected void doFireFeaturesChanged(String typeName, ReferencedEnvelope bounds, Filter filter) {
        Transaction transaction = this.state.getTransaction();
        FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.CHANGED, bounds, filter);
        this.listenerManager.fireEvent(typeName, transaction, event);
    }

    @Override
    protected void doFireFeaturesRemoved(String typeName, ReferencedEnvelope bounds, Filter filter) {
        Transaction transaction = this.state.getTransaction();
        FeatureEvent event = new FeatureEvent((Object)this, FeatureEvent.Type.REMOVED, bounds, filter);
        this.listenerManager.fireEvent(typeName, transaction, event);
    }
}

