/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.arcsde.raster.io;

import java.awt.Rectangle;
import java.awt.image.ColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import javax.imageio.ImageTypeSpecifier;
import org.geotools.arcsde.raster.info.RasterDatasetInfo;
import org.geotools.arcsde.raster.io.TileReader;
import org.geotools.arcsde.raster.io.TileReaderFactory;
import org.geotools.arcsde.raster.io.TiledRasterReader;
import org.geotools.arcsde.raster.jai.ArcSDEPlanarImage;
import org.geotools.arcsde.session.ISessionPool;

class DefaultTiledRasterReader
implements TiledRasterReader {
    private RasterDatasetInfo rasterInfo;
    private final ISessionPool sessionPool;

    public DefaultTiledRasterReader(ISessionPool sessionPool, RasterDatasetInfo rasterInfo) throws IOException {
        this.sessionPool = sessionPool;
        this.rasterInfo = rasterInfo;
    }

    public RenderedImage read(long rasterId, int pyramidLevel, Rectangle tileRange) throws IOException {
        TileReader tileReader = TileReaderFactory.getInstance(this.sessionPool, this.rasterInfo, rasterId, pyramidLevel, tileRange);
        RenderedImage fullTilesRaster = this.createTiledRaster(tileReader, tileRange, rasterId);
        return fullTilesRaster;
    }

    private RenderedImage createTiledRaster(TileReader tileReader, Rectangle matchingTiles, long rasterId) throws IOException {
        int tileWidth = this.rasterInfo.getTileWidth(rasterId);
        int tileHeight = this.rasterInfo.getTileHeight(rasterId);
        int rasterIndex = this.rasterInfo.getRasterIndex(rasterId);
        int pyramidLevel = tileReader.getPyramidLevel();
        int numTilesWide = this.rasterInfo.getNumTilesWide(rasterIndex, pyramidLevel);
        int numTilesHigh = this.rasterInfo.getNumTilesHigh(rasterIndex, pyramidLevel);
        int tiledImageWidth = numTilesWide * tileWidth;
        int tiledImageHeight = numTilesHigh * tileHeight;
        ImageTypeSpecifier fullImageSpec = this.rasterInfo.getRenderedImageSpec(rasterId);
        ColorModel colorModel = fullImageSpec.getColorModel();
        SampleModel sampleModel = fullImageSpec.getSampleModel().createCompatibleSampleModel(tileWidth, tileHeight);
        int minX = 0;
        int minY = 0;
        int width = tiledImageWidth;
        int height = tiledImageHeight;
        int tileGridXOffset = 0;
        int tileGridYOffset = 0;
        SampleModel tileSampleModel = sampleModel;
        ArcSDEPlanarImage image = new ArcSDEPlanarImage(tileReader, minX, minY, width, height, tileGridXOffset, tileGridYOffset, tileSampleModel, colorModel);
        return image;
    }
}

