/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.featurecache;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import org.geotools.caching.CacheOversizedException;
import org.geotools.caching.FeatureCollectingVisitor;
import org.geotools.caching.featurecache.AbstractFeatureCache;
import org.geotools.caching.featurecache.FeatureCacheException;
import org.geotools.caching.grid.featurecache.ValidatingVisitor;
import org.geotools.caching.grid.spatialindex.GridInvalidatingVisitor;
import org.geotools.caching.grid.spatialindex.GridSpatialIndex;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.SpatialIndex;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.caching.util.CacheUtil;
import org.geotools.data.FeatureSource;
import org.geotools.data.Query;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridFeatureCache
extends AbstractFeatureCache {
    protected int max_tiles = 10;
    protected GridSpatialIndex tracker;
    protected int capacity;

    public GridFeatureCache(FeatureSource fs, int indexcapacity, int capacity, Storage store) throws FeatureCacheException {
        this(fs, GridFeatureCache.getFeatureBounds(fs), indexcapacity, capacity, store);
    }

    public GridFeatureCache(FeatureSource fs, ReferencedEnvelope env, int gridsize, int capacity, Storage store) {
        super(fs);
        this.tracker = new GridSpatialIndex(CacheUtil.convert((Envelope)env), gridsize, store, capacity);
        this.capacity = capacity;
        if (store.getFeatureTypes().size() == 0) {
            store.addFeatureType(fs.getSchema());
        } else if (store.getFeatureTypes().size() == 1) {
            SimpleFeatureType sft = (SimpleFeatureType)store.getFeatureTypes().iterator().next();
            if (!sft.equals(fs.getSchema()) && fs.getSchema() != null) {
                this.tracker.clear();
                store.clearFeatureTypes();
                store.addFeatureType(fs.getSchema());
            }
        } else {
            this.tracker.clear();
            store.clearFeatureTypes();
            store.addFeatureType(fs.getSchema());
        }
        if (env != null && !env.equals((Object)store.getBounds())) {
            store.setBounds(env);
        }
        this.tracker.flush();
    }

    public SpatialIndex getIndex() {
        return this.tracker;
    }

    protected static ReferencedEnvelope getFeatureBounds(FeatureSource fs) throws FeatureCacheException {
        try {
            return fs.getBounds();
        }
        catch (IOException ex) {
            throw new FeatureCacheException(ex);
        }
    }

    @Override
    public SimpleFeatureType getSchema() {
        if (this.tracker.getStorage().getFeatureTypes().size() == 1) {
            return (SimpleFeatureType)this.tracker.getStorage().getFeatureTypes().iterator().next();
        }
        return (SimpleFeatureType)this.fs.getSchema();
    }

    @Override
    public List<Envelope> match(Envelope e) {
        List<NodeIdentifier>[] tiles;
        List<NodeIdentifier> missing_tiles;
        Region search = CacheUtil.convert(e);
        ArrayList<Envelope> missing = new ArrayList<Envelope>();
        if (!this.tracker.getRootNode().getShape().intersects(search)) {
            return new ArrayList<Envelope>();
        }
        if (!this.tracker.getRootNode().getShape().contains(search)) {
            Envelope r = CacheUtil.convert((Region)this.tracker.getRootNode().getShape());
            r = r.intersection(e);
            search = CacheUtil.convert(r);
        }
        if ((missing_tiles = (tiles = this.tracker.findMissingTiles(search))[0]).size() > this.max_tiles) {
            Envelope env = new Envelope(e);
            for (NodeIdentifier id : missing_tiles) {
                Envelope nextenv = CacheUtil.convert((Region)id.getShape());
                env.expandToInclude(nextenv);
            }
            missing.add(env);
        } else {
            for (NodeIdentifier id : missing_tiles) {
                Region next = (Region)id.getShape();
                missing.add(CacheUtil.convert(next));
            }
        }
        return missing;
    }

    public List<NodeIdentifier>[] matchNodeIds(Envelope e) {
        Region search = CacheUtil.convert(e);
        if (!this.tracker.getRootNode().getShape().intersects(search)) {
            return new List[]{Collections.emptyList(), Collections.emptyList()};
        }
        if (!this.tracker.getRootNode().getShape().contains(search)) {
            Envelope r = CacheUtil.convert((Region)this.tracker.getRootNode().getShape());
            r = r.intersection(e);
            search = CacheUtil.convert(r);
        }
        List<NodeIdentifier>[] tiles = this.tracker.findMissingTiles(search);
        List<NodeIdentifier> missing_tiles = tiles[0];
        List<NodeIdentifier> found_tiles = tiles[1];
        return new List[]{missing_tiles, found_tiles};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void clear() {
        this.lock.writeLock().lock();
        try {
            this.tracker.clear();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void dispose() {
        this.lock.writeLock().lock();
        try {
            this.tracker.dispose();
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FeatureCollection peek(Envelope e) {
        FeatureCollectingVisitor v = new FeatureCollectingVisitor(this.getSchema());
        this.lock.readLock().lock();
        try {
            this.tracker.intersectionQuery(CacheUtil.convert(e), v);
        }
        finally {
            this.lock.readLock().unlock();
        }
        return v.getCollection();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(FeatureCollection fc, Envelope e) throws CacheOversizedException {
        this.isOversized(fc);
        this.lock.writeLock().lock();
        try {
            this.register(e);
            this.put(fc);
        }
        catch (Exception ex) {
            this.unregister(e);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    @Override
    protected void isOversized(FeatureCollection fc) throws CacheOversizedException {
        if (this.capacity != Integer.MAX_VALUE && fc.size() > this.capacity) {
            throw new CacheOversizedException("Cannot cache collection of size " + fc.size() + " (capacity = " + this.capacity + " )");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(Envelope e) {
        GridInvalidatingVisitor v = new GridInvalidatingVisitor(this.tracker);
        this.lock.writeLock().lock();
        try {
            if (e == null) {
                e = this.getBounds();
            }
            this.tracker.intersectionQuery(CacheUtil.convert(e), v);
        }
        catch (IOException ex) {
            logger.log(Level.SEVERE, "Error removing elements from the cache.", ex);
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.tracker.flush();
    }

    public ReferencedEnvelope getBounds() throws IOException {
        CoordinateReferenceSystem crs = this.getSchema().getCoordinateReferenceSystem();
        return new ReferencedEnvelope(CacheUtil.convert((Region)this.tracker.getRootNode().getShape()), crs);
    }

    public ReferencedEnvelope getBounds(Query query) throws IOException {
        return this.fs.getBounds(query);
    }

    public int getCount(Query query) throws IOException {
        return this.fs.getCount(query);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void put(FeatureCollection fc) throws CacheOversizedException {
        this.isOversized(fc);
        this.lock.writeLock().lock();
        try {
            FeatureIterator it = fc.features();
            try {
                while (it.hasNext()) {
                    SimpleFeature f = (SimpleFeature)it.next();
                    this.tracker.insertData(f, CacheUtil.convert((Envelope)f.getBounds()));
                }
            }
            finally {
                fc.close(it);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
        this.tracker.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void register(Envelope e) {
        Region r = CacheUtil.convert(e);
        ValidatingVisitor v = new ValidatingVisitor(r);
        this.lock.writeLock().lock();
        try {
            boolean recordaccess = this.tracker.getDoRecordAccess();
            this.tracker.setDoRecordAccess(false);
            try {
                this.tracker.containmentQuery(r, v);
            }
            finally {
                this.tracker.setDoRecordAccess(recordaccess);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(Collection<NodeIdentifier> nodes) {
        this.lock.writeLock().lock();
        try {
            boolean recordaccess = this.tracker.getDoRecordAccess();
            try {
                this.tracker.setDoRecordAccess(false);
                for (NodeIdentifier nodeIdentifier : nodes) {
                    nodeIdentifier.setValid(true);
                }
            }
            finally {
                this.tracker.setDoRecordAccess(recordaccess);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregister(Collection<NodeIdentifier> nodes) {
        this.lock.writeLock().lock();
        try {
            boolean recordaccess = this.tracker.getDoRecordAccess();
            try {
                this.tracker.setDoRecordAccess(false);
                for (NodeIdentifier nodeIdentifier : nodes) {
                    nodeIdentifier.setValid(false);
                }
            }
            finally {
                this.tracker.setDoRecordAccess(recordaccess);
            }
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void unregister(Envelope e) {
        Region r = CacheUtil.convert(e);
        GridInvalidatingVisitor v = new GridInvalidatingVisitor(this.tracker, r);
        this.lock.writeLock().lock();
        try {
            this.tracker.containmentQuery(r, v);
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("GridFeatureCache [");
        sb.append(" Source = " + this.fs);
        sb.append(" Capacity = " + this.capacity);
        sb.append(" Nodes = " + this.tracker.getStatistics().getNumberOfNodes());
        sb.append(" ]");
        sb.append("\n" + this.tracker.getIndexProperties());
        return sb.toString();
    }

    public Set getSupportedHints() {
        return new HashSet();
    }

    @Override
    public String getStats() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.tracker.getStatistics().toString());
        sb.append("\n" + this.sourceAccessStats());
        return sb.toString();
    }
}

