/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.featurecache.readers;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.geotools.caching.spatialindex.SpatialIndex;
import org.geotools.caching.util.CacheUtil;
import org.geotools.data.FeatureReader;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.filter.Filter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CombiningCachingFeatureReader
implements FeatureReader<SimpleFeatureType, SimpleFeature> {
    private FeatureReader<SimpleFeatureType, SimpleFeature> r1 = null;
    private FeatureReader<SimpleFeatureType, SimpleFeature> r2 = null;
    private boolean cache1 = false;
    private boolean cache2 = false;
    private SpatialIndex index = null;
    private Filter postFilter = null;
    private SimpleFeature next = null;
    private HashSet<String> collectedFeatureIds;

    public CombiningCachingFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader1, FeatureReader<SimpleFeatureType, SimpleFeature> reader2, boolean cache1, boolean cache2, SpatialIndex cache, Filter postFilter) throws IOException {
        this.r1 = reader1;
        this.r2 = reader2;
        this.cache1 = cache1;
        this.cache2 = cache2;
        this.index = cache;
        this.postFilter = postFilter;
        this.collectedFeatureIds = new HashSet();
        this.init();
    }

    public void close() throws IOException {
        this.r1.close();
        this.r2.close();
        this.next = null;
    }

    public SimpleFeatureType getFeatureType() {
        return (SimpleFeatureType)this.r1.getFeatureType();
    }

    public boolean hasNext() throws IOException {
        return this.next != null;
    }

    private void init() throws IOException {
        this.next = this.findNext();
    }

    private SimpleFeature findNext() throws IOException {
        SimpleFeature sf;
        while (this.r1.hasNext()) {
            sf = (SimpleFeature)this.r1.next();
            if (this.cache1) {
                this.index.insertData(sf, CacheUtil.convert((Envelope)sf.getBounds()));
            }
            if (!this.postFilter.evaluate((Object)sf) || this.collectedFeatureIds.contains(sf.getID())) continue;
            return sf;
        }
        while (this.r2.hasNext()) {
            sf = (SimpleFeature)this.r2.next();
            if (this.cache2) {
                this.index.insertData(sf, CacheUtil.convert((Envelope)sf.getBounds()));
            }
            if (!this.postFilter.evaluate((Object)sf) || this.collectedFeatureIds.contains(sf.getID())) continue;
            return sf;
        }
        return null;
    }

    public SimpleFeature next() throws IOException, IllegalArgumentException, NoSuchElementException {
        SimpleFeature current = this.next;
        this.collectedFeatureIds.add(current.getID());
        this.next = this.findNext();
        if (current == null) {
            throw new NoSuchElementException("Both of the readers of been closed.");
        }
        return current;
    }
}

