/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.featurecache.readers;

import com.vividsolutions.jts.geom.Envelope;
import java.awt.RenderingHints;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.caching.grid.featurecache.GridFeatureCache;
import org.geotools.caching.grid.featurecache.readers.CombiningCachingFeatureReader;
import org.geotools.caching.grid.featurecache.readers.GridCacheFeatureReader;
import org.geotools.caching.grid.spatialindex.GridSpatialIndex;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Region;
import org.geotools.data.DataStore;
import org.geotools.data.DataUtilities;
import org.geotools.data.DefaultQuery;
import org.geotools.data.EmptyFeatureReader;
import org.geotools.data.FeatureReader;
import org.geotools.data.FeatureSource;
import org.geotools.data.MaxFeatureReader;
import org.geotools.data.Query;
import org.geotools.data.ReTypeFeatureReader;
import org.geotools.data.Transaction;
import org.geotools.data.crs.ReprojectFeatureReader;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.Hints;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.SchemaException;
import org.geotools.feature.collection.DelegateFeatureIterator;
import org.geotools.geometry.jts.LiteCoordinateSequenceFactory;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.util.logging.Logging;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.sort.SortBy;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.util.ProgressListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GridCachingFeatureCollection
implements FeatureCollection<SimpleFeatureType, SimpleFeature> {
    private static final int MAX_FILTER_SIZE = 4;
    private static Logger logger = Logging.getLogger((String)"org.geotools.caching");
    private static FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory2(null);
    private BBOX preFilter;
    private Filter postFilter;
    private Query query;
    private GridFeatureCache grid;
    private FeatureSource<SimpleFeatureType, SimpleFeature> fs;
    private FeatureType featureType;
    private FeatureType newFeatureType;
    private Set<Object> iterators;
    private boolean cacheFeatures = false;
    private MathTransform reproject = null;
    private Collection<CollectionListener> listeners;

    public GridCachingFeatureCollection(BBOX preFilter, Filter postFilter, GridFeatureCache g, FeatureSource<SimpleFeatureType, SimpleFeature> fs, boolean cacheFeatures) {
        this.grid = g;
        this.preFilter = preFilter;
        this.postFilter = postFilter;
        this.fs = fs;
        this.cacheFeatures = cacheFeatures;
        this.listeners = new HashSet<CollectionListener>();
        this.iterators = new HashSet<Object>();
        this.featureType = g.getSchema();
    }

    public GridCachingFeatureCollection(BBOX preFilter, Query query, GridFeatureCache g, FeatureSource<SimpleFeatureType, SimpleFeature> fs, boolean cacheFeatures) throws IOException {
        this(preFilter, query.getFilter(), g, fs, cacheFeatures);
        this.query = query;
        CoordinateReferenceSystem source = g.getSchema().getCoordinateReferenceSystem();
        CoordinateReferenceSystem dest = null;
        if (query.getCoordinateSystemReproject() != null) {
            dest = query.getCoordinateSystemReproject();
        } else if (query.getCoordinateSystem() != null) {
            dest = query.getCoordinateSystem();
        }
        if (query.getCoordinateSystem() != null) {
            source = query.getCoordinateSystem();
        }
        if (dest != null && !dest.equals(source)) {
            try {
                this.reproject = CRS.findMathTransform((CoordinateReferenceSystem)source, (CoordinateReferenceSystem)dest);
            }
            catch (FactoryException ex) {
                IOException newex = new IOException("Could not reproject data to " + dest);
                newex.initCause(ex);
                throw newex;
            }
        }
        this.newFeatureType = this.createSchema((SimpleFeatureType)this.featureType, query, dest);
        if (query.getSortBy() != null && query.getSortBy().length > 0) {
            throw new IOException("Sorting not supported by this feature collection.");
        }
        if (query.getStartIndex() != null && query.getStartIndex() > 0) {
            throw new IOException("Start index not supported by this feature collection.");
        }
    }

    private SimpleFeatureType createSchema(SimpleFeatureType current, Query query, CoordinateReferenceSystem destcrs) {
        try {
            if (destcrs != null && !destcrs.equals(current.getCoordinateReferenceSystem())) {
                return DataUtilities.createSubType((SimpleFeatureType)current, (String[])query.getPropertyNames(), (CoordinateReferenceSystem)destcrs, (String)query.getTypeName(), null);
            }
            if (query.retrieveAllProperties()) {
                return current;
            }
            return DataUtilities.createSubType((SimpleFeatureType)current, (String[])query.getPropertyNames());
        }
        catch (SchemaException ex) {
            logger.log(Level.SEVERE, "Error converting feature type to match query request.", ex);
            return null;
        }
    }

    public GridCachingFeatureCollection(Envelope e, GridFeatureCache g) {
        this.grid = g;
        this.preFilter = filterFactory.bbox(g.getSchema().getGeometryDescriptor().getLocalName(), e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), g.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem().toString());
        this.postFilter = filterFactory.bbox(g.getSchema().getGeometryDescriptor().getLocalName(), e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY(), g.getSchema().getGeometryDescriptor().getCoordinateReferenceSystem().toString());
        this.fs = null;
        this.cacheFeatures = false;
        this.listeners = new HashSet<CollectionListener>();
        this.iterators = new HashSet<Object>();
        this.featureType = g.getSchema();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        FeatureIterator<SimpleFeature> feats = this.features();
        try {
            while (feats.hasNext()) {
                SimpleFeature f = (SimpleFeature)feats.next();
                visitor.visit((Feature)f);
            }
        }
        finally {
            feats.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(FeatureIterator<SimpleFeature> close) {
        if (close != null) {
            close.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close(Iterator<SimpleFeature> close) {
        if (close == null) {
            return;
        }
        try {
            this.closeIterator(close);
        }
        catch (Throwable e) {
            logger.log(Level.WARNING, "Failed to close iterator", e);
        }
        finally {
            this.iterators.remove(close);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean contains(Object o) {
        Iterator<SimpleFeature> e = null;
        try {
            e = this.iterator();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsAll(Collection<?> c) {
        Iterator<SimpleFeature> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    public FeatureIterator<SimpleFeature> features() {
        DelegateFeatureIterator iter = new DelegateFeatureIterator((FeatureCollection)this, this.openIterator());
        this.iterators.add(iter);
        return iter;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeIterator(Iterator<SimpleFeature> it) {
        if (it == null) {
            return;
        }
        FeatureReaderFeatureIterator iter = (FeatureReaderFeatureIterator)it;
        if (it.hasNext()) {
            this.grid.unregister(iter.getMissingNodes());
        } else if (iter.getMissingNodes().size() > 0) {
            this.grid.getIndex().flush();
        }
        iter.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Iterator<SimpleFeature> openIterator() {
        FeatureReaderFeatureIterator it = null;
        List<NodeIdentifier> missing = null;
        List<NodeIdentifier> found = null;
        GridCacheFeatureReader cacheFeatureReader = null;
        FeatureReader sourceFeatureReader = null;
        Envelope env = new Envelope(this.preFilter.getMinX(), this.preFilter.getMaxX(), this.preFilter.getMinY(), this.preFilter.getMaxY());
        this.grid.readLock();
        try {
            List<NodeIdentifier>[] notcached = this.grid.matchNodeIds(env);
            missing = notcached[0];
            found = notcached[1];
            this.acquireReadLocks(missing, found);
            if (missing.size() == 0) {
                this.grid.readUnLock();
                cacheFeatureReader = new GridCacheFeatureReader(found, (GridSpatialIndex)this.grid.getIndex());
            } else {
                for (NodeIdentifier nodeid : found) {
                    nodeid.readUnLock();
                }
                this.grid.readUnLock();
                this.grid.writeLock();
                try {
                    this.acquireReadLocks(missing, found);
                    if (missing.size() > 0 && this.fs != null) {
                        this.acquireWriteLocks(missing, found);
                    }
                    if (missing.size() > 0 && this.fs != null) {
                        this.grid.register(missing);
                    }
                }
                finally {
                    this.grid.writeUnLock();
                }
                if (this.fs != null) {
                    DefaultQuery dq = new DefaultQuery(this.featureType.getName().getLocalPart(), this.createFilter(missing));
                    dq.setCoordinateSystem(this.featureType.getCoordinateReferenceSystem());
                    if (this.query != null) {
                        dq.setHints(this.query.getHints());
                        dq.setHandle(this.query.getHandle());
                    } else {
                        dq.setHints(new Hints((RenderingHints.Key)Hints.JTS_COORDINATE_SEQUENCE_FACTORY, (Object)new LiteCoordinateSequenceFactory()));
                    }
                    try {
                        sourceFeatureReader = ((DataStore)this.fs.getDataStore()).getFeatureReader((Query)dq, Transaction.AUTO_COMMIT);
                    }
                    catch (Exception ex) {
                        missing.clear();
                        sourceFeatureReader = null;
                    }
                } else {
                    missing.clear();
                }
                if (found.size() > 0) {
                    cacheFeatureReader = new GridCacheFeatureReader(found, (GridSpatialIndex)this.grid.getIndex());
                }
            }
            boolean localcache = this.cacheFeatures;
            if (this.query != null && this.query.getMaxFeatures() != Integer.MAX_VALUE) {
                localcache = false;
            }
            CombiningCachingFeatureReader fr = null;
            fr = sourceFeatureReader != null && cacheFeatureReader != null ? new CombiningCachingFeatureReader(cacheFeatureReader, sourceFeatureReader, false, localcache, this.grid.getIndex(), this.postFilter) : (sourceFeatureReader != null && cacheFeatureReader == null ? new CombiningCachingFeatureReader((FeatureReader<SimpleFeatureType, SimpleFeature>)new EmptyFeatureReader((FeatureType)((SimpleFeatureType)this.featureType)), sourceFeatureReader, false, localcache, this.grid.getIndex(), this.postFilter) : (sourceFeatureReader == null && cacheFeatureReader != null ? new CombiningCachingFeatureReader(cacheFeatureReader, (FeatureReader<SimpleFeatureType, SimpleFeature>)new EmptyFeatureReader((FeatureType)((SimpleFeatureType)this.featureType)), false, false, this.grid.getIndex(), this.postFilter) : new CombiningCachingFeatureReader((FeatureReader<SimpleFeatureType, SimpleFeature>)new EmptyFeatureReader((FeatureType)((SimpleFeatureType)this.featureType)), (FeatureReader<SimpleFeatureType, SimpleFeature>)new EmptyFeatureReader((FeatureType)((SimpleFeatureType)this.featureType)), false, false, this.grid.getIndex(), this.postFilter)));
            it = new FeatureReaderFeatureIterator(this.wrapFeatureReader(fr), missing, found);
        }
        catch (Exception ex) {
            logger.log(Level.SEVERE, "Failed to create feature collection iterator.", ex);
            if (missing != null) {
                for (NodeIdentifier nodeid : missing) {
                    nodeid.writeUnLock();
                }
            }
            if (found != null) {
                for (NodeIdentifier nodeid : found) {
                    nodeid.readUnLock();
                }
            }
            if (missing != null) {
                this.grid.unregister(missing);
            }
        }
        finally {
            try {
                this.grid.readUnLock();
            }
            catch (Exception ex) {}
        }
        return it;
    }

    private void acquireWriteLocks(List<NodeIdentifier> missing, List<NodeIdentifier> found) throws Exception {
        Iterator<NodeIdentifier> iterator = missing.iterator();
        while (iterator.hasNext()) {
            NodeIdentifier nodeid = iterator.next();
            try {
                nodeid.writeLock();
            }
            catch (Exception ex) {
                iterator.remove();
                logger.log(Level.SEVERE, "Could not acquire necessary write locks.", ex);
                continue;
            }
            if (!nodeid.isValid()) continue;
            nodeid.readLock();
            found.add(nodeid);
            nodeid.writeUnLock();
            iterator.remove();
        }
    }

    private void acquireReadLocks(List<NodeIdentifier> missing, List<NodeIdentifier> found) {
        Iterator<NodeIdentifier> iterator = found.iterator();
        while (iterator.hasNext()) {
            NodeIdentifier nodeid = iterator.next();
            try {
                nodeid.readLock();
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Could not acquire necessary read locks.", ex);
                iterator.remove();
                continue;
            }
            if (nodeid.isValid()) continue;
            nodeid.readUnLock();
            missing.add(nodeid);
            iterator.remove();
        }
    }

    private FeatureReader<SimpleFeatureType, SimpleFeature> wrapFeatureReader(FeatureReader<SimpleFeatureType, SimpleFeature> reader) {
        MaxFeatureReader newfr = reader;
        if (this.query != null && this.query.getMaxFeatures() != Integer.MAX_VALUE) {
            newfr = new MaxFeatureReader(newfr, this.query.getMaxFeatures());
        }
        if (this.reproject != null) {
            newfr = new ReprojectFeatureReader(newfr, (SimpleFeatureType)this.featureType, this.reproject);
        }
        if (this.newFeatureType != null && !this.newFeatureType.equals(this.featureType)) {
            newfr = new ReTypeFeatureReader((FeatureReader)newfr, (SimpleFeatureType)this.newFeatureType);
        }
        return newfr;
    }

    private Filter createFilter(Collection<NodeIdentifier> shapes) {
        String geometryname = this.featureType.getGeometryDescriptor().getLocalName();
        String srs = this.featureType.getGeometryDescriptor().getCoordinateReferenceSystem().toString();
        ArrayList<BBOX> filters = new ArrayList<BBOX>(shapes.size());
        if (shapes.size() < 4) {
            Iterator<NodeIdentifier> iterator = shapes.iterator();
            while (iterator.hasNext()) {
                Region r = (Region)iterator.next().getShape();
                BBOX bbox = filterFactory.bbox(geometryname, r.getLow(0), r.getLow(1), r.getHigh(0), r.getHigh(1), srs);
                filters.add(bbox);
            }
            return filterFactory.or(filters);
        }
        Region area = null;
        Iterator<NodeIdentifier> iterator = shapes.iterator();
        while (iterator.hasNext()) {
            Region r = (Region)iterator.next().getShape();
            if (area == null) {
                area = new Region(r);
                continue;
            }
            area = area.combinedRegion(r);
        }
        return filterFactory.bbox(geometryname, area.getLow(0), area.getLow(1), area.getHigh(0), area.getHigh(1), srs);
    }

    public ReferencedEnvelope getBounds() {
        throw new UnsupportedOperationException("Bounds of this collection not known");
    }

    public String getID() {
        return "cachingFeatureCollection";
    }

    public SimpleFeatureType getSchema() {
        return (SimpleFeatureType)this.newFeatureType;
    }

    public Iterator<SimpleFeature> iterator() {
        Iterator<SimpleFeature> it = this.openIterator();
        this.iterators.add(it);
        return it;
    }

    public Object[] toArray() {
        throw new UnsupportedOperationException("Cannot convert to array.");
    }

    public <O> O[] toArray(O[] a) {
        throw new UnsupportedOperationException("Cannot convert to array.");
    }

    public boolean isEmpty() {
        throw new UnsupportedOperationException("Size unknown.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int size() {
        FeatureIterator<SimpleFeature> fi = this.features();
        int cnt = 0;
        try {
            while (fi.hasNext()) {
                fi.next();
                ++cnt;
            }
        }
        finally {
            this.close(fi);
        }
        return cnt;
    }

    public void removeListener(CollectionListener listener) throws NullPointerException {
        this.listeners.remove(listener);
    }

    public void addListener(CollectionListener listener) throws NullPointerException {
        this.listeners.add(listener);
    }

    public void purge() {
        throw new UnsupportedOperationException("Cannot modify this feature collection");
    }

    public boolean remove(Object o) {
        throw new UnsupportedOperationException("Cannot modify this feature collection");
    }

    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot modify this feature collection");
    }

    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("Cannot modify this feature collection");
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> subCollection(Filter filter) {
        throw new UnsupportedOperationException("Cannot modify this feature collection");
    }

    public FeatureCollection<SimpleFeatureType, SimpleFeature> sort(SortBy order) {
        throw new UnsupportedOperationException("Cannot modify this feature collection");
    }

    public boolean add(SimpleFeature obj) {
        throw new UnsupportedOperationException("Cannot add features to this feature collection");
    }

    public boolean addAll(Collection<? extends SimpleFeature> collection) {
        throw new UnsupportedOperationException("Cannot add features to this feature collection");
    }

    public boolean addAll(FeatureCollection<? extends SimpleFeatureType, ? extends SimpleFeature> resource) {
        throw new UnsupportedOperationException("Cannot add features to this feature collection");
    }

    public void clear() {
        throw new UnsupportedOperationException("Cannot clear this collection");
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class FeatureReaderFeatureIterator
    implements Iterator<SimpleFeature> {
        private FeatureReader<SimpleFeatureType, SimpleFeature> reader = null;
        private Collection<NodeIdentifier> writelocks;
        private Collection<NodeIdentifier> readlocks;

        public FeatureReaderFeatureIterator(FeatureReader<SimpleFeatureType, SimpleFeature> fr, Collection<NodeIdentifier> writeLocks, Collection<NodeIdentifier> readLocks) {
            this.reader = fr;
            this.writelocks = writeLocks;
            this.readlocks = readLocks;
        }

        private void releaseLocks() {
            try {
                for (NodeIdentifier type : this.writelocks) {
                    try {
                        type.writeUnLock();
                    }
                    catch (Exception ex) {}
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Could not release write locks.", ex);
            }
            try {
                for (NodeIdentifier type : this.readlocks) {
                    try {
                        type.readUnLock();
                    }
                    catch (Exception exception) {}
                }
            }
            catch (Exception ex) {
                logger.log(Level.SEVERE, "Could not release read locks.", ex);
            }
        }

        public Collection<NodeIdentifier> getMissingNodes() {
            return this.writelocks;
        }

        @Override
        public boolean hasNext() {
            try {
                if (this.reader == null) {
                    return false;
                }
                return this.reader.hasNext();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "No more items.", ex);
                this.close();
                return false;
            }
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (this.reader == null) {
                throw new NoSuchElementException("Iterator has been closed.");
            }
            try {
                return (SimpleFeature)this.reader.next();
            }
            catch (IOException ex) {
                this.close();
                NoSuchElementException problem = new NoSuchElementException("Could not obtain the next feature:" + ex);
                problem.initCause(ex);
                throw problem;
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Modifications of the contents of this iterator is not supported.");
        }

        public void close() {
            this.releaseLocks();
            if (this.reader == null) {
                return;
            }
            try {
                this.reader.close();
            }
            catch (IOException ex) {
                logger.log(Level.SEVERE, "Error closing reader.", ex);
            }
            this.reader = null;
        }
    }
}

