/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex;

import org.geotools.caching.grid.spatialindex.GridRootNode;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Region;
import org.geotools.caching.spatialindex.Shape;

public class NodeCursor {
    private GridRootNode root;
    private int dimension;
    private int[] mins;
    private int[] maxs;
    private int[] cursor;
    private boolean hasNext;

    public NodeCursor(GridRootNode root, Shape s) {
        this.dimension = root.getShape().getDimension();
        this.root = root;
        this.mins = new int[this.dimension];
        this.maxs = new int[this.dimension];
        this.cursor = new int[this.dimension];
        this.findMatchingTiles(s, this.cursor, this.mins, this.maxs);
        this.hasNext = true;
    }

    private void findMatchingTiles(Shape shape, int[] cursor, int[] mins, int[] maxs) {
        Region shapembr = shape.getMBR();
        for (int i = 0; i < this.dimension; ++i) {
            mins[i] = (int)((shapembr.getLow(i) - this.root.getShape().getMBR().getLow(i)) / this.root.tiles_size);
            cursor[i] = mins[i];
            maxs[i] = (int)((shapembr.getHigh(i) - this.root.getShape().getMBR().getLow(i)) / this.root.tiles_size);
            int maxcnt = this.root.getMaximumTileCount(i);
            if (maxs[i] < maxcnt) continue;
            maxs[i] = maxcnt - 1;
        }
    }

    public int getChildCount() {
        int tiles = 1;
        for (int i = 0; i < this.dimension; ++i) {
            tiles *= this.maxs[i] - this.mins[i] + 1;
        }
        return tiles;
    }

    public NodeIdentifier getNext() {
        NodeIdentifier ret = null;
        if (this.hasNext) {
            ret = this.root.getChildIdentifier(this.root.gridIndexToNodeId(this.cursor));
        }
        int dims = this.cursor.length;
        for (int i = 0; i < dims; ++i) {
            int n = i;
            this.cursor[n] = this.cursor[n] + 1;
            if (this.cursor[i] <= this.maxs[i]) break;
            this.cursor[i] = this.mins[i];
            if (i != dims - 1) continue;
            this.hasNext = false;
            break;
        }
        return ret;
    }
}

