/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex.store;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.geotools.caching.grid.spatialindex.GridNode;
import org.geotools.caching.grid.spatialindex.store.Entry;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.data.DataUtilities;
import org.geotools.feature.SchemaException;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.logging.Logging;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DiskStorage
implements Storage {
    public static final String DATA_FILE_PROPERTY = "DiskStorage.DataFile";
    public static final String INDEX_FILE_PROPERTY = "DiskStorage.IndexFile";
    public static final String PAGE_SIZE_PROPERTY = "DiskStorage.PageSize";
    protected static Logger logger = Logging.getLogger((String)"org.geotools.caching.spatialindex.store");
    private int stats_bytes = 0;
    private int stats_n = 0;
    private int page_size;
    private int nextPage = 0;
    private File dataFile;
    private RandomAccessFile data_file;
    private FileChannel data_channel;
    private File indexFile;
    private TreeSet<Integer> emptyPages;
    private HashMap<NodeIdentifier, Entry> pageIndex;
    private Collection<FeatureType> featureTypes;
    private ReferencedEnvelope bounds;

    private DiskStorage(File f, int page_size) throws IOException {
        this(f, page_size, new File(f.getCanonicalPath() + ".idx"));
    }

    private DiskStorage(File f, File index_file) throws IOException {
        this(f, 1000, index_file);
    }

    private DiskStorage(File f, int page_size, File index_file) throws IOException {
        this.indexFile = index_file;
        this.page_size = page_size;
        this.dataFile = f;
        this.emptyPages = new TreeSet();
        this.pageIndex = new HashMap();
        this.featureTypes = new HashSet<FeatureType>();
        if (index_file.exists()) {
            try {
                this.initializeFromIndex();
            }
            catch (Exception ex) {
                this.indexFile.createNewFile();
                this.dataFile.createNewFile();
                this.emptyPages = new TreeSet();
                this.pageIndex = new HashMap();
                this.featureTypes = new HashSet<FeatureType>();
            }
        }
        this.data_file = new RandomAccessFile(f, "rw");
        this.data_channel = this.data_file.getChannel();
    }

    public static Storage createInstance(Properties pset) {
        try {
            File f = new File(pset.getProperty(DATA_FILE_PROPERTY));
            if (pset.containsKey(INDEX_FILE_PROPERTY)) {
                File index = new File(pset.getProperty(INDEX_FILE_PROPERTY));
                if (index.exists()) {
                    return new DiskStorage(f, index);
                }
                int page_size = Integer.parseInt(pset.getProperty(PAGE_SIZE_PROPERTY));
                return new DiskStorage(f, page_size, index);
            }
            int page_size = Integer.parseInt(pset.getProperty(PAGE_SIZE_PROPERTY));
            return new DiskStorage(f, page_size);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "DiskStorage : error occured when creating new instance : " + e.getMessage(), e);
            return null;
        }
        catch (NullPointerException e) {
            throw new IllegalArgumentException("DiskStorage : invalid property set.", e);
        }
    }

    public static Storage createInstance() {
        try {
            return new DiskStorage(File.createTempFile("storage", ".tmp"), 1000);
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "DiskStorage : error occured when creating new instance : " + e);
            return null;
        }
    }

    @Override
    public synchronized void clear() {
        Iterator<Map.Entry<NodeIdentifier, Entry>> it = this.pageIndex.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry<NodeIdentifier, Entry> next = it.next();
            Entry e = next.getValue();
            for (int n = 0; n < e.pages.size(); ++n) {
                this.emptyPages.add(e.pages.get(n));
            }
            it.remove();
        }
    }

    @Override
    public synchronized Node get(NodeIdentifier id) {
        Node node = null;
        Entry e = this.pageIndex.get(id);
        if (e == null) {
            return null;
        }
        byte[] data = new byte[e.length];
        this.readData(data, e);
        try {
            node = this.readNode(data, id);
        }
        catch (IOException e1) {
            throw new IllegalStateException(e1);
        }
        catch (ClassNotFoundException e1) {
            throw new IllegalStateException(e1);
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error reading node.", ex);
        }
        return node;
    }

    private void readData(byte[] data, Entry e) {
        ByteBuffer buffer = ByteBuffer.allocate(this.page_size);
        int page = 0;
        int rem = data.length;
        int len = 0;
        int index = 0;
        for (int next = 0; next < e.pages.size(); ++next) {
            page = e.pages.get(next);
            len = rem > this.page_size ? this.page_size : rem;
            try {
                buffer.clear();
                this.data_channel.position(page * this.page_size);
                int bytes_read = this.data_channel.read(buffer);
                if (bytes_read != this.page_size) {
                    throw new IllegalStateException("Data file might be corrupted.");
                }
                buffer.rewind();
                buffer.get(data, index, len);
                rem -= bytes_read;
                index += bytes_read;
                continue;
            }
            catch (IOException io) {
                throw new IllegalStateException(io);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Node readNode(byte[] data, NodeIdentifier id) throws IOException, ClassNotFoundException {
        ByteArrayInputStream bais = new ByteArrayInputStream(data);
        ObjectInputStream ois = new ObjectInputStream(bais);
        Node node = null;
        try {
            node = (Node)ois.readObject();
        }
        finally {
            ois.close();
            bais.close();
        }
        id = this.findUniqueInstance(id);
        node.setIdentifier(id);
        return node;
    }

    @Override
    public synchronized void put(Node n) {
        byte[] data = null;
        try {
            data = this.writeNode(n);
        }
        catch (IOException e1) {
            logger.log(Level.SEVERE, "Cannot put data in DiskStorage : " + e1);
            return;
        }
        Entry e = new Entry(n.getIdentifier());
        Entry old = null;
        if (this.pageIndex.containsKey(e.id)) {
            old = this.pageIndex.get(e.id);
            if (old == null) {
                throw new IllegalStateException("old entry null");
            }
        } else if (!this.pageIndex.containsKey(e.id)) {
            this.pageIndex.put(e.id, null);
            old = this.pageIndex.get(e.id);
        }
        this.writeData(data, e, old);
        this.pageIndex.put(e.id, e);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] writeNode(Node n) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ObjectOutputStream oos = new ObjectOutputStream(baos);
        try {
            oos.writeObject(n);
            byte[] data = baos.toByteArray();
            this.stats_bytes += data.length;
            ++this.stats_n;
            byte[] byArray = data;
            return byArray;
        }
        finally {
            oos.close();
            baos.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeData(byte[] data, Entry e, Entry old) {
        ByteBuffer buffer = ByteBuffer.allocate(this.page_size);
        e.length = data.length;
        int rem = data.length;
        int index = 0;
        int next = 0;
        while (rem > 0) {
            int page;
            if (old != null && next < old.pages.size()) {
                page = old.pages.get(next);
                ++next;
            } else if (!this.emptyPages.isEmpty()) {
                TreeSet<Integer> treeSet = this.emptyPages;
                synchronized (treeSet) {
                    Integer i = this.emptyPages.first();
                    page = i;
                    if (!this.emptyPages.remove(i)) {
                        throw new RuntimeException("buggy here !!!!");
                    }
                }
            } else {
                ++this.nextPage;
            }
            int len = rem > this.page_size ? this.page_size : rem;
            buffer.clear();
            buffer.put(data, index, len);
            try {
                buffer.rewind();
                this.data_channel.position(page * this.page_size);
                this.data_channel.write(buffer);
            }
            catch (IOException io) {
                throw new IllegalStateException(io);
            }
            rem -= len;
            index += len;
            e.pages.add(new Integer(page));
        }
        if (old != null) {
            while (next < old.pages.size()) {
                this.emptyPages.add(new Integer(old.pages.get(next)));
                ++next;
            }
        }
    }

    @Override
    public synchronized void remove(NodeIdentifier id) {
        Entry e = this.pageIndex.get(id);
        if (e == null) {
            throw new IllegalArgumentException("Invalid identifier " + id.toString());
        }
        for (int next = 0; next < e.pages.size(); ++next) {
            this.emptyPages.add(new Integer(e.pages.get(next)));
        }
        this.pageIndex.remove(id);
    }

    @Override
    public synchronized void dispose() {
        this.flush();
        try {
            this.data_channel.close();
            this.data_file.close();
        }
        catch (Exception ex) {
            logger.log(Level.WARNING, "Error disposing of disk storage", ex);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void flush() {
        try {
            FileOutputStream os = new FileOutputStream(this.indexFile);
            ObjectOutputStream oos = new ObjectOutputStream(os);
            try {
                oos.writeInt(this.page_size);
                oos.writeInt(this.nextPage);
                oos.writeObject(this.emptyPages);
                oos.writeObject(this.pageIndex);
                oos.writeObject(this.bounds);
                oos.writeInt(this.featureTypes.size());
                for (FeatureType type : this.featureTypes) {
                    String rep = DataUtilities.spec((FeatureType)((SimpleFeatureType)type));
                    oos.writeObject(type.getName().getNamespaceURI() + "." + type.getName().getLocalPart());
                    oos.writeObject(rep);
                }
            }
            finally {
                oos.close();
                os.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Cannot close DiskStorage normally : " + e, e);
        }
    }

    protected void initializeFromIndex() throws IOException {
        FileInputStream is = new FileInputStream(this.indexFile);
        ObjectInputStream ois = new ObjectInputStream(is);
        try {
            this.page_size = ois.readInt();
            this.nextPage = ois.readInt();
            this.emptyPages = (TreeSet)ois.readObject();
            this.pageIndex = (HashMap)ois.readObject();
            this.bounds = (ReferencedEnvelope)ois.readObject();
            int featuretypesize = ois.readInt();
            this.featureTypes = new HashSet<FeatureType>();
            for (int i = 0; i < featuretypesize; ++i) {
                String name = (String)ois.readObject();
                String rep = (String)ois.readObject();
                try {
                    SimpleFeatureType ft = DataUtilities.createType((String)name, (String)rep);
                    this.featureTypes.add((FeatureType)ft);
                    continue;
                }
                catch (SchemaException e) {
                    logger.log(Level.WARNING, "Error initializing feature types from store.", e);
                }
            }
        }
        catch (ClassNotFoundException e) {
            throw (IOException)new IOException().initCause(e);
        }
        finally {
            ois.close();
            is.close();
        }
    }

    @Override
    public Properties getPropertySet() {
        Properties pset = new Properties();
        try {
            pset.setProperty("Storage.Type", DiskStorage.class.getCanonicalName());
            pset.setProperty(DATA_FILE_PROPERTY, this.dataFile.getCanonicalPath());
            pset.setProperty(INDEX_FILE_PROPERTY, this.indexFile.getCanonicalPath());
            pset.setProperty(PAGE_SIZE_PROPERTY, new Integer(this.page_size).toString());
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error while creating DiskStorage property set : " + e);
        }
        return pset;
    }

    @Override
    public NodeIdentifier findUniqueInstance(NodeIdentifier id) {
        if (this.pageIndex.containsKey(id)) {
            return this.pageIndex.get((Object)id).id;
        }
        return id;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logPageAccess(int page, int length) throws IOException {
        File log = new File("log/" + page + ".log");
        FileWriter fw = new FileWriter(log, true);
        try {
            fw.write(System.currentTimeMillis() + " : " + Thread.currentThread().getName() + " writing " + length + " bytes.\n");
        }
        finally {
            fw.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void logGet() throws IOException {
        FileWriter getlog = new FileWriter("log/get.log", true);
        try {
            getlog.write(Thread.currentThread().getName() + " : " + System.currentTimeMillis() + "\n");
        }
        finally {
            getlog.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeReadable(Node n, int page) {
        try {
            FileWriter fw = new FileWriter("log/" + page + ".node");
            try {
                fw.write(((GridNode)n).toReadableText());
            }
            finally {
                fw.close();
            }
        }
        catch (IOException e) {
            logger.log(Level.WARNING, "Error writing node.", e);
        }
    }

    @Override
    public void addFeatureType(FeatureType ft) {
        this.featureTypes.add(ft);
    }

    @Override
    public Collection<FeatureType> getFeatureTypes() {
        return Collections.unmodifiableCollection(this.featureTypes);
    }

    @Override
    public void clearFeatureTypes() {
        this.featureTypes.clear();
    }

    @Override
    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }
}

