/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.caching.grid.spatialindex.store;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Properties;
import org.geotools.caching.spatialindex.Node;
import org.geotools.caching.spatialindex.NodeIdentifier;
import org.geotools.caching.spatialindex.SpatialIndex;
import org.geotools.caching.spatialindex.Storage;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.type.FeatureType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemoryStorage
implements Storage {
    private HashMap<NodeIdentifier, Node> map = new HashMap();
    private ArrayList<FeatureType> featureTypes = new ArrayList();
    private ReferencedEnvelope bounds = null;

    private MemoryStorage() {
    }

    public static Storage createInstance(Properties pset) {
        return new MemoryStorage();
    }

    public static Storage createInstance() {
        return new MemoryStorage();
    }

    @Override
    public Node get(NodeIdentifier id) {
        return this.map.get(id);
    }

    @Override
    public void put(Node n) {
        if (!this.map.containsKey(n.getIdentifier())) {
            this.map.put(n.getIdentifier(), n);
        }
    }

    @Override
    public void remove(NodeIdentifier id) {
        this.map.remove(id);
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public void setParent(SpatialIndex index) {
    }

    @Override
    public void flush() {
    }

    @Override
    public void dispose() {
        this.clear();
    }

    @Override
    public Properties getPropertySet() {
        Properties pset = new Properties();
        pset.setProperty("Storage.Type", MemoryStorage.class.getCanonicalName());
        return pset;
    }

    @Override
    public NodeIdentifier findUniqueInstance(NodeIdentifier id) {
        if (this.map.containsKey(id)) {
            return this.map.get(id).getIdentifier();
        }
        return id;
    }

    @Override
    public void addFeatureType(FeatureType ft) {
        this.featureTypes.add(ft);
    }

    @Override
    public Collection<FeatureType> getFeatureTypes() {
        return Collections.unmodifiableCollection(this.featureTypes);
    }

    @Override
    public void clearFeatureTypes() {
        this.featureTypes.clear();
    }

    @Override
    public ReferencedEnvelope getBounds() {
        return this.bounds;
    }

    @Override
    public void setBounds(ReferencedEnvelope bounds) {
        this.bounds = bounds;
    }
}

