/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.ListIterator;
import org.geotools.image.io.mosaic.MosaicBuilder;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.image.io.mosaic.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class GridNode
extends TreeNode
implements Comparable<GridNode> {
    private final int index;
    private short xSubsampling;
    private short ySubsampling;
    private boolean overlaps;
    private boolean dense;
    private static final Comparator<GridNode> PRE_PROCESSING = new Comparator<GridNode>(){

        @Override
        public int compare(GridNode n1, GridNode n2) {
            int s2;
            int s1 = (n1.xSubsampling & 0xFFFF) * (n1.ySubsampling & 0xFFFF);
            if (s1 > (s2 = (n2.xSubsampling & 0xFFFF) * (n2.ySubsampling & 0xFFFF))) {
                return -1;
            }
            if (s1 < s2) {
                return 1;
            }
            long a1 = (long)n1.width * (long)n1.height;
            long a2 = (long)n2.width * (long)n2.height;
            if (a1 > a2) {
                return -1;
            }
            if (a1 < a2) {
                return 1;
            }
            return n1.index - n2.index;
        }
    };

    @Override
    public int compareTo(GridNode that) {
        return this.index - that.index;
    }

    private GridNode(Rectangle bounds) {
        super(bounds);
        this.index = -1;
    }

    private GridNode(Tile tile, int index) throws IOException {
        super(tile.getAbsoluteRegion());
        this.tile = tile;
        Dimension subsampling = tile.getSubsampling();
        this.xSubsampling = Tile.ensureStrictlyPositive(subsampling.width);
        this.ySubsampling = Tile.ensureStrictlyPositive(subsampling.height);
        this.index = index;
    }

    public GridNode(Tile[] tiles) throws IOException {
        int i;
        GridNode[] nodes = new GridNode[tiles.length];
        for (int i2 = 0; i2 < tiles.length; ++i2) {
            nodes[i2] = new GridNode(tiles[i2], i2);
        }
        Arrays.sort(nodes, PRE_PROCESSING);
        boolean isFlat = GridNode.isFlat(nodes);
        if (isFlat) {
            nodes = GridNode.prependTree(nodes);
        }
        GridNode root = null;
        if (nodes.length != 0) {
            root = nodes[0];
            for (i = 1; i < nodes.length; ++i) {
                if (root.contains(nodes[i])) continue;
                root = null;
                break;
            }
        }
        if (root != null) {
            this.setBounds(root);
            this.tile = root.tile;
            this.index = root.index;
            this.xSubsampling = root.xSubsampling;
            this.ySubsampling = root.ySubsampling;
        } else {
            this.index = -1;
        }
        int n = i = root != null ? 1 : 0;
        while (i < nodes.length) {
            GridNode child = nodes[i];
            GridNode parent = this.smallest(child);
            if (!parent.overlaps) {
                for (TreeNode existing = parent.firstChildren(); existing != null; existing = existing.nextSibling()) {
                    if (!child.intersects(existing) || child.equals(existing)) continue;
                    parent.overlaps = true;
                    break;
                }
            }
            parent.addChild(child);
            ++i;
        }
        if (isFlat) {
            this.removeEmpty();
        }
        if (root == null) {
            assert ((this.width | this.height) < 0) : this;
            for (TreeNode child = this.firstChildren(); child != null; child = child.nextSibling()) {
                this.add(child);
            }
        }
        this.splitOverlappingChildren();
        this.postTreeCreation();
        assert (this.checkValidity()) : this.toTree();
    }

    private GridNode smallest(Rectangle bounds) {
        boolean gridded;
        long smallestArea;
        if (this.isEmpty()) {
            smallestArea = Long.MAX_VALUE;
            gridded = false;
        } else {
            assert (this.contains(bounds));
            smallestArea = (long)this.width * (long)this.height;
            gridded = this.isGridded(bounds);
        }
        GridNode smallest = this;
        for (GridNode child = (GridNode)this.firstChildren(); child != null; child = (GridNode)child.nextSibling()) {
            if (!child.contains(bounds)) continue;
            GridNode candidate = child.smallest(bounds);
            boolean cg = candidate.isGridded(bounds);
            if (gridded && !cg) continue;
            long area = (long)candidate.width * (long)candidate.height;
            if ((gridded || !cg) && area >= smallestArea) continue;
            smallestArea = area;
            smallest = candidate;
            gridded = cg;
        }
        return smallest;
    }

    private boolean isGridded(Rectangle child) {
        return this.width % child.width == 0 && (child.x - this.x) % child.width == 0 && this.height % child.height == 0 && (child.y - this.y) % child.height == 0;
    }

    private int distance(Rectangle rect) {
        int dx = rect.x - this.x;
        if (dx >= 0) {
            dx -= this.width;
        } else {
            dx += rect.width;
            dx = -dx;
        }
        int dy = rect.y - this.y;
        if (dy >= 0) {
            dy -= this.height;
        } else {
            dy += rect.height;
            dy = -dy;
        }
        int distance = Math.max(dx, dy);
        assert (!this.intersects(rect) ? distance >= 0 : dx < 0 && dy < 0) : distance;
        return distance;
    }

    private void splitOverlappingChildren() {
        GridNode child;
        assert (this.isLeaf() || !this.isEmpty()) : this;
        for (child = (GridNode)this.firstChildren(); child != null; child = (GridNode)child.nextSibling()) {
            child.splitOverlappingChildren();
        }
        if (!this.overlaps) {
            return;
        }
        LinkedList<GridNode> toProcess = new LinkedList<GridNode>();
        ArrayList<GridNode> retained = new ArrayList<GridNode>();
        for (child = (GridNode)this.firstChildren(); child != null; child = (GridNode)child.nextSibling()) {
            toProcess.add(child);
        }
        this.removeChildren();
        int bestIndex = 0;
        int bestDistance = 0;
        while (!toProcess.isEmpty()) {
            ListIterator it;
            LinkedList<GridNode> removed = new LinkedList<GridNode>();
            GridNode added = (GridNode)toProcess.remove(0);
            retained.add(added);
            while ((it = toProcess.listIterator()).hasNext()) {
                GridNode best = null;
                do {
                    GridNode candidate;
                    int distance;
                    if ((distance = added.distance(candidate = (GridNode)it.next())) < 0) {
                        if (added.equals(candidate)) {
                            retained.add(candidate);
                        } else {
                            removed.add(candidate);
                        }
                        it.remove();
                        continue;
                    }
                    if (best != null && distance >= bestDistance) continue;
                    bestDistance = distance;
                    bestIndex = it.previousIndex();
                    best = candidate;
                } while (it.hasNext());
                if (best == null) break;
                if (toProcess.remove(bestIndex) != best) {
                    throw new AssertionError(bestIndex);
                }
                retained.add(best);
                added = best;
            }
            assert (toProcess.isEmpty()) : toProcess;
            assert (Collections.disjoint(retained, removed));
            GridNode[] sorted = retained.toArray(new GridNode[retained.size()]);
            retained.clear();
            Arrays.sort(sorted, PRE_PROCESSING);
            child = new GridNode(this);
            assert (child.isLeaf());
            for (GridNode newChild : sorted) {
                child.addChild(newChild);
            }
            this.addChild(child);
            toProcess = removed;
        }
        this.overlaps = false;
    }

    private void removeEmpty() {
        GridNode child = (GridNode)this.firstChildren();
        while (child != null) {
            GridNode next = (GridNode)child.nextSibling();
            child.removeEmpty();
            child = next;
        }
        if (this.tile == null && this.isLeaf() && !this.isRoot()) {
            this.remove();
        }
    }

    private void postTreeCreation() {
        for (GridNode child = (GridNode)this.firstChildren(); child != null; child = (GridNode)child.nextSibling()) {
            child.postTreeCreation();
            if ((child.xSubsampling & 0xFFFF) > (this.xSubsampling & 0xFFFF)) {
                this.xSubsampling = child.xSubsampling;
            }
            if ((child.ySubsampling & 0xFFFF) <= (this.ySubsampling & 0xFFFF)) continue;
            this.ySubsampling = child.ySubsampling;
        }
        this.dense = GridNode.isDense(this, this);
    }

    public boolean intersects(Rectangle region, Dimension subsampling) {
        if (this.intersects(region)) {
            if (this.tile != null) {
                int ySubsampling;
                int xSubsampling;
                if (this.isLeaf()) {
                    xSubsampling = this.xSubsampling & 0xFFFF;
                    ySubsampling = this.ySubsampling & 0xFFFF;
                } else {
                    Dimension candidate = this.tile.getSubsampling();
                    xSubsampling = candidate.width;
                    ySubsampling = candidate.height;
                }
                if (xSubsampling <= subsampling.width && ySubsampling <= subsampling.height) {
                    return true;
                }
            }
            for (GridNode child = (GridNode)this.firstChildren(); child != null; child = (GridNode)child.nextSibling()) {
                if (!child.intersects(region, subsampling)) continue;
                return true;
            }
        }
        return false;
    }

    public int getXSubsampling() {
        return this.xSubsampling & 0xFFFF;
    }

    public int getYSubsampling() {
        return this.ySubsampling & 0xFFFF;
    }

    @Override
    public boolean hasOverlaps() {
        return this.overlaps;
    }

    private static boolean isFlat(GridNode[] nodes) {
        if (nodes != null && nodes.length != 0) {
            GridNode node = nodes[0];
            short xSubsampling = node.xSubsampling;
            short ySubsampling = node.ySubsampling;
            for (int i = 1; i < nodes.length; ++i) {
                node = nodes[i];
                if (node.xSubsampling == xSubsampling && node.ySubsampling == ySubsampling) continue;
                return false;
            }
        }
        return true;
    }

    private static GridNode[] prependTree(GridNode[] nodes) {
        Dimension largest = new Dimension();
        Rectangle bounds = new Rectangle(-1, -1);
        for (GridNode node : nodes) {
            bounds.add(node);
            if (node.width > largest.width) {
                largest.width = node.width;
            }
            if (node.height <= largest.height) continue;
            largest.height = node.height;
        }
        if (!bounds.isEmpty()) {
            largest.width *= 2;
            largest.height *= 2;
            int[][] divisors = MosaicBuilder.suggestedNumTiles(bounds, largest, 16, false);
            int[] sx = divisors[0];
            int[] sy = divisors[1];
            Rectangle part = new Rectangle();
            ArrayList<GridNode> list = new ArrayList<GridNode>();
            for (int i = 0; i < sx.length; ++i) {
                int nx = sx[i];
                int ny = sy[i];
                part.y = bounds.y;
                part.width = bounds.width / nx;
                part.height = bounds.height / ny;
                for (int y = 0; y < ny; ++y) {
                    part.x = bounds.x;
                    for (int x = 0; x < nx; ++x) {
                        list.add(new GridNode(part));
                        part.x += part.width;
                    }
                    part.y += part.height;
                }
            }
            int size = list.size();
            GridNode[] old = nodes;
            nodes = list.toArray(new GridNode[size + old.length]);
            System.arraycopy(old, 0, nodes, size, old.length);
        }
        return nodes;
    }

    private static boolean isDense(Rectangle roi, Iterable<? extends Rectangle> regions) {
        Rectangle bounds = null;
        for (Rectangle rectangle : regions) {
            Rectangle inter = roi.intersection(rectangle);
            if (bounds == null) {
                bounds = inter;
                continue;
            }
            bounds.add(inter);
        }
        return bounds == null || bounds.equals(roi);
    }

    public boolean isDense(Rectangle roi) {
        assert (this.contains(roi));
        return this.dense;
    }
}

