/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.image.io.mosaic;

import java.awt.Dimension;
import java.awt.geom.AffineTransform;
import org.geotools.image.io.mosaic.Tile;
import org.geotools.referencing.operation.matrix.XAffineTransform;

final class TranslatedTransform {
    private final AffineTransform gridToCRS;
    private final int dx;
    private final int dy;

    TranslatedTransform(Dimension subsampling, AffineTransform reference, int dx, int dy) {
        this.dx = dx / subsampling.width;
        this.dy = dy / subsampling.height;
        reference = new AffineTransform(reference);
        reference.scale(subsampling.width, subsampling.height);
        reference.translate(dx %= subsampling.width, dy %= subsampling.height);
        this.gridToCRS = new XAffineTransform(reference);
    }

    final void applyTo(Tile tile) {
        tile.translate(this.dx, this.dy);
        tile.setGridToCRS(this.gridToCRS);
    }
}

